/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.data.resource;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.zepalesque.redux.misc.ReduxTags;
import net.zepalesque.redux.world.carver.ReduxCarvers;

public class ReduxConfiguredCarvers {
    public static final ResourceKey<ConfiguredWorldCarver<?>> AETHER_CAVES = ReduxConfiguredCarvers.createKey("aether_caves");

    private static ResourceKey<ConfiguredWorldCarver<?>> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257003_, (ResourceLocation)new ResourceLocation("aether_redux", name));
    }

    public static void bootstrap(BootstapContext<ConfiguredWorldCarver<?>> context) {
        HolderGetter blocks = context.m_255420_(Registries.f_256747_);
        context.m_255272_(AETHER_CAVES, ReduxConfiguredCarvers.createAetherCaves((HolderGetter<Block>)blocks));
    }

    public static ConfiguredWorldCarver<?> createAetherCaves(HolderGetter<Block> blocks) {
        UniformHeight y = UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158930_((int)8), (VerticalAnchor)VerticalAnchor.m_158922_((int)180));
        UniformFloat yScale = UniformFloat.m_146605_((float)0.1f, (float)0.9f);
        UniformFloat horizRadMult = UniformFloat.m_146605_((float)0.7f, (float)1.4f);
        UniformFloat vertRadMult = UniformFloat.m_146605_((float)0.8f, (float)1.3f);
        UniformFloat floor = UniformFloat.m_146605_((float)-1.0f, (float)-0.4f);
        CaveCarverConfiguration config = new CaveCarverConfiguration(0.2f, (HeightProvider)y, (FloatProvider)yScale, VerticalAnchor.m_158930_((int)0), (HolderSet)blocks.m_254956_(ReduxTags.Blocks.AETHER_CARVER_REPLACEABLES), (FloatProvider)horizRadMult, (FloatProvider)vertRadMult, (FloatProvider)floor);
        return new ConfiguredWorldCarver((WorldCarver)ReduxCarvers.AETHER_CAVE.get(), (CarverConfiguration)config);
    }
}

