/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.data;

import com.aetherteam.aether.data.providers.AetherItemModelProvider;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.ItemLayerModelBuilder;
import net.minecraftforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.blockhandler.WoodHandler;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.block.redstone.LogicatorBlock;
import net.zepalesque.redux.data.ReduxBlockstateData;
import net.zepalesque.redux.item.ReduxItems;

public class ReduxItemModelData
extends AetherItemModelProvider {
    public ReduxItemModelData(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    protected void registerModels() {
        this.itemBlockFlatCustomTexture((Supplier<? extends Block>)ReduxBlocks.SHORT_AETHER_GRASS, "natural/aether_medium_grass");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.BLIGHTED_AETHER_GRASS_BLOCK);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.HOLYSILT);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.DRIFTSHALE);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.POLISHED_DRIFTSHALE);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.POLISHED_DRIFTSHALE_SLAB);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.POLISHED_DRIFTSHALE_STAIRS);
        this.itemWallBlock((Supplier<? extends Block>)ReduxBlocks.POLISHED_DRIFTSHALE_WALL, (Supplier<? extends Block>)ReduxBlocks.POLISHED_DRIFTSHALE, "natural/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.DIVINITE);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.DIVINITE_SLAB);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.DIVINITE_STAIRS);
        this.itemWallBlock((Supplier<? extends Block>)ReduxBlocks.DIVINITE_WALL, (Supplier<? extends Block>)ReduxBlocks.DIVINITE, "natural/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.SENTRITE);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.SENTRITE_SLAB);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.SENTRITE_STAIRS);
        this.itemWallBlock((Supplier<? extends Block>)ReduxBlocks.SENTRITE_WALL, (Supplier<? extends Block>)ReduxBlocks.SENTRITE, "natural/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.POLISHED_SENTRITE);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.POLISHED_SENTRITE_SLAB);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.POLISHED_SENTRITE_STAIRS);
        this.itemWallBlock((Supplier<? extends Block>)ReduxBlocks.POLISHED_SENTRITE_WALL, (Supplier<? extends Block>)ReduxBlocks.POLISHED_SENTRITE, "construction/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.SENTRITE_BRICKS);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.SENTRITE_BRICK_SLAB);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.SENTRITE_BRICK_STAIRS);
        this.itemWallBlock((Supplier<? extends Block>)ReduxBlocks.SENTRITE_BRICK_WALL, (Supplier<? extends Block>)ReduxBlocks.SENTRITE_BRICKS, "construction/");
        this.itemBlockFlatTintOverlay((Supplier<? extends Block>)ReduxBlocks.IRIDIA, "natural/");
        this.itemBlockFlatTintOverlay((Supplier<? extends Block>)ReduxBlocks.XAELIA_PATCH, "natural/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.GILDED_HOLYSTONE);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.GILDED_HOLYSTONE_SLAB);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.GILDED_HOLYSTONE_STAIRS);
        this.itemWallBlock((Supplier<? extends Block>)ReduxBlocks.GILDED_HOLYSTONE_WALL, (Supplier<? extends Block>)ReduxBlocks.GILDED_HOLYSTONE, "natural/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.BLIGHTMOSS_HOLYSTONE);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.BLIGHTMOSS_HOLYSTONE_SLAB);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.BLIGHTMOSS_HOLYSTONE_STAIRS);
        this.itemWallBlock((Supplier<? extends Block>)ReduxBlocks.BLIGHTMOSS_HOLYSTONE_WALL, (Supplier<? extends Block>)ReduxBlocks.BLIGHTMOSS_HOLYSTONE, "natural/");
        this.item((Supplier<? extends Item>)ReduxItems.BLUE_SWET_JELLY, "food/");
        this.item((Supplier<? extends Item>)ReduxItems.GOLDEN_SWET_JELLY, "food/");
        this.item((Supplier<? extends Item>)ReduxItems.GOLDEN_SWET_BALL, "materials/");
        this.item((Supplier<? extends Item>)ReduxItems.VANILLA_SWET_BALL, "materials/");
        this.item((Supplier<? extends Item>)ReduxItems.VANILLA_SWET_JELLY, "food/");
        this.item((Supplier<? extends Item>)ReduxItems.VANILLA_GUMMY_SWET, "food/");
        this.vampireAmulet((Supplier<? extends Item>)ReduxItems.VAMPIRE_AMULET, "accessories/");
        this.item((Supplier<? extends Item>)ReduxItems.ENCHANTED_RING, "accessories/");
        this.item((Supplier<? extends Item>)ReduxItems.SHROOM_RING, "accessories/");
        this.item((Supplier<? extends Item>)ReduxItems.RING_OF_WISDOM, "accessories/");
        this.dartShooterGlow((Supplier<? extends Item>)ReduxItems.INFUSED_VERIDIUM_DART_SHOOTER, "weapons/");
        this.dartShooterItem((Item)ReduxItems.VERIDIUM_DART_SHOOTER.get(), "weapons/");
        this.item((Supplier<? extends Item>)ReduxItems.VERIDIUM_DART, "weapons/");
        this.item((Supplier<? extends Item>)ReduxItems.SENTRY_CHIP, "materials/");
        this.item((Supplier<? extends Item>)ReduxItems.WYND_OATS, "food/");
        this.item((Supplier<? extends Item>)ReduxItems.BLUEBERRY_PIE, "food/");
        this.item((Supplier<? extends Item>)ReduxItems.ENCHANTED_BLUEBERRY_PIE, "food/");
        this.itemBlockFlatCustomTexture((Supplier<? extends Block>)ReduxBlocks.GOLDEN_CLOVER, "natural/golden_clover_top");
        this.enchanableOrTintableFlower((Supplier<? extends Block>)ReduxBlocks.AURUM, "natural/");
        this.enchanableOrTintableFlower((Supplier<? extends Block>)ReduxBlocks.ZYATRIX, "natural/");
        this.eggItem((Supplier<? extends Item>)ReduxItems.VANILLA_SWET_SPAWN_EGG);
        this.eggItem((Supplier<? extends Item>)ReduxItems.SHIMMERCOW_SPAWN_EGG);
        this.eggItem((Supplier<? extends Item>)ReduxItems.MYKAPOD_SPAWN_EGG);
        this.eggItem((Supplier<? extends Item>)ReduxItems.BLIGHTBUNNY_SPAWN_EGG);
        this.rotatedItem((Item)ReduxItems.GRAND_VICTORY_MEDAL.get(), "accessories/");
        this.item((Supplier<? extends Item>)ReduxItems.SENTRY_RING, "accessories/");
        this.item((Supplier<? extends Item>)ReduxItems.RING_OF_CONSTRUCTION, "accessories/");
        this.item((Supplier<? extends Item>)ReduxItems.AIRBOUND_CAPE, "accessories/");
        this.item((Supplier<? extends Item>)ReduxItems.SOLAR_EMBLEM, "accessories/");
        this.item((Supplier<? extends Item>)ReduxItems.ANCIENT_SENTRITE_MUSIC_DISC, "misc/");
        this.item((Supplier<? extends Item>)ReduxItems.MOUSE_EAR_SOUP, "food/");
        this.item((Supplier<? extends Item>)ReduxItems.OATMEAL, "food/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.COARSE_AETHER_DIRT);
        this.aercloudItem((Block)ReduxBlocks.BLIGHTED_AERCLOUD.get());
        this.item((Supplier<? extends Item>)ReduxItems.BLIGHTBUNNY_FANG, "materials/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.SHELL_SHINGLES);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.SHELL_SHINGLE_SLAB);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.SHELL_SHINGLE_STAIRS);
        this.itemWallBlock((Supplier<? extends Block>)ReduxBlocks.SHELL_SHINGLE_WALL, (Supplier<? extends Block>)ReduxBlocks.SHELL_SHINGLES, "construction/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.ENCHANTED_SHELL_SHINGLES);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.ENCHANTED_SHELL_SHINGLE_SLAB);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.ENCHANTED_SHELL_SHINGLE_STAIRS);
        this.itemWallBlock((Supplier<? extends Block>)ReduxBlocks.ENCHANTED_SHELL_SHINGLE_WALL, (Supplier<? extends Block>)ReduxBlocks.ENCHANTED_SHELL_SHINGLES, "construction/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.BLIGHTWILLOW_LEAVES);
        this.spear((Supplier<? extends Item>)ReduxItems.SPEAR_OF_THE_BLIGHT, "weapons/");
        this.item((Item)ReduxItems.REFINED_SENTRITE.get(), "materials/");
        this.item((Item)ReduxItems.SENTRITE_CHUNK.get(), "materials/");
        this.itemBlock((Block)ReduxBlocks.REFINED_SENTRITE_BLOCK.get());
        this.item(((Block)ReduxBlocks.SENTRITE_LANTERN.get()).m_5456_(), "misc/");
        this.item(((Block)ReduxBlocks.SENTRITE_CHAIN.get()).m_5456_(), "misc/");
        this.itemBlockWithParent((Block)ReduxBlocks.GOLDEN_LEAF_PILE.get(), block -> this.modLoc("block/" + this.blockName((Block)block) + "1"));
        this.itemBlockWithParent((Block)ReduxBlocks.GILDED_LEAF_PILE.get(), block -> this.modLoc("block/" + this.blockName((Block)block) + "1"));
        this.itemBlockWithParent((Block)ReduxBlocks.BLIGHTWILLOW_LEAF_PILE.get(), block -> this.modLoc("block/" + this.blockName((Block)block) + "1"));
        this.itemBlockFlatGlow((Supplier<? extends Block>)ReduxBlocks.CLOUDCAP_MUSHLING, "natural/");
        this.itemBlockFlat((Supplier<? extends Block>)ReduxBlocks.BLIGHTWILLOW_SAPLING, "natural/");
        this.itemBlockFlat((Block)ReduxBlocks.FIELDSPROOT_SAPLING.get(), "natural/");
        this.itemBlockFlat((Block)ReduxBlocks.CRYSTAL_SAPLING.get(), "natural/");
        this.itemBlockFlat((Block)ReduxBlocks.CRYSTAL_FRUIT_SAPLING.get(), "natural/");
        this.itemBlockFlat((Block)ReduxBlocks.PURPLE_CRYSTAL_FRUIT_SAPLING.get(), "natural/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.GLACIA_LEAVES);
        this.itemBlockFlat((Block)ReduxBlocks.GLACIA_SAPLING.get(), "natural/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.PURPLE_GLACIA_LEAVES);
        this.itemBlockFlat((Block)ReduxBlocks.PURPLE_GLACIA_SAPLING.get(), "natural/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.AVELIUM);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.CLOUD_CAP_BLOCK);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.CLOUDCAP_SPORES);
        this.itemBlockFlat((Supplier<? extends Block>)ReduxBlocks.JELLYSHROOM, "natural/");
        this.itemBlockFlatGlow((Supplier<? extends Block>)ReduxBlocks.SHIMMERSTOOL, "natural/");
        this.itemBlockFlatTintGlow((Supplier<? extends Block>)ReduxBlocks.LUXWEED, "natural/");
        this.itemBlockFlatTintOverlay((Supplier<? extends Block>)ReduxBlocks.SPIROLYCTIL, "natural/");
        this.itemBlockFlatTintOverlay((Supplier<? extends Block>)ReduxBlocks.BLIGHTSHADE, "natural/");
        this.blockCustomTexture((Supplier<? extends Block>)ReduxBlocks.FIELDSPROOT_LEAVES, "natural/", "fieldsproot_leaves");
        this.itemCustomTexture((Supplier<? extends ItemLike>)ReduxBlocks.FIELDSPROOT_PETALS, "misc/", "fieldsproot_petals");
        this.item((Item)ReduxItems.VERIDIUM_NUGGET.get(), "materials/");
        this.itemBlockFlatItemTexture((Supplier<? extends Block>)ReduxBlocks.VERIDIUM_LANTERN, "misc/");
        this.itemBlockFlatItemTexture((Supplier<? extends Block>)ReduxBlocks.VERIDIUM_CHAIN, "misc/");
        this.itemBlock((Block)ReduxBlocks.ZANBERRY_BUSH.get());
        this.itemBlockFlat((Block)ReduxBlocks.ZANBERRY_BUSH_STEM.get(), "natural/");
        this.itemFullGlow((Supplier<? extends Item>)ReduxItems.BLIGHTED_SPORES, "materials/");
        this.itemFullGlow((Supplier<? extends Item>)ReduxItems.LIGHTROOT_CLUMP, "food/");
        this.itemBlockFlat((Block)ReduxBlocks.AVELIUM_ROOTS.get(), "natural/");
        this.item(((Block)ReduxBlocks.AVELIUM_SPROUTS.get()).m_5456_(), "misc/");
        this.aercloudItem((Block)ReduxBlocks.JELLYSHROOM_JELLY_BLOCK.get());
        this.itemBlock((Block)ReduxBlocks.BLIGHTMOSS_BLOCK.get());
        this.itemBlock((Block)ReduxBlocks.BLIGHTMOSS_CARPET.get());
        this.itemBlock((Block)ReduxBlocks.FUNGAL_GROWTH.get());
        this.itemBlock((Block)ReduxBlocks.FUNGAL_CARPET.get());
        this.itemBlock((Block)ReduxBlocks.GILDED_OAK_LEAVES.get());
        this.itemBlockFlat((Block)ReduxBlocks.GILDED_OAK_SAPLING.get(), "natural/");
        this.itemBlockFlat((Block)ReduxBlocks.BLIGHTED_SKYROOT_SAPLING.get(), "natural/");
        this.itemBlock((Block)ReduxBlocks.BLIGHTED_SKYROOT_LEAVES.get());
        this.itemBlockFlatTintGlowOverlay((Supplier<? extends Block>)ReduxBlocks.LUMINA, "natural/");
        this.itemBlockFlatTintOverlay((Supplier<? extends Block>)ReduxBlocks.DAGGERBLOOM, "natural/");
        this.itemBlockFlatTintOverlay((Supplier<? extends Block>)ReduxBlocks.THERATIP, "natural/");
        this.itemBlockFlatTintGlowOverlay((Supplier<? extends Block>)ReduxBlocks.FLAREBLOSSOM, "natural/");
        this.itemBlockFlatTintOverlay((Supplier<? extends Block>)ReduxBlocks.INFERNIA, "natural/");
        this.itemBlockFlatTintOverlay((Supplier<? extends Block>)ReduxBlocks.WYNDSPROUTS, "natural/");
        this.itemBlockFlatTintOverlay((Supplier<? extends Block>)ReduxBlocks.SKYSPROUTS, "natural/");
        this.itemBlockFlat((Supplier<? extends Block>)ReduxBlocks.SPLITFERN, "natural/");
        this.item((Supplier<? extends Item>)ReduxItems.WYND_OAT_PANICLE, "materials/");
        this.itemBlockFlatOtherBlockTexture((Supplier<? extends Block>)ReduxBlocks.GOLDEN_VINES, (Supplier<? extends Block>)ReduxBlocks.GOLDEN_VINES_PLANT, "natural/");
        this.itemBlockFlatOtherBlockTexture((Supplier<? extends Block>)ReduxBlocks.GILDED_VINES, (Supplier<? extends Block>)ReduxBlocks.GILDED_VINES_PLANT, "natural/");
        this.itemBlockFlatGlowOtherTexture((Supplier<? extends Block>)ReduxBlocks.CORRUPTED_VINES, (Supplier<? extends Block>)ReduxBlocks.CORRUPTED_VINES_PLANT, "natural/");
        this.handheldItem((Item)ReduxItems.VERIDIUM_SWORD.get(), "weapons/");
        this.handheldItem((Item)ReduxItems.VERIDIUM_PICKAXE.get(), "tools/");
        this.handheldItem((Item)ReduxItems.VERIDIUM_AXE.get(), "tools/");
        this.handheldItem((Item)ReduxItems.VERIDIUM_SHOVEL.get(), "tools/");
        this.handheldItem((Item)ReduxItems.VERIDIUM_HOE.get(), "tools/");
        this.handheldGlow((Supplier<? extends Item>)ReduxItems.INFUSED_VERIDIUM_SWORD, "weapons/");
        this.handheldGlow((Supplier<? extends Item>)ReduxItems.INFUSED_VERIDIUM_PICKAXE, "tools/");
        this.handheldGlow((Supplier<? extends Item>)ReduxItems.INFUSED_VERIDIUM_AXE, "tools/");
        this.handheldGlow((Supplier<? extends Item>)ReduxItems.INFUSED_VERIDIUM_SHOVEL, "tools/");
        this.handheldGlow((Supplier<? extends Item>)ReduxItems.INFUSED_VERIDIUM_HOE, "tools/");
        this.item((Supplier<? extends Item>)ReduxItems.VERIDIUM_INGOT, "materials/");
        this.item((Supplier<? extends Item>)ReduxItems.RAW_VERIDIUM, "materials/");
        this.item((Supplier<? extends Item>)ReduxItems.RAW_GRAVITITE, "materials/");
        this.item((Supplier<? extends Item>)ReduxItems.RAW_VALKYRUM, "materials/");
        this.item((Supplier<? extends Item>)ReduxItems.GRAVITITE_INGOT, "materials/");
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.GRAVITITE_BLOCK);
        this.itemBlock((Supplier<? extends Block>)ReduxBlocks.RAW_GRAVITITE_BLOCK);
        this.item((Supplier<? extends Item>)ReduxItems.MYKAPOD_SHELL_CHUNK, "materials/");
        this.item((Supplier<? extends Item>)ReduxItems.SNAILSHELL_SHIELD, "accessories/");
        this.itemBlock((Block)ReduxBlocks.VERIDIUM_BLOCK.get());
        this.itemBlock((Block)ReduxBlocks.VERIDIUM_ORE.get());
        this.itemBlock((Block)ReduxBlocks.RAW_VERIDIUM_BLOCK.get());
        this.itemBlock((Block)ReduxBlocks.RAW_VALKYRUM_BLOCK.get());
        this.itemGlow((Supplier<? extends Item>)ReduxItems.COCKATRICE_FEATHER, "accessories/");
        this.itemGlow((Supplier<? extends Item>)ReduxItems.FEATHER_OF_WARDING, "accessories/");
        this.item((Supplier<? extends Item>)ReduxItems.WYND_BAGEL, "food/");
        this.item((Supplier<? extends Item>)ReduxItems.BLUEBERRY_BAGEL, "food/");
        this.item((Supplier<? extends Item>)ReduxItems.ZANBERRY, "food/");
        this.item(((LogicatorBlock)((Object)ReduxBlocks.LOGICATOR.get())).m_5456_(), "misc/");
        for (WoodHandler woodHandler : Redux.WOOD_HANDLERS) {
            woodHandler.generateItemModels(this);
        }
        this.itemBlock((Block)ReduxBlocks.CARVED_BASE.get());
        this.itemBlock((Block)ReduxBlocks.CARVED_PILLAR.get());
        this.itemBlock((Block)ReduxBlocks.SENTRY_BASE.get());
        this.itemBlock((Block)ReduxBlocks.SENTRY_PILLAR.get());
        this.itemOverlayColumn((Block)ReduxBlocks.LOCKED_CARVED_BASE.get(), (Block)ReduxBlocks.CARVED_BASE.get(), "dungeon/lock", "dungeon/");
        this.itemOverlayColumn((Block)ReduxBlocks.LOCKED_CARVED_PILLAR.get(), (Block)ReduxBlocks.CARVED_PILLAR.get(), "dungeon/lock", "dungeon/");
        this.itemOverlayColumn((Block)ReduxBlocks.LOCKED_SENTRY_BASE.get(), (Block)ReduxBlocks.SENTRY_BASE.get(), "dungeon/lock", "dungeon/");
        this.itemOverlayColumn((Block)ReduxBlocks.LOCKED_SENTRY_PILLAR.get(), (Block)ReduxBlocks.SENTRY_PILLAR.get(), "dungeon/lock", "dungeon/");
        this.itemOverlayColumn((Block)ReduxBlocks.TRAPPED_CARVED_BASE.get(), (Block)ReduxBlocks.CARVED_BASE.get(), "dungeon/exclamation", "dungeon/");
        this.itemOverlayColumn((Block)ReduxBlocks.TRAPPED_CARVED_PILLAR.get(), (Block)ReduxBlocks.CARVED_PILLAR.get(), "dungeon/exclamation", "dungeon/");
        this.itemOverlayColumn((Block)ReduxBlocks.TRAPPED_SENTRY_BASE.get(), (Block)ReduxBlocks.SENTRY_BASE.get(), "dungeon/exclamation", "dungeon/");
        this.itemOverlayColumn((Block)ReduxBlocks.TRAPPED_SENTRY_PILLAR.get(), (Block)ReduxBlocks.SENTRY_PILLAR.get(), "dungeon/exclamation", "dungeon/");
        this.itemOverlayColumn((Block)ReduxBlocks.BOSS_DOORWAY_CARVED_BASE.get(), (Block)ReduxBlocks.CARVED_BASE.get(), "dungeon/door", "dungeon/");
        this.itemOverlayColumn((Block)ReduxBlocks.BOSS_DOORWAY_CARVED_PILLAR.get(), (Block)ReduxBlocks.CARVED_PILLAR.get(), "dungeon/door", "dungeon/");
        this.itemOverlayColumn((Block)ReduxBlocks.BOSS_DOORWAY_SENTRY_BASE.get(), (Block)ReduxBlocks.SENTRY_BASE.get(), "dungeon/door", "dungeon/");
        this.itemOverlayColumn((Block)ReduxBlocks.BOSS_DOORWAY_SENTRY_PILLAR.get(), (Block)ReduxBlocks.SENTRY_PILLAR.get(), "dungeon/door", "dungeon/");
        this.itemBlock((Block)ReduxBlocks.RUNELIGHT.get(), "_on");
        this.itemOverlayDungeonBlock((Block)ReduxBlocks.LOCKED_RUNELIGHT.get(), (Block)ReduxBlocks.RUNELIGHT.get(), "lock", "dungeon/", "_on");
        this.itemOverlayDungeonBlock((Block)ReduxBlocks.LOCKED_POLISHED_SENTRITE.get(), (Block)ReduxBlocks.POLISHED_SENTRITE.get(), "construction/", "lock");
    }

    public String blockName(Supplier<? extends Block> block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block.get()).m_135815_();
    }

    protected ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    protected ResourceLocation texture(String name, String location) {
        return this.modLoc("block/" + location + name);
    }

    public ItemModelBuilder item(Supplier<? extends Item> item, String location) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item.get());
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + id.m_135815_()));
    }

    public ItemModelBuilder vampireAmulet(Supplier<? extends Item> item, String location) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item.get());
        String active = id.m_135815_() + "_active";
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(active, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + id.m_135815_() + "_active"));
        return ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + id.m_135815_() + "_inactive"))).override().predicate(Redux.locate("active"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + active))).end();
    }

    public ItemModelBuilder enchantedClover(Supplier<? extends Item> item, String location) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item.get());
        String active = "enchanted_" + id.m_135815_();
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(active, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + "enchanted_" + id.m_135815_()));
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + id.m_135815_()) + "_overlay")).texture("layer1", this.modLoc("item/" + location + id.m_135815_() + "_partial_tint"))).texture("layer2", this.modLoc("item/" + location + id.m_135815_()))).override().predicate(Redux.locate("enchanted"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + active))).end();
    }

    public ItemModelBuilder enchanableOrTintableFlower(Supplier<? extends Block> block, String location) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)block.get().m_5456_());
        String ench = "enchanted_" + id.m_135815_();
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ench, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + location + "enchanted_" + id.m_135815_()));
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer1", this.texture(this.blockName(block), location))).texture("layer0", this.texture(this.blockName(block) + "_overlay", location))).override().predicate(Redux.locate("enchanted"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + ench))).end();
    }

    public ItemModelBuilder itemGlow(Supplier<? extends Item> item, String location) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item.get());
        return (ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + id.m_135815_()))).texture("layer1", this.modLoc("item/" + location + id.m_135815_() + "_glow"))).customLoader((itemModelBuilder, existingFileHelper) -> ItemLayerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).emissive(15, 15, new int[]{1}))).end();
    }

    public ItemModelBuilder handheldGlow(Supplier<? extends Item> item, String location) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item.get());
        return (ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + id.m_135815_()))).texture("layer1", this.modLoc("item/" + location + id.m_135815_() + "_glow"))).customLoader((itemModelBuilder, existingFileHelper) -> ItemLayerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).emissive(15, 15, new int[]{1}))).end();
    }

    public void dartShooterGlow(Supplier<? extends Item> item, String location) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item.get());
        ((ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + id.m_135815_()))).texture("layer1", this.modLoc("item/" + location + id.m_135815_() + "_glow"))).customLoader((itemModelBuilder, existingFileHelper) -> ItemLayerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).emissive(15, 15, new int[]{1}))).end()).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 45.0f).translation(0.0f, 1.5f, -1.0f).scale(0.85f, 0.85f, 0.85f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -45.0f).translation(0.0f, 1.5f, -1.0f).scale(0.85f, 0.85f, 0.85f).end().end();
    }

    public ItemModelBuilder itemFullGlow(Supplier<? extends Item> item, String location) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item.get());
        return (ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + id.m_135815_()))).customLoader((itemModelBuilder, existingFileHelper) -> ItemLayerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).emissive(15, 15, new int[]{0}))).end();
    }

    public ItemModelBuilder blockCustomTexture(Supplier<? extends Block> block, String loc, String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(block.get().m_5456_()), "block/cube_all")).texture("all", this.modLoc("block/" + loc + name));
    }

    public ItemModelBuilder itemCustomTexture(Supplier<? extends ItemLike> item, String location, String texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get().m_5456_()), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + texture));
    }

    public ItemModelBuilder itemBlockFlatFullGlow(Supplier<? extends Block> block, String location, String suffix) {
        return (ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.texture(this.blockName(block) + suffix, location))).customLoader((itemModelBuilder, existingFileHelper) -> ItemLayerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).emissive(15, 15, new int[]{1}))).end();
    }

    public ItemModelBuilder itemBlockFlatFullGlow(Supplier<? extends Block> block, String location) {
        return this.itemBlockFlatFullGlow(block, location, "");
    }

    public ItemModelBuilder spear(Supplier<? extends Item> item, String location) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item.get());
        ItemModelBuilder small = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("item/" + location + id.m_135815_()));
        return (ItemModelBuilder)((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), this.mcLoc("item/handheld"))).override().model((ModelFile)this.getExistingFile(this.modLoc("item/spear_throwing"))).predicate(Redux.locate("throwing"), 1.0f).end().customLoader((itemModelBuilder, existingFileHelper) -> SeparateTransformsModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc("item/spear_in_hand"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)small).perspective(ItemDisplayContext.GROUND, (ModelBuilder)small).perspective(ItemDisplayContext.FIXED, (ModelBuilder)small))).end();
    }

    public void itemBlockWithParent(Block block, Function<Block, ResourceLocation> existingParent) {
        this.withExistingParent(this.blockName(block), existingParent.apply(block));
    }

    public ItemModelBuilder handheldItemGlow(Supplier<? extends Item> item, String location) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item.get());
        return (ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + id.m_135815_()))).texture("layer1", this.modLoc("item/" + location + id.m_135815_() + "_glow"))).customLoader((itemModelBuilder, existingFileHelper) -> ItemLayerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).emissive(15, 15, new int[]{1}))).end();
    }

    public ItemModelBuilder handheldItemFullGlow(Supplier<? extends Item> item, String location) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item.get());
        return (ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + id.m_135815_()))).customLoader((itemModelBuilder, existingFileHelper) -> ItemLayerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).emissive(15, 15, new int[]{0}))).end();
    }

    public ItemModelBuilder itemBlock(Supplier<? extends Block> block) {
        return (ItemModelBuilder)this.withExistingParent(this.blockName(block), this.texture(this.blockName(block)));
    }

    public ItemModelBuilder itemBlockOther(Supplier<? extends Block> block, Supplier<? extends Block> other) {
        return (ItemModelBuilder)this.withExistingParent(this.blockName(block), new ResourceLocation(ForgeRegistries.BLOCKS.getKey((Object)other.get()).m_135827_(), "block/" + this.blockName(other)));
    }

    public ItemModelBuilder itemBlock(Supplier<? extends Block> block, String suffix) {
        return (ItemModelBuilder)this.withExistingParent(this.blockName(block), this.texture(this.blockName(block) + suffix));
    }

    public ItemModelBuilder lookalikeBlock(Supplier<? extends Block> block, ResourceLocation lookalike) {
        return (ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)block.get()).m_135815_(), lookalike);
    }

    public ItemModelBuilder itemBlockFlat(Supplier<? extends Block> block, String location) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.texture(this.blockName(block), location));
    }

    public ItemModelBuilder itemBlockFlatCustomTexture(Supplier<? extends Block> block, String locationPlusName) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.texture(locationPlusName));
    }

    public ItemModelBuilder itemBlockFlatTint(Supplier<? extends Block> block, String location) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer1", this.texture(this.blockName(block), location));
    }

    public ItemModelBuilder itemBlockFlatWithPottedTexture(Supplier<? extends Block> block, String location) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.texture("potted_" + this.blockName(block), location));
    }

    public ItemModelBuilder itemBlockFlatGlow(Supplier<? extends Block> block, String location) {
        return (ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.texture(this.blockName(block), location))).texture("layer1", this.texture(this.blockName(block) + "_glow", location))).customLoader((itemModelBuilder, existingFileHelper) -> ItemLayerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).emissive(15, 15, new int[]{1}))).end();
    }

    public ItemModelBuilder itemBlockFlatTintOverlay(Supplier<? extends Block> block, String location) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer1", this.texture(this.blockName(block), location))).texture("layer0", this.texture(this.blockName(block) + "_overlay", location));
    }

    public ItemModelBuilder itemBlockFlatGlow(Supplier<? extends Block> block, String location, String suffix) {
        return (ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.texture(this.blockName(block), location) + suffix)).texture("layer1", this.texture(this.blockName(block) + suffix + "_glow", location))).customLoader((itemModelBuilder, existingFileHelper) -> ItemLayerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).emissive(15, 15, new int[]{1}))).end();
    }

    public ItemModelBuilder itemBlockFlatGlowOtherTexture(Supplier<? extends Block> block, Supplier<? extends Block> other, String location) {
        return (ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.texture(this.blockName(other), location))).texture("layer1", this.texture(this.blockName(other) + "_glow", location))).customLoader((itemModelBuilder, existingFileHelper) -> ItemLayerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).emissive(15, 15, new int[]{1}))).end();
    }

    public ItemModelBuilder itemBlockFlatTintGlowOverlay(Supplier<? extends Block> block, String location) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer1", this.texture(this.blockName(block), location))).texture("layer2", this.texture(this.blockName(block) + "_glow", location))).customLoader((itemModelBuilder, existingFileHelper) -> ItemLayerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).emissive(15, 15, new int[]{2}))).end()).texture("layer0", this.texture(this.blockName(block) + "_overlay", location));
    }

    public ItemModelBuilder itemBlockFlatTintGlow(Supplier<? extends Block> block, String location) {
        return (ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer1", this.texture(this.blockName(block), location))).texture("layer0", this.texture(this.blockName(block) + "_glow", location))).customLoader((itemModelBuilder, existingFileHelper) -> ItemLayerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).emissive(15, 15, new int[]{0}))).end();
    }

    public ItemModelBuilder itemFence(Supplier<? extends Block> block, Supplier<? extends Block> baseBlock, String location) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/fence_inventory"))).texture("texture", this.texture(this.blockName(baseBlock), location));
    }

    public ItemModelBuilder itemWallBlock(Supplier<? extends Block> block, Supplier<? extends Block> baseBlock, String location) {
        return (ItemModelBuilder)this.wallInventory(this.blockName(block), this.texture(this.blockName(baseBlock), location));
    }

    public ItemModelBuilder itemButton(Supplier<? extends Block> block, Supplier<? extends Block> baseBlock, String location) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/button_inventory"))).texture("texture", this.texture(this.blockName(baseBlock), location));
    }

    public ItemModelBuilder itemBlockFlatItemTexture(Supplier<? extends Block> block, String location) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block.get());
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + id.m_135815_()));
    }

    public ItemModelBuilder itemBlockFlatOtherBlockTexture(Supplier<? extends Block> block, Supplier<? extends Block> blockForTexture, String location) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block.get());
        ResourceLocation tex = ForgeRegistries.BLOCKS.getKey((Object)blockForTexture.get());
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.m_135815_(), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + location + tex.m_135815_()));
    }

    protected ResourceLocation texture(String name, String location, String suffix) {
        return this.modLoc("block/" + location + name + suffix);
    }

    public ItemModelBuilder itemBlockFlat(Supplier<? extends Block> block, String location, String suffix) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("item/generated"))).texture("layer0", this.texture(this.blockName(block), location, suffix));
    }

    public ItemModelBuilder eggItem(Supplier<? extends Item> item) {
        return (ItemModelBuilder)this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item.get()).m_135815_(), this.mcLoc("item/template_spawn_egg"));
    }

    public void itemLogWallBlock(Block block, Block baseBlock, String location, String modid) {
        ResourceLocation baseTexture = new ResourceLocation(modid, "block/" + location + this.blockName(baseBlock));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/block"))).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 135.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 90.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.5f, 0.5f, 0.5f).end().end()).texture("top", baseTexture + "_top")).texture("side", baseTexture)).element().from(4.0f, 0.0f, 4.0f).to(12.0f, 16.0f, 12.0f).face(Direction.DOWN).uvs(4.0f, 4.0f, 12.0f, 12.0f).texture("#top").cullface(Direction.DOWN).end().face(Direction.UP).uvs(4.0f, 4.0f, 12.0f, 12.0f).texture("#top").end().face(Direction.NORTH).uvs(4.0f, 0.0f, 12.0f, 16.0f).texture("#side").end().face(Direction.SOUTH).uvs(4.0f, 0.0f, 12.0f, 16.0f).texture("#side").end().face(Direction.WEST).uvs(4.0f, 0.0f, 12.0f, 16.0f).texture("#side").end().face(Direction.EAST).uvs(4.0f, 0.0f, 12.0f, 16.0f).texture("#side").end().end()).element().from(5.0f, 0.0f, 0.0f).to(11.0f, 13.0f, 16.0f).face(Direction.DOWN).uvs(5.0f, 0.0f, 11.0f, 16.0f).texture("#top").cullface(Direction.DOWN).end().face(Direction.UP).uvs(5.0f, 0.0f, 11.0f, 16.0f).texture("#top").end().face(Direction.NORTH).uvs(5.0f, 3.0f, 11.0f, 16.0f).texture("#side").cullface(Direction.NORTH).end().face(Direction.SOUTH).uvs(5.0f, 3.0f, 11.0f, 16.0f).texture("#side").cullface(Direction.SOUTH).end().face(Direction.WEST).uvs(0.0f, 3.0f, 16.0f, 16.0f).texture("#side").end().face(Direction.EAST).uvs(0.0f, 3.0f, 16.0f, 16.0f).texture("#side").end().end();
    }

    public void itemWoodWallBlock(Block block, Block baseBlock, String location, String modid) {
        this.wallInventory(this.blockName(block), new ResourceLocation(modid, "block/" + location + this.blockName(baseBlock)));
    }

    public void itemOverlayColumn(Block block, Block baseBlock, String overlay, String location) {
        ResourceLocation side = ReduxBlockstateData.extendStatic(this.texture(ReduxBlockstateData.nameStatic(baseBlock), location), "_side");
        ResourceLocation end = ReduxBlockstateData.extendStatic(this.texture(ReduxBlockstateData.nameStatic(baseBlock), location), "_top");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), "block/cube_column")).texture("overlay", new ResourceLocation("aether", "block/" + overlay))).texture("side", side)).texture("end", end)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.UP).texture("#end").end().face(Direction.DOWN).texture("#end").end().face(Direction.NORTH).texture("#side").end().face(Direction.SOUTH).texture("#side").end().face(Direction.EAST).texture("#side").end().face(Direction.WEST).texture("#side").end().end()).element().from(0.0f, 0.0f, -0.1f).to(16.0f, 16.0f, -0.1f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(8.0f, 8.0f, 6.9f).end().face(Direction.NORTH).texture("#overlay").emissivity(15, 15).end().end()).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(-90.0f, -180.0f, -45.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(-90.0f, -180.0f, -45.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemDisplayContext.GROUND).rotation(90.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ItemDisplayContext.GUI).rotation(30.0f, 135.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().transform(ItemDisplayContext.FIXED).scale(0.5f, 0.5f, 0.5f).end().end();
    }

    public void itemOverlayDungeonBlock(Block block, Block baseBlock, String overlay, String folder, String suffix) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/cube"))).texture("overlay", new ResourceLocation("aether", "block/dungeon/" + overlay))).texture("face", this.texture(this.blockName(baseBlock) + suffix, folder))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((direction, builder) -> builder.texture("#face").cullface(direction).end()).end()).element().from(0.0f, 0.0f, -0.1f).to(16.0f, 16.0f, -0.1f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(8.0f, 8.0f, 6.9f).end().face(Direction.NORTH).texture("#overlay").emissivity(15, 15).end().end()).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(-90.0f, -180.0f, -45.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(-90.0f, -180.0f, -45.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemDisplayContext.GROUND).rotation(90.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ItemDisplayContext.GUI).rotation(30.0f, 135.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().transform(ItemDisplayContext.FIXED).scale(0.5f, 0.5f, 0.5f).end().end();
    }

    public void itemOverlayDungeonBlock(Block block, Block baseBlock, String folder, String overlay) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/cube"))).texture("overlay", new ResourceLocation("aether", "block/dungeon/" + overlay))).texture("face", this.texture(this.blockName(baseBlock), folder))).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((direction, builder) -> builder.texture("#face").cullface(direction).end()).end()).element().from(0.0f, 0.0f, -0.1f).to(16.0f, 16.0f, -0.1f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(8.0f, 8.0f, 6.9f).end().face(Direction.NORTH).texture("#overlay").emissivity(15, 15).end().end()).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(-90.0f, -180.0f, -45.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(-90.0f, -180.0f, -45.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ItemDisplayContext.GROUND).rotation(90.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ItemDisplayContext.GUI).rotation(30.0f, 135.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().transform(ItemDisplayContext.FIXED).scale(0.5f, 0.5f, 0.5f).end().end();
    }
}

