/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.entity.model;

import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.monster.AbstractWhirlwind;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.zepalesque.redux.util.math.EasingUtil;
import org.jetbrains.annotations.NotNull;

public class WhirlwindModel<T extends AbstractWhirlwind>
extends EntityModel<T> {
    private final ModelPart whirl_body;
    private final ModelPart whirl_bottom;
    private final ModelPart bottom_render;
    private final ModelPart whirl_lower;
    private final ModelPart lower_render;
    private final ModelPart whirl_upper;
    private final ModelPart upper_render;
    private final ModelPart whirl_top;
    private final ModelPart top_render;
    private final float[] alpha = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public WhirlwindModel(ModelPart root) {
        this.whirl_body = root.m_171324_("whirl_body");
        this.whirl_bottom = this.whirl_body.m_171324_("whirl_bottom");
        this.bottom_render = this.whirl_bottom.m_171324_("bottom_render");
        this.whirl_lower = this.whirl_bottom.m_171324_("whirl_lower");
        this.lower_render = this.whirl_lower.m_171324_("lower_render");
        this.whirl_upper = this.whirl_lower.m_171324_("whirl_upper");
        this.upper_render = this.whirl_upper.m_171324_("upper_render");
        this.whirl_top = this.whirl_upper.m_171324_("whirl_top");
        this.top_render = this.whirl_top.m_171324_("top_render");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition whirl_body = partdefinition.m_171599_("whirl_body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition whirl_bottom = whirl_body.m_171599_("whirl_bottom", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        whirl_bottom.m_171599_("bottom_render", CubeListBuilder.m_171558_().m_171514_(0, 126).m_171488_(-3.5f, -18.0f, -3.5f, 7.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition whirl_lower = whirl_bottom.m_171599_("whirl_lower", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        whirl_lower.m_171599_("lower_render", CubeListBuilder.m_171558_().m_171514_(228, 103).m_171488_(-3.5f, -27.0f, -3.5f, 7.0f, 16.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(116, 98).m_171488_(-6.0f, -27.0f, -6.0f, 12.0f, 16.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 92).m_171488_(-9.0f, -27.0f, -9.0f, 18.0f, 16.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition whirl_upper = whirl_lower.m_171599_("whirl_upper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        whirl_upper.m_171599_("upper_render", CubeListBuilder.m_171558_().m_171514_(208, 60).m_171488_(-6.0f, -41.0f, -6.0f, 12.0f, 20.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(116, 54).m_171488_(-9.0f, -41.0f, -9.0f, 18.0f, 20.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(0, 48).m_171488_(-12.0f, -41.0f, -12.0f, 24.0f, 20.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition whirl_top = whirl_upper.m_171599_("whirl_top", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-20.0f, (float)0.0f));
        whirl_top.m_171599_("top_render", CubeListBuilder.m_171558_().m_171514_(116, 18).m_171488_(-9.0f, -53.0f, -9.0f, 18.0f, 12.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(160, 12).m_171488_(-12.0f, -53.0f, -12.0f, 24.0f, 12.0f, 24.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-18.0f, -53.0f, -18.0f, 36.0f, 12.0f, 36.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int mask = 0xFFFFFF;
        int offset = 3;
        int length = 11;
        int total = 20;
        if (ageInTicks < 20.0f) {
            for (i = 0; i < 4; ++i) {
                prog = Mth.m_14036_((float)(ageInTicks - 1.0f - (float)(3 * i)), (float)0.0f, (float)11.0f) / 11.0f;
                this.alpha[i] = a = EasingUtil.Sinusoidal.inOut(prog);
            }
        } else if (((AbstractWhirlwind)entity).f_20919_ < 20 && ((AbstractWhirlwind)entity).f_20919_ > 0) {
            for (i = 0; i < 4; ++i) {
                prog = 1.0f - Mth.m_14036_((float)((float)((AbstractWhirlwind)entity).f_20919_ + ageInTicks % 1.0f - (float)(3 * i)), (float)0.0f, (float)11.0f) / 11.0f;
                this.alpha[i] = a = EasingUtil.Sinusoidal.inOut(prog);
            }
        }
        if (((AbstractWhirlwind)entity).f_20919_ >= 20) {
            this.alpha[0] = 1.6777215E7f;
            this.alpha[1] = 1.6777215E7f;
            this.alpha[2] = 1.6777215E7f;
            this.alpha[3] = 1.6777215E7f;
        }
        boolean flag = entity.m_6095_() == AetherEntityTypes.EVIL_WHIRLWIND.get();
        float speedModif = flag ? -0.075f : -0.1f;
        float amountModif = flag ? 4.0f : 3.0f;
        this.whirl_body.m_171331_().forEach(ModelPart::m_233569_);
        float f = ageInTicks * (float)Math.PI * speedModif;
        this.bottom_render.f_104200_ = Mth.m_14089_((float)f) * -0.25f * 1.0f * amountModif;
        this.bottom_render.f_104202_ = Mth.m_14031_((float)f) * -0.25f * 1.0f * amountModif;
        this.lower_render.f_104200_ = this.bottom_render.f_104200_ + Mth.m_14031_((float)f) * 0.5f * 0.8f * amountModif;
        this.lower_render.f_104202_ = this.bottom_render.f_104202_ + Mth.m_14089_((float)f) * 0.8f * amountModif;
        this.upper_render.f_104200_ = this.lower_render.f_104200_ + Mth.m_14089_((float)f) * 1.0f * 0.6f * amountModif;
        this.upper_render.f_104202_ = this.lower_render.f_104202_ + Mth.m_14031_((float)f) * 1.0f * 0.6f * amountModif;
        this.top_render.f_104200_ += Mth.m_14031_((float)f) * 0.5f * 0.4f * amountModif;
        this.top_render.f_104202_ += Mth.m_14089_((float)f) * 0.4f * amountModif;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.bottom_render.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, this.alpha[0]);
        this.lower_render.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, this.alpha[1]);
        this.upper_render.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, this.alpha[2]);
        this.top_render.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, this.alpha[3]);
        this.alpha[0] = 1.0f;
        this.alpha[1] = 1.0f;
        this.alpha[2] = 1.0f;
        this.alpha[3] = 1.0f;
    }
}

