/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.entity;

import com.aetherteam.aether.entity.monster.AbstractWhirlwind;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.zepalesque.redux.client.render.ReduxModelLayers;
import net.zepalesque.redux.client.render.ReduxRenderTypes;
import net.zepalesque.redux.client.render.entity.IPostRenderer;
import net.zepalesque.redux.client.render.entity.model.WhirlwindModel;
import net.zepalesque.redux.config.ReduxConfig;
import org.jetbrains.annotations.NotNull;

public class ReduxWhirlwindRenderer<T extends AbstractWhirlwind>
extends LivingEntityRenderer<T, WhirlwindModel<T>>
implements IPostRenderer<T> {
    private static final ResourceLocation WHIRLWIND = new ResourceLocation("aether", "textures/entity/mobs/whirlwind/whirlwind.png");

    public ReduxWhirlwindRenderer(EntityRendererProvider.Context context) {
        super(context, new WhirlwindModel(context.m_174023_(ReduxModelLayers.WHIRLWIND)), 0.0f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T whirlwind) {
        return WHIRLWIND;
    }

    public void render(@NotNull T entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
    }

    @Override
    public void internalRender(@NotNull T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (((Boolean)ReduxConfig.CLIENT.improved_whirlwinds.get()).booleanValue()) {
            float age = this.m_6930_((LivingEntity)entity, partialTicks);
            VertexConsumer vertexconsumer = buffer.m_6299_(this.renderType(this.getTextureLocation(entity), this.xOffset(age) % 1.0f));
            poseStack.m_85836_();
            ((WhirlwindModel)this.f_115290_).setupAnim(entity, 0.0f, 0.0f, age, 0.0f, 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            this.m_7546_((LivingEntity)entity, poseStack, partialTicks);
            ((WhirlwindModel)this.f_115290_).m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }

    protected RenderType renderType(ResourceLocation texture, float xOffset) {
        return ReduxRenderTypes.whirlwindParticleTranslucency(texture, xOffset, 0.0f);
    }

    protected float xOffset(float tickCount) {
        return tickCount * 0.01f;
    }

    protected void setupRotations(T entityLiving, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
    }
}

