/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.gui.component.menu;

import com.aetherteam.aether.mixin.mixins.client.accessor.ButtonAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.client.gui.screen.menu.ReduxTitleScreen;

public class ReduxMenuButton
extends Button {
    private static final ResourceLocation AETHER_WIDGETS = Redux.locate("textures/gui/title/buttons.png");
    private static final int BUTTON_WIDTH = 400;
    private static final int BUTTON_HEIGHT = 40;
    private static final int BUTTON_SEPARATION = 50;
    private static final int INITIAL_X_OFFSET = 16;
    private static final int INITIAL_Y_OFFSET = 100;
    private static final int TEXTURE_SIZE = 512;
    private final ReduxTitleScreen screen;
    public final int originalX;
    public final int originalY;
    public final int originalWidth;
    public final int originalHeight;
    public int hoverOffset;
    public int buttonCountOffset;
    public boolean serverButton;

    public ReduxMenuButton(ReduxTitleScreen screen, Button.Builder builder) {
        super(builder);
        this.screen = screen;
        this.originalX = this.m_252754_();
        this.originalY = this.m_252907_();
        this.originalWidth = this.m_5711_();
        this.originalHeight = this.m_93694_();
        this.hoverOffset = 0;
    }

    public ReduxMenuButton(ReduxTitleScreen screen, Button oldButton) {
        this(screen, new Button.Builder(oldButton.m_6035_(), button -> oldButton.m_5691_()).m_252987_(oldButton.m_252754_(), oldButton.m_252907_(), oldButton.m_5711_(), oldButton.m_93694_()).m_252778_(button -> ((ButtonAccessor)oldButton).callCreateNarrationMessage()));
        oldButton.f_93624_ = false;
        oldButton.f_93623_ = false;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        int i = this.m_274533_();
        float scale = ReduxTitleScreen.getScale(this.screen, minecraft);
        this.m_252865_(16);
        this.m_253211_((int)(100.0f / scale + (float)this.buttonCountOffset * (50.0f / scale)));
        this.m_93674_((int)(400.0f / scale));
        this.setHeight((int)(40.0f / scale));
        RenderSystem.enableBlend();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
        guiGraphics.m_280163_(AETHER_WIDGETS, this.m_252754_() + this.hoverOffset, this.m_252907_(), 0.0f, (float)Mth.m_14167_((float)((float)i / scale)), this.m_5711_(), this.m_93694_(), (int)(512.0f / scale), (int)(512.0f / scale));
        RenderSystem.disableBlend();
        poseStack.m_85836_();
        float textScale = ReduxMenuButton.getTextScale(this.screen, minecraft);
        float textX = (float)this.m_252754_() + 35.0f * textScale + (float)this.hoverOffset;
        float textY = (float)this.m_252907_() + ((float)this.f_93619_ - 8.0f * textScale) / 2.0f;
        poseStack.m_252880_(textX, textY, 0.0f);
        poseStack.m_85841_(textScale, textScale, textScale);
        guiGraphics.m_280430_(font, this.m_6035_(), 0, 0, this.getTextColor(mouseX, mouseY) | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        poseStack.m_85849_();
    }

    public static float getTextScale(ReduxTitleScreen screen, Minecraft minecraft) {
        int guiScale = minecraft.m_91268_().m_85385_(((Integer)minecraft.f_91066_.m_231928_().m_231551_()).intValue(), minecraft.m_91390_());
        float elementScale = ReduxTitleScreen.getScale(screen, minecraft);
        float elementPixelWidth = (int)((float)guiScale / elementScale);
        float textPixelWidth = elementPixelWidth + 2.0f;
        if (elementPixelWidth <= 1.0f) {
            textPixelWidth = 2.0f;
        }
        return textPixelWidth / (float)guiScale;
    }

    private int m_274533_() {
        int i = 1;
        if (!this.m_142518_()) {
            i = 0;
        } else if (this.m_198029_()) {
            i = 2;
        }
        return i * 40;
    }

    public int getTextColor(int mouseX, int mouseY) {
        if (!this.serverButton) {
            return this.m_5953_(mouseX, mouseY) ? 0xD6D6FF : 0xFFFFFF;
        }
        return this.m_5953_(mouseX, mouseY) ? 15916882 : 16772192;
    }

    public static int totalHeightRange(int buttonCount, float scale) {
        return (int)(100.0f / scale + (float)buttonCount * (60.0f / scale));
    }
}

