/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.gui.component.config;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.zepalesque.redux.api.packconfig.PackConfig;
import net.zepalesque.redux.client.gui.component.config.IDisplayPage;
import net.zepalesque.redux.client.gui.component.config.ISaveable;
import net.zepalesque.redux.client.gui.screen.config.PackConfigMenu;

public class SaveableBooleanButton
extends Button
implements ISaveable,
IDisplayPage {
    public final PackConfig<Boolean> config;
    public final int page;
    private boolean value;
    private final PackConfigMenu menu;

    public SaveableBooleanButton(int x, int y, int width, int height, PackConfig<Boolean> config, int page, PackConfigMenu menu) {
        super(x, y, width, height, CommonComponents.f_237098_, SaveableBooleanButton::flip, Button.f_252438_);
        this.config = config;
        this.value = config.get();
        this.page = page;
        this.menu = menu;
        if (config.hasComment()) {
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)("gui.aether_redux.pack_config.config_desc." + config.id()))));
        }
    }

    private static void flip(Button b) {
        if (b instanceof SaveableBooleanButton) {
            SaveableBooleanButton booleanButton;
            booleanButton.setValue(!(booleanButton = (SaveableBooleanButton)b).getValue());
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.f_93624_ = this.menu.getCurrentPage() == this.page;
        this.f_93623_ = this.menu.getCurrentPage() == this.page;
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public Component m_6035_() {
        return Component.m_237113_((String)SaveableBooleanButton.capitalise(String.valueOf(this.value)));
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public void save() {
        this.menu.markChanged(this.config.set(this.getValue()));
    }

    @Override
    public int getPage() {
        return this.page;
    }

    private static String capitalise(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return "";
        }
        return new StringBuilder(str.length()).append(Character.toTitleCase(str.charAt(0))).append(str, 1, str.length()).toString();
    }
}

