/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.capability;

import com.aetherteam.aether.entity.monster.Cockatrice;
import com.aetherteam.aether.entity.monster.Swet;
import com.aetherteam.aether.entity.monster.dungeon.Mimic;
import com.aetherteam.aether.entity.monster.dungeon.Sentry;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.aether_genesis.entity.monster.BattleSentry;
import com.aetherteam.nitrogen.capability.CapabilityProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.capability.animation.mimic.MimicAnimation;
import net.zepalesque.redux.capability.animation.mimic.MimicAnimationCapability;
import net.zepalesque.redux.capability.animation.moa.MoaAnimation;
import net.zepalesque.redux.capability.animation.moa.MoaAnimationCapability;
import net.zepalesque.redux.capability.animation.sentry.SentryAnimation;
import net.zepalesque.redux.capability.animation.sentry.SentryAnimationCapability;
import net.zepalesque.redux.capability.animation.sentry.battle.BattleSentryAnimation;
import net.zepalesque.redux.capability.animation.sentry.battle.BattleSentryAnimationCapability;
import net.zepalesque.redux.capability.arrow.SubzeroArrow;
import net.zepalesque.redux.capability.arrow.SubzeroArrowCapability;
import net.zepalesque.redux.capability.cockatrice.CockatriceExtension;
import net.zepalesque.redux.capability.cockatrice.CockatriceExtensionCapability;
import net.zepalesque.redux.capability.living.VampireAmulet;
import net.zepalesque.redux.capability.living.VampireAmuletCapability;
import net.zepalesque.redux.capability.player.ReduxPlayer;
import net.zepalesque.redux.capability.player.ReduxPlayerCapability;
import net.zepalesque.redux.capability.swet.SwetMass;
import net.zepalesque.redux.capability.swet.SwetMassCapability;

@Mod.EventBusSubscriber(modid="aether_redux", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ReduxCapabilities {
    public static final Capability<CockatriceExtension> COCKATRICE_EXTENSION = CapabilityManager.get((CapabilityToken)new CapabilityToken<CockatriceExtension>(){});
    public static final Capability<MoaAnimation> MOA_ANIM = CapabilityManager.get((CapabilityToken)new CapabilityToken<MoaAnimation>(){});
    public static final Capability<ReduxPlayer> REDUX_PLAYER = CapabilityManager.get((CapabilityToken)new CapabilityToken<ReduxPlayer>(){});
    public static final Capability<SentryAnimation> SENTRY_ANIM = CapabilityManager.get((CapabilityToken)new CapabilityToken<SentryAnimation>(){});
    public static final Capability<MimicAnimation> MIMIC_ANIM = CapabilityManager.get((CapabilityToken)new CapabilityToken<MimicAnimation>(){});
    public static final Capability<BattleSentryAnimation> BATLLE_SENTRY_ANIM = CapabilityManager.get((CapabilityToken)new CapabilityToken<BattleSentryAnimation>(){});
    public static final Capability<SubzeroArrow> SUBZERO_ARROW = CapabilityManager.get((CapabilityToken)new CapabilityToken<SubzeroArrow>(){});
    public static final Capability<VampireAmulet> VAMPIRE_AMULET = CapabilityManager.get((CapabilityToken)new CapabilityToken<VampireAmulet>(){});
    public static final Capability<SwetMass> SWET_MASS = CapabilityManager.get((CapabilityToken)new CapabilityToken<SwetMass>(){});

    @SubscribeEvent
    public static void register(RegisterCapabilitiesEvent event) {
        event.register(CockatriceExtension.class);
        event.register(MoaAnimation.class);
        event.register(ReduxPlayer.class);
        event.register(SentryAnimation.class);
        event.register(MimicAnimation.class);
        event.register(BattleSentryAnimation.class);
        event.register(SubzeroArrow.class);
        event.register(VampireAmulet.class);
        event.register(SwetMass.class);
    }

    public static IllegalStateException error() {
        return new IllegalStateException("Capability was not present despite check to ensure it was! This should not be possible!");
    }

    @Mod.EventBusSubscriber(modid="aether_redux")
    public static class Registration {
        @SubscribeEvent
        public static <T extends Sentry> void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
            LivingEntity entity;
            Mimic mimic;
            Sentry sentry;
            Moa moa;
            Object object = event.getObject();
            if (object instanceof Cockatrice) {
                Cockatrice cockatrice = (Cockatrice)object;
                event.addCapability(Redux.locate("cockatrice_extension"), (ICapabilityProvider)new CapabilityProvider(COCKATRICE_EXTENSION, (INBTSerializable)new CockatriceExtensionCapability(cockatrice)));
            }
            if ((object = event.getObject()) instanceof Moa && (moa = (Moa)object).m_9236_().m_5776_()) {
                event.addCapability(Redux.locate("moa_anim"), (ICapabilityProvider)new CapabilityProvider(MOA_ANIM, (INBTSerializable)new MoaAnimationCapability(moa)));
            }
            if ((object = event.getObject()) instanceof Player) {
                Player player = (Player)object;
                event.addCapability(Redux.locate("redux_player"), (ICapabilityProvider)new CapabilityProvider(REDUX_PLAYER, (INBTSerializable)new ReduxPlayerCapability(player)));
            }
            if ((object = event.getObject()) instanceof Sentry && (sentry = (Sentry)object).m_9236_().m_5776_()) {
                event.addCapability(Redux.locate("sentry_anim"), (ICapabilityProvider)new CapabilityProvider(SENTRY_ANIM, (INBTSerializable)new SentryAnimationCapability(sentry)));
            }
            if ((object = event.getObject()) instanceof Mimic && (mimic = (Mimic)object).m_9236_().m_5776_()) {
                event.addCapability(Redux.locate("mimic_anim"), (ICapabilityProvider)new CapabilityProvider(MIMIC_ANIM, (INBTSerializable)new MimicAnimationCapability(mimic)));
            }
            if (Redux.aetherGenesisCompat() && (object = event.getObject()) instanceof BattleSentry && (sentry = (BattleSentry)object).m_9236_().m_5776_()) {
                event.addCapability(Redux.locate("battle_sentry_anim"), (ICapabilityProvider)new CapabilityProvider(BATLLE_SENTRY_ANIM, (INBTSerializable)new BattleSentryAnimationCapability((BattleSentry)sentry)));
            }
            if ((object = event.getObject()) instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)object;
                event.addCapability(Redux.locate("subzero_arrow"), (ICapabilityProvider)new CapabilityProvider(SUBZERO_ARROW, (INBTSerializable)new SubzeroArrowCapability(arrow)));
            }
            if ((object = event.getObject()) instanceof LivingEntity) {
                entity = (LivingEntity)object;
                event.addCapability(Redux.locate("vampire_amulet"), (ICapabilityProvider)new CapabilityProvider(VAMPIRE_AMULET, (INBTSerializable)new VampireAmuletCapability(entity)));
            }
            if ((object = event.getObject()) instanceof Swet) {
                entity = (Swet)object;
                event.addCapability(Redux.locate("swet_mass"), (ICapabilityProvider)new CapabilityProvider(SWET_MASS, (INBTSerializable)new SwetMassCapability((Swet)entity)));
            }
        }
    }
}

