/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.goated.common;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.goated.common.BreedWithGoatGoal;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;

public class MakeLoveWithSheepBehavior
extends Behavior<Animal> {
    private static final int BREED_RANGE = 3;
    private static final int MIN_DURATION = 60;
    private static final int MAX_DURATION = 110;
    private final EntityType<? extends Animal> partnerType = EntityType.f_20520_;
    private final float speedModifier;
    private long spawnChildAtTime;

    public MakeLoveWithSheepBehavior(float f) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26375_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), 110);
        this.speedModifier = f;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Animal owner) {
        return owner.m_27593_() && this.findValidBreedPartner(owner).isPresent();
    }

    protected void start(ServerLevel level, Animal entity, long gameTime) {
        Animal animal = this.findValidBreedPartner(entity).get();
        entity.m_6274_().m_21879_(MemoryModuleType.f_26375_, (Object)animal);
        animal.m_6274_().m_21879_(MemoryModuleType.f_26375_, (Object)entity);
        BehaviorUtils.m_22602_((LivingEntity)entity, (LivingEntity)animal, (float)this.speedModifier);
        int i = 60 + entity.m_217043_().m_188503_(50);
        this.spawnChildAtTime = gameTime + (long)i;
    }

    protected boolean canStillUse(ServerLevel level, Animal entity, long gameTime) {
        if (!this.hasBreedTargetOfRightType(entity)) {
            return false;
        }
        Animal animal = this.getBreedTarget(entity);
        return animal.m_6084_() && MakeLoveWithSheepBehavior.canMate(entity, animal) && BehaviorUtils.m_22636_((Brain)entity.m_6274_(), (LivingEntity)animal) && gameTime <= this.spawnChildAtTime;
    }

    private static boolean canMate(Animal entity, Animal animal) {
        return entity.m_27593_() && animal.m_27593_();
    }

    protected void tick(ServerLevel level, Animal owner, long gameTime) {
        Animal animal = this.getBreedTarget(owner);
        BehaviorUtils.m_22602_((LivingEntity)owner, (LivingEntity)animal, (float)this.speedModifier);
        if (owner.m_19950_((Entity)animal, 3.0) && gameTime >= this.spawnChildAtTime) {
            BreedWithGoatGoal.spawnChildFromBreeding(level, owner, animal);
            owner.m_6274_().m_21936_(MemoryModuleType.f_26375_);
            animal.m_6274_().m_21936_(MemoryModuleType.f_26375_);
        }
    }

    protected void stop(ServerLevel level, Animal entity, long gameTime) {
        entity.m_6274_().m_21936_(MemoryModuleType.f_26375_);
        entity.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        entity.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        this.spawnChildAtTime = 0L;
    }

    private Animal getBreedTarget(Animal animal) {
        return (Animal)animal.m_6274_().m_21952_(MemoryModuleType.f_26375_).get();
    }

    private boolean hasBreedTargetOfRightType(Animal animal) {
        Brain brain = animal.m_6274_();
        return brain.m_21874_(MemoryModuleType.f_26375_) && ((AgeableMob)brain.m_21952_(MemoryModuleType.f_26375_).get()).m_6095_() == this.partnerType;
    }

    private Optional<? extends Animal> findValidBreedPartner(Animal animal) {
        return animal.m_6274_().m_21952_(MemoryModuleType.f_148205_).flatMap(t -> t.m_186116_(livingEntity -> {
            Animal animal2;
            return livingEntity.m_6095_() == this.partnerType && livingEntity instanceof Animal && MakeLoveWithSheepBehavior.canMate(animal, animal2 = (Animal)livingEntity);
        })).map(Animal.class::cast);
    }
}

