/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.goated.common;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;

public class GeepEatGrassBehavior
extends Behavior<Animal> {
    private static final int EAT_ANIMATION_TICKS = 40;
    private static final Predicate<BlockState> IS_TALL_GRASS = BlockStatePredicate.m_61287_((Block)Blocks.f_50034_);
    private static final Predicate<BlockState> IS_GRASS_BLOCK = BlockStatePredicate.m_61287_((Block)Blocks.f_50440_);
    private static final int MAX_DURATION = 110;
    private int eatAnimationTick;

    public GeepEatGrassBehavior() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_217768_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), 110);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Animal owner) {
        if (owner.m_217043_().m_188503_(owner.m_6162_() ? 50 : 1000) != 0) {
            return false;
        }
        BlockPos blockPos = owner.m_20183_();
        if (IS_TALL_GRASS.test(level.m_8055_(blockPos))) {
            return true;
        }
        return IS_GRASS_BLOCK.test(level.m_8055_(blockPos.m_7495_()));
    }

    protected void start(ServerLevel level, Animal entity, long gameTime) {
        this.eatAnimationTick = 40;
        level.m_7605_((Entity)entity, (byte)10);
        entity.m_21573_().m_26573_();
        entity.m_6274_().m_21936_(MemoryModuleType.f_26370_);
    }

    protected boolean canStillUse(ServerLevel level, Animal entity, long gameTime) {
        return this.eatAnimationTick > 0;
    }

    protected void tick(ServerLevel level, Animal owner, long gameTime) {
        owner.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        if (this.eatAnimationTick == 4) {
            BlockPos blockPos = owner.m_20183_();
            if (IS_TALL_GRASS.test(level.m_8055_(blockPos))) {
                if (level.m_46469_().m_46207_(GameRules.f_46132_)) {
                    level.m_46961_(blockPos, false);
                }
                owner.m_8035_();
            } else {
                BlockPos below = blockPos.m_7495_();
                BlockState belowState = level.m_8055_(below);
                if (IS_GRASS_BLOCK.test(belowState)) {
                    if (level.m_46469_().m_46207_(GameRules.f_46132_)) {
                        level.m_46796_(2001, below, Block.m_49956_((BlockState)belowState));
                        level.m_7731_(below, Blocks.f_50493_.m_49966_(), 2);
                    }
                    owner.m_8035_();
                }
            }
        }
    }

    protected void stop(ServerLevel level, Animal entity, long gameTime) {
        this.eatAnimationTick = 0;
    }
}

