/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.goated.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.mehvahdjukaar.goated.Goated;
import net.mehvahdjukaar.goated.common.Geep;
import net.mehvahdjukaar.goated.common.GeepEatGrassBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LongJumpMidJump;
import net.minecraft.world.entity.ai.behavior.LongJumpToRandomPos;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class GeepAI {
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.m_146622_((int)5, (int)16);
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 1.25f;
    private static final float SPEED_MULTIPLIER_WHEN_TEMPTED = 1.25f;
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 2.0f;
    private static final float SPEED_MULTIPLIER_WHEN_PREPARING_TO_RAM = 1.25f;
    private static final UniformInt TIME_BETWEEN_LONG_JUMPS = UniformInt.m_146622_((int)700, (int)1400);
    public static final int MAX_LONG_JUMP_HEIGHT = 3;
    public static final int MAX_LONG_JUMP_WIDTH = 4;
    public static final float MAX_JUMP_VELOCITY = 1.5f;

    protected static void initMemories(Geep goat, RandomSource random) {
        goat.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)TIME_BETWEEN_LONG_JUMPS.m_214085_(random));
    }

    protected static Brain<Geep> makeBrain(Brain<Geep> brain) {
        GeepAI.initCoreActivity(brain);
        GeepAI.initIdleActivity(brain);
        GeepAI.initLongJumpActivity(brain);
        brain.m_21930_(Set.of(Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<Geep> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148199_)));
    }

    private static void initIdleActivity(Brain<Geep> brain) {
        brain.m_21903_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new FollowTemptation(livingEntity -> Float.valueOf(1.25f))), (Object)Pair.of((Object)2, (Object)BabyFollowAdult.m_257685_((UniformInt)ADULT_FOLLOW_RANGE, (float)1.25f)), (Object)Pair.of((Object)3, (Object)((Object)new GeepEatGrassBehavior())), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148200_, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initLongJumpActivity(Brain<Geep> brain) {
        brain.m_21903_(Activity.f_150239_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new LongJumpMidJump(TIME_BETWEEN_LONG_JUMPS, SoundEvents.f_144151_)), (Object)Pair.of((Object)1, (Object)new LongJumpToRandomPos(TIME_BETWEEN_LONG_JUMPS, 3, 4, 1.5f, goat -> Goated.LONG_JUMP_SOUND.get()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148196_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_148199_, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivity(Geep brain) {
        brain.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_150239_, (Object)Activity.f_37979_));
    }

    public static Ingredient getTemptations() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_});
    }
}

