/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.goated.client;

import net.mehvahdjukaar.goated.common.Geep;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.jetbrains.annotations.NotNull;

public class GeepModel<T extends Geep>
extends QuadrupedModel<T> {
    private float headXRot;

    public GeepModel(ModelPart modelPart) {
        super(modelPart, false, 8.0f, 4.0f, 2.0f, 2.0f, 24);
    }

    public static LayerDefinition createBodyLayer() {
        int lefH = 0;
        CubeDeformation legDef = CubeDeformation.f_171458_;
        CubeDeformation bodyDef = CubeDeformation.f_171458_;
        return GeepModel.createLayer(lefH, 0, legDef, bodyDef);
    }

    @NotNull
    private static LayerDefinition createLayer(int lefOffset, int widthIncrement, CubeDeformation legDef, CubeDeformation bodyDef) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        CubeListBuilder cubeListBuilder = CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f - (float)lefOffset, 4.0f, legDef);
        partDefinition.m_171599_("right_hind_leg", cubeListBuilder, PartPose.m_171419_((float)-3.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("left_hind_leg", cubeListBuilder, PartPose.m_171419_((float)3.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("right_front_leg", cubeListBuilder, PartPose.m_171419_((float)-3.0f, (float)14.0f, (float)-5.0f));
        partDefinition.m_171599_("left_front_leg", cubeListBuilder, PartPose.m_171419_((float)3.0f, (float)14.0f, (float)-5.0f));
        PartDefinition head = partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-5.0f, -4.0f, -2.0f, 2.0f, 2.0f, 1.0f, CubeDeformation.f_171458_).m_171514_(56, 3).m_171488_(3.0f, -4.0f, -2.0f, 2.0f, 2.0f, 1.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)-8.0f));
        head.m_171599_("goat_head", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-3.0f, -6.0f, -10.0f, 6.0f, 6.0f, 10.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)2.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f - (float)widthIncrement, -0.0f, -8.0f, 8.0f + (float)(2 * widthIncrement), 9.0f, 16.0f, bodyDef), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static LayerDefinition createFurLayer() {
        int lefH = 4;
        CubeDeformation legDef = new CubeDeformation(0.5f);
        CubeDeformation bodyDef = new CubeDeformation(1.75f);
        return GeepModel.createLayer(lefH, 1, legDef, bodyDef);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTick);
        this.f_103492_.f_104201_ = 5.0f + ((Geep)((Object)entity)).getHeadEatPositionScale(partialTick) * 9.0f;
        this.headXRot = ((Geep)((Object)entity)).getHeadEatAngleScale(partialTick);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.f_103492_.f_104203_ = this.headXRot;
    }
}

