/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.recipe.jei;

import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import teamrazor.deepaether.DeepAether;
import teamrazor.deepaether.init.DABlocks;
import teamrazor.deepaether.init.DAItems;
import teamrazor.deepaether.recipe.DARecipeTypes;
import teamrazor.deepaether.recipe.jei.CombinerRecipeCategory;
import teamrazor.deepaether.recipe.jei.MoaFodderSubtypeInterpreter;
import teamrazor.deepaether.recipe.jei.PoisonRecipeCategory;

@JeiPlugin
public class DAJEIPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return DeepAether.getResource("jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new PoisonRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CombinerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        registration.addRecipes(PoisonRecipeCategory.RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)DARecipeTypes.POISON_RECIPE.get()));
        registration.addRecipes(CombinerRecipeCategory.RECIPE_TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)DARecipeTypes.COMBINING.get()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)DAItems.PLACEABLE_POISON_BUCKET.get()), new RecipeType[]{PoisonRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)DABlocks.COMBINER.get()), new RecipeType[]{CombinerRecipeCategory.RECIPE_TYPE});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)DAItems.MOA_FODDER.get(), (IIngredientSubtypeInterpreter)MoaFodderSubtypeInterpreter.INSTANCE);
    }
}

