/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.item.gear.other;

import com.aetherteam.aether.item.accessories.ring.RingItem;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCooldownPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import teamrazor.deepaether.client.keys.DeepAetherKeys;
import teamrazor.deepaether.datagen.tags.DATags;
import teamrazor.deepaether.init.DAItems;
import teamrazor.deepaether.init.DASounds;
import teamrazor.deepaether.item.gear.EquipmentUtil;
import teamrazor.deepaether.networking.DeepAetherPlayer;
import top.theillusivec4.curios.api.SlotContext;

public class SliderEye
extends RingItem {
    public SliderEye(Supplier<? extends SoundEvent> ringSound, Item.Properties properties) {
        super(ringSound, properties);
    }

    private TargetingConditions targetingConditions(AABB aabb, Entity entity2) {
        return TargetingConditions.m_148352_().m_26888_(entity -> !entity.m_7306_(entity2) && entity.m_9236_().m_6857_().m_61935_(aabb));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Level level = slotContext.entity().m_9236_();
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (level.m_5776_()) {
                this.handleClient(player, stack, level);
            } else {
                this.handleServer(player, level);
            }
        }
    }

    private void handleServer(Player player, Level level) {
        Optional deepAetherPlayer = DeepAetherPlayer.get(player).resolve();
        if (deepAetherPlayer.isEmpty() || !((DeepAetherPlayer)deepAetherPlayer.get()).isSliderSlamActivated()) {
            return;
        }
        if (((DeepAetherPlayer)deepAetherPlayer.get()).isSliderSlamActivated()) {
            player.m_246865_(new Vec3(0.0, (double)-0.3f, 0.0));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
            }
            if (player.m_20096_()) {
                ((DeepAetherPlayer)deepAetherPlayer.get()).setSynched(INBTSynchable.Direction.CLIENT, "setSliderSlamActivated", false);
                AABB aabb = new AABB(player.m_20182_().m_82520_(-3.0, -1.0, -3.0), player.m_20182_().m_82520_(3.0, 4.0, 3.0));
                List entities = level.m_45971_(LivingEntity.class, this.targetingConditions(aabb, (Entity)player), (LivingEntity)player, aabb);
                float knockback = EquipmentUtil.getCurios((LivingEntity)player, (Item)DAItems.SLIDER_EYE.get()).size() == 2 ? 2.5f : 2.0f;
                for (LivingEntity target : entities) {
                    if (target.m_6095_().m_204039_(DATags.Entities.SLIDER_SLAM_BLACKLIST)) continue;
                    Vec3 push = target.m_20182_().m_82505_(player.m_20182_()).m_82548_().m_82541_().m_82542_((double)knockback, (double)knockback, (double)knockback);
                    if (push.f_82480_ < 0.0) {
                        push.m_82542_(1.0, -1.0, 1.0);
                    }
                    push.m_82520_(0.0, 1.0, 0.0);
                    target.m_246865_(push);
                    target.m_6469_(level.m_269111_().m_269075_(player), 1.0f);
                    if (!(target instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)target;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
                }
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123812_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (player.m_7500_()) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundCooldownPacket((Item)DAItems.SLIDER_EYE.get(), 0));
                    } else {
                        player.m_36335_().m_41524_((Item)DAItems.SLIDER_EYE.get(), 0);
                    }
                }
            }
        }
    }

    private void handleClient(Player player, ItemStack stack, Level level) {
        Optional deepAetherPlayer = DeepAetherPlayer.get(player).resolve();
        if (deepAetherPlayer.isEmpty() || !player.m_7578_()) {
            return;
        }
        if (this.mayUse(stack, player)) {
            int cooldown = EquipmentUtil.getCurios((LivingEntity)player, (Item)DAItems.SLIDER_EYE.get()).size() == 2 ? 150 : 200;
            player.m_36335_().m_41524_(stack.m_41720_(), cooldown);
            player.m_20334_(0.0, 0.0, 0.0);
            DeepAetherPlayer.get(player).ifPresent(aetherPlayer -> aetherPlayer.setSynched(INBTSynchable.Direction.SERVER, "setSliderSlamActivated", true));
            level.m_247517_(player, player.m_20097_(), (SoundEvent)DASounds.ITEM_ACCESSORY_ABILITY_SLIDER_EYE.get(), SoundSource.PLAYERS);
        }
        if (((DeepAetherPlayer)deepAetherPlayer.get()).isSliderSlamActivated() && !player.m_36335_().m_41519_((Item)DAItems.SLIDER_EYE.get())) {
            ((DeepAetherPlayer)deepAetherPlayer.get()).setSynched(INBTSynchable.Direction.SERVER, "setSliderSlamActivated", false);
        }
    }

    public boolean mayUse(ItemStack stack, Player player) {
        return DeepAetherKeys.SLIDER_EYE_SLAM_ABILITY.m_90857_() && !player.m_36335_().m_41519_(stack.m_41720_()) && !player.m_20096_();
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 200;
    }
}

