/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.item.dungeon.brass;

import com.aetherteam.aether.item.accessories.pendant.PendantItem;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import teamrazor.deepaether.entity.GentleWind;
import teamrazor.deepaether.networking.DeepAetherPlayer;
import top.theillusivec4.curios.api.SlotContext;

public class FloatyScarfItem
extends PendantItem {
    public FloatyScarfItem(ResourceLocation pendantLocation, Supplier<? extends SoundEvent> pendantSound, Item.Properties properties) {
        super(pendantLocation, pendantSound, properties);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (!stack.m_41619_()) {
            try {
                if (!slotContext.entity().m_9236_().m_5776_()) {
                    DeepAetherPlayer.get((Player)slotContext.entity()).ifPresent(aetherPlayer -> aetherPlayer.setSynched(INBTSynchable.Direction.CLIENT, "setFloatyScarfWrappedAroundNeck", true));
                }
                FloatyScarfItem.addGentleWind(stack, (Player)slotContext.entity());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        CompoundTag scarf = stack.m_41783_();
        if (scarf == null) {
            return;
        }
        Entity entity = FloatyScarfItem.getGentleWind(stack, slotContext.entity().m_9236_());
        if (entity == null || !entity.m_6084_()) {
            FloatyScarfItem.addGentleWind(stack, player);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (!stack.m_41619_()) {
            try {
                if (!slotContext.entity().m_9236_().m_5776_()) {
                    Optional deepAetherPlayer = DeepAetherPlayer.get((Player)slotContext.entity()).resolve();
                    deepAetherPlayer.ifPresent(aetherPlayer -> aetherPlayer.setSynched(INBTSynchable.Direction.CLIENT, "setFloatyScarfWrappedAroundNeck", false));
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            FloatyScarfItem.discardGentleWind(stack, slotContext.entity().m_9236_());
        }
    }

    public static void discardGentleWind(@NotNull ItemStack stack, Level level) {
        Entity entity = FloatyScarfItem.getGentleWind(stack, level);
        if (entity != null) {
            entity.m_146870_();
        }
    }

    public static void addGentleWind(@NotNull ItemStack stack, Player player) {
        CompoundTag scarf = stack.m_41784_();
        GentleWind eots = scarf.m_128441_("Colors") ? new GentleWind(player.m_9236_(), player, scarf.m_128465_("Colors")) : new GentleWind(player.m_9236_(), player);
        MutableComponent mutablecomponent = Component.m_237119_().m_7220_(stack.m_41786_());
        if (stack.m_41788_()) {
            eots.m_6593_((Component)mutablecomponent);
        }
        scarf.m_128405_("UUID", eots.m_19879_());
        stack.m_41751_(scarf);
    }

    public static Entity getGentleWind(ItemStack stack, Level level) {
        CompoundTag scarf = stack.m_41783_();
        return scarf != null ? level.m_6815_(scarf.m_128451_("UUID")) : null;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("Colors")) {
            int[] colors = tag.m_128465_("Colors");
            this.chatFormat(tooltipComponents, colors[0], 0, tag);
            this.chatFormat(tooltipComponents, colors[1], 1, tag);
            this.chatFormat(tooltipComponents, colors[2], 2, tag);
            this.chatFormat(tooltipComponents, colors[3], 3, tag);
            this.chatFormat(tooltipComponents, colors[4], 4, tag);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (state.m_60713_(Blocks.f_152476_)) {
            int[] colors;
            if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
                return InteractionResult.PASS;
            }
            CompoundTag tag = context.m_43722_().m_41784_();
            if (tag.m_128441_("Colors") && Arrays.stream(colors = tag.m_128465_("Colors")).anyMatch(value -> value != -1)) {
                LayeredCauldronBlock.m_153559_((BlockState)state, (Level)context.m_43725_(), (BlockPos)context.m_8083_());
                tag.m_128385_("Colors", new int[]{-1, -1, -1, -1, -1});
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void chatFormat(List<Component> tooltipComponents, int color, int mod, CompoundTag tag) {
        if (tag.m_128451_("currentModification") == mod) {
            tooltipComponents.add((Component)Component.m_237113_((String)"Color").m_130948_(Style.f_131099_.m_178520_(color)).m_130940_(ChatFormatting.ITALIC));
        } else {
            tooltipComponents.add((Component)Component.m_237113_((String)"Color").m_130948_(Style.f_131099_.m_178520_(color)));
        }
    }
}

