/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.init;

import com.aetherteam.aether.data.resources.AetherMobCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import teamrazor.deepaether.entity.AerglowFish;
import teamrazor.deepaether.entity.BabyZephyr;
import teamrazor.deepaether.entity.DABoatEntity;
import teamrazor.deepaether.entity.DAChestBoatEntity;
import teamrazor.deepaether.entity.FireProjectile;
import teamrazor.deepaether.entity.GentleWind;
import teamrazor.deepaether.entity.StormArrow;
import teamrazor.deepaether.entity.Venomite;
import teamrazor.deepaether.entity.VenomiteBubble;
import teamrazor.deepaether.entity.WindCrystal;
import teamrazor.deepaether.entity.Windfly;
import teamrazor.deepaether.entity.eots.EOTSController;
import teamrazor.deepaether.entity.eots.EOTSSegment;
import teamrazor.deepaether.entity.quail.Quail;
import teamrazor.deepaether.entity.quail.ThrownQuailEgg;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DAEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"deep_aether");
    public static final RegistryObject<EntityType<DABoatEntity>> BOAT = ENTITY_TYPES.register("boat", () -> EntityType.Builder.m_20704_(DABoatEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_("boat"));
    public static final RegistryObject<EntityType<DAChestBoatEntity>> CHEST_BOAT = ENTITY_TYPES.register("chest_boat", () -> EntityType.Builder.m_20704_(DAChestBoatEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_("chest_boat"));
    public static final RegistryObject<EntityType<ThrownQuailEgg>> QUAIL_EGG = ENTITY_TYPES.register("quail_egg", () -> EntityType.Builder.m_20704_(ThrownQuailEgg::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10).m_20712_("quail_egg"));
    public static final RegistryObject<EntityType<AerglowFish>> AERGLOW_FISH = DAEntities.register("aerglow_fish", EntityType.Builder.m_20704_(AerglowFish::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).m_20702_(10).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<Quail>> QUAIL = DAEntities.register("quail", EntityType.Builder.m_20704_(Quail::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).m_20702_(10).m_20699_(0.35f, 0.7f));
    public static final RegistryObject<EntityType<Venomite>> VENOMITE = DAEntities.register("venomite", Venomite::new, 0.7f, 0.6f);
    public static final RegistryObject<EntityType<Windfly>> WINDFLY = DAEntities.register("windfly", Windfly::new, 1.0f, 0.3f);
    public static final RegistryObject<EntityType<EOTSController>> EOTS_CONTROLLER = DAEntities.register("eots_controller", EOTSController::new, 3.0f, 3.0f);
    public static final RegistryObject<EntityType<EOTSSegment>> EOTS_SEGMENT = DAEntities.register("eots_segment", EOTSSegment::new, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<WindCrystal>> WIND_CRYSTAL = ENTITY_TYPES.register("wind_crystal", () -> EntityType.Builder.m_20704_(WindCrystal::new, (MobCategory)MobCategory.MISC).m_20699_(0.85f, 0.85f).m_20702_(4).m_20717_(10).m_20719_().m_20712_("wind_crystal"));
    public static final RegistryObject<EntityType<FireProjectile>> FIRE_PROJECTILE = ENTITY_TYPES.register("fire_projectile", () -> EntityType.Builder.m_20704_(FireProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(0.35f, 0.35f).m_20702_(4).m_20717_(10).m_20712_("fire_projectile"));
    public static final RegistryObject<EntityType<VenomiteBubble>> VENOMITE_BUBBLE = ENTITY_TYPES.register("venomite_bubble", () -> EntityType.Builder.m_20704_(VenomiteBubble::new, (MobCategory)MobCategory.MISC).m_20699_(0.35f, 0.2f).m_20702_(4).m_20717_(10).m_20712_("venomite_bubble"));
    public static final RegistryObject<EntityType<BabyZephyr>> BABY_ZEPHYR = ENTITY_TYPES.register("baby_zephyr", () -> EntityType.Builder.m_20704_(BabyZephyr::new, (MobCategory)AetherMobCategory.AETHER_SKY_MONSTER).m_20699_(1.5f, 1.0f).m_20702_(10).m_20712_("baby_zephyr"));
    public static final RegistryObject<EntityType<StormArrow>> STORM_ARROW = ENTITY_TYPES.register("storm_arrow", () -> EntityType.Builder.m_20704_(StormArrow::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20).m_20712_("storm_arrow"));
    public static final RegistryObject<EntityType<GentleWind>> GENTLE_WIND = DAEntities.register("gentle_wind", GentleWind::new, 1.0f, 0.3f);

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return ENTITY_TYPES.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    private static <T extends Mob> RegistryObject<EntityType<T>> register(String name, EntityType.EntityFactory<T> entity, float width, float height) {
        return ENTITY_TYPES.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)entity, (MobCategory)MobCategory.CREATURE).m_20699_(width, height).m_20712_(name));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Quail.init();
            AerglowFish.init();
            Venomite.init();
            Windfly.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)AERGLOW_FISH.get(), AerglowFish.m_27495_().m_22265_());
        event.put((EntityType)QUAIL.get(), Quail.createAttributes().m_22265_());
        event.put((EntityType)VENOMITE.get(), Venomite.createAttributes().m_22265_());
        event.put((EntityType)EOTS_SEGMENT.get(), EOTSSegment.m_21552_().m_22265_());
        event.put((EntityType)EOTS_CONTROLLER.get(), EOTSController.m_21552_().m_22265_());
        event.put((EntityType)WINDFLY.get(), Windfly.createAttributes().m_22265_());
        event.put((EntityType)BABY_ZEPHYR.get(), BabyZephyr.m_21552_().m_22265_());
        event.put((EntityType)GENTLE_WIND.get(), GentleWind.m_21552_().m_22265_());
    }
}

