/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.shared.effect;

import dev.foxgirl.pickaxetrims.shared.OreDetectUtil;
import dev.foxgirl.pickaxetrims.shared.PickaxeTrimsImpl;
import dev.foxgirl.pickaxetrims.shared.effect.AbstractEffect;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class LapisGlowEffect
extends AbstractEffect {
    private final Map<BlockPos, ShulkerEntityState> activeShulkers = new HashMap<BlockPos, ShulkerEntityState>();

    private void highlightBlock(ServerPlayer player, BlockPos pos, Block block) {
        this.activeShulkers.computeIfAbsent(pos, __ -> new ShulkerEntityState(player.m_284548_(), pos, block)).resetTicks();
    }

    private void highlightBlocks(ServerPlayer player, Block expectedBlock) {
        int radius = PickaxeTrimsImpl.getInstance().config.lapisGlowRadius;
        double radiusSquaredDistance = radius * radius;
        BlockPos playerPos = player.m_20183_().m_7494_();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block actualBlock;
                    BlockPos blockPos = playerPos.m_7918_(x, y, z);
                    if (!(blockPos.m_123331_((Vec3i)playerPos) <= radiusSquaredDistance) || (actualBlock = player.m_9236_().m_8055_(blockPos).m_60734_()) != expectedBlock) continue;
                    this.highlightBlock(player, blockPos, expectedBlock);
                }
            }
        }
    }

    @Override
    public void onTickEnd(@NotNull MinecraftServer server) {
        this.activeShulkers.values().removeIf(ShulkerEntityState::update);
    }

    @Override
    public void onBlockBreak(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ServerPlayer player) {
        Block block = state.m_60734_();
        if (OreDetectUtil.isOreBlock(block)) {
            this.highlightBlocks(player, block);
        }
    }

    private static final class ShulkerEntityState {
        private final ServerLevel world;
        private final BlockPos pos;
        private final Block block;
        private int ticks;
        private final Shulker entity;

        public ShulkerEntityState(ServerLevel world, BlockPos pos, Block block) {
            this.world = world;
            this.pos = pos;
            this.block = block;
            this.resetTicks();
            this.entity = new Shulker(EntityType.f_20521_, (Level)world);
            this.entity.m_20343_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19609_, -1, 0, false, false));
            this.updateEntityFlags();
            world.m_7967_((Entity)this.entity);
        }

        private void resetTicks() {
            this.ticks = (int)(20.0f * PickaxeTrimsImpl.getInstance().config.lapisGlowSeconds);
        }

        private void updateEntityFlags() {
            this.entity.m_20331_(true);
            this.entity.m_21557_(true);
            this.entity.m_6842_(true);
            this.entity.m_146915_(true);
        }

        private boolean update() {
            if (this.ticks-- <= 0 || this.world.m_8055_(this.pos).m_60734_() != this.block) {
                this.entity.m_142687_(Entity.RemovalReason.DISCARDED);
                return true;
            }
            this.updateEntityFlags();
            return false;
        }
    }
}

