/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.stairs.FramedHalfStairsBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.StairsType;

public class FramedVerticalStairsBlock
extends FramedBlock {
    public FramedVerticalStairsBlock() {
        super(BlockType.FRAMED_VERTICAL_STAIRS);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.STATE_LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.STAIRS_TYPE, BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.STATE_LOCKED});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHalfOrHorizontalFacing()).withCustom((state, modCtx) -> this.getStateFromContext((BlockState)state, (LevelAccessor)modCtx.m_43725_(), modCtx.m_8083_()))).build();
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (facing != dir.m_122424_() && facing != dir.m_122427_()) {
            state = this.getStateFromContext(state, level, pos);
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    private BlockState getStateFromContext(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean top;
        if (((Boolean)state.m_61143_((Property)FramedProperties.STATE_LOCKED)).booleanValue()) {
            return state;
        }
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        BlockState front = level.m_8055_(pos.m_121945_(dir));
        BlockState left = level.m_8055_(pos.m_121945_(dir.m_122428_()));
        if (FramedVerticalStairsBlock.isNoStair(front) && FramedVerticalStairsBlock.isNoStair(left)) {
            return (BlockState)state.m_61124_(PropertyHolder.STAIRS_TYPE, (Comparable)((Object)StairsType.VERTICAL));
        }
        boolean topCorner = false;
        boolean bottomCorner = false;
        if (front.m_60734_() instanceof StairBlock && front.m_61143_((Property)BlockStateProperties.f_61374_) == dir.m_122428_()) {
            topCorner = front.m_61143_((Property)BlockStateProperties.f_61402_) == Half.BOTTOM;
            bottomCorner = front.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        } else if (front.m_60734_() instanceof FramedHalfStairsBlock && front.m_61143_((Property)FramedProperties.FACING_HOR) == dir.m_122428_()) {
            top = (Boolean)front.m_61143_((Property)FramedProperties.TOP);
            if (!((Boolean)front.m_61143_((Property)PropertyHolder.RIGHT)).booleanValue()) {
                topCorner = !top;
                bottomCorner = top;
            }
        }
        if (left.m_60734_() instanceof StairBlock && left.m_61143_((Property)BlockStateProperties.f_61374_) == dir) {
            topCorner |= left.m_61143_((Property)BlockStateProperties.f_61402_) == Half.BOTTOM;
            bottomCorner |= left.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        } else if (left.m_60734_() instanceof FramedHalfStairsBlock && left.m_61143_((Property)FramedProperties.FACING_HOR) == dir) {
            top = (Boolean)left.m_61143_((Property)FramedProperties.TOP);
            if (((Boolean)left.m_61143_((Property)PropertyHolder.RIGHT)).booleanValue()) {
                topCorner = !top;
                bottomCorner = top;
            }
        }
        BlockState above = level.m_8055_(pos.m_7494_());
        BlockState below = level.m_8055_(pos.m_7495_());
        StairsType type = topCorner && !above.m_60713_((Block)this) ? StairsType.TOP_CORNER : (bottomCorner && !below.m_60713_((Block)this) ? StairsType.BOTTOM_CORNER : StairsType.VERTICAL);
        return (BlockState)state.m_61124_(PropertyHolder.STAIRS_TYPE, (Comparable)((Object)type));
    }

    private static boolean isNoStair(BlockState state) {
        return !(state.m_60734_() instanceof StairBlock) && !(state.m_60734_() instanceof FramedHalfStairsBlock);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }
}

