/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.special;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.ghost.CamoPair;
import xfacthd.framedblocks.api.ghost.GhostRenderBehaviour;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.model.util.ModelCache;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.render.util.GhostVertexConsumer;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;

public final class GhostBlockRenderer {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static ModelData MODEL_DATA;
    private static final FramedBlockData GHOST_MODEL_DATA;
    private static final FramedBlockData GHOST_MODEL_DATA_TWO;
    private static final Map<Item, GhostRenderBehaviour> RENDER_BEHAVIOURS;
    private static boolean locked;
    private static final GhostRenderBehaviour DEFAULT_BEHAVIOUR;
    private static final String PROFILER_KEY = "framedblocks_ghost_block";
    private static final float SCALE = 1.0001f;

    public static void init() {
        MODEL_DATA = ModelData.builder().with(FramedBlockData.PROPERTY, (Object)GHOST_MODEL_DATA).with(FramedDoubleBlockEntity.DATA_LEFT, (Object)ModelData.builder().with(FramedBlockData.PROPERTY, (Object)GHOST_MODEL_DATA).build()).with(FramedDoubleBlockEntity.DATA_RIGHT, (Object)ModelData.builder().with(FramedBlockData.PROPERTY, (Object)GHOST_MODEL_DATA_TWO).build()).build();
        GHOST_MODEL_DATA.setCamoState(Blocks.f_50016_.m_49966_());
        GHOST_MODEL_DATA_TWO.setCamoState(Blocks.f_50016_.m_49966_());
        GHOST_MODEL_DATA_TWO.setUseAltModel(true);
    }

    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (!ClientConfig.showGhostBlocks || event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        ProfilerFiller profiler = GhostBlockRenderer.mc().m_91307_();
        profiler.m_6180_(PROFILER_KEY);
        try {
            GhostBlockRenderer.tryDrawGhostBlock(event.getPoseStack(), profiler);
        }
        catch (Throwable t) {
            CrashReport report = CrashReport.m_127521_((Throwable)t, (String)"FramedBlocks: Rendering placement preview");
            CrashReportCategory category = report.m_127514_("Placement preview context");
            GhostBlockRenderer.mc().f_91074_.m_7976_(category);
            category.m_128159_("Rotation", (Object)Float.valueOf(GhostBlockRenderer.mc().f_91074_.m_146908_()));
            category.m_128159_("Direction", (Object)GhostBlockRenderer.mc().f_91074_.m_6350_());
            category.m_128159_("Held item", (Object)Utils.formatItemStack(GhostBlockRenderer.mc().f_91074_.m_21205_()));
            category.m_128159_("Level", (Object)GhostBlockRenderer.mc().f_91073_);
            category.m_128159_("Hit result", (Object)Utils.formatHitResult(GhostBlockRenderer.mc().f_91077_));
            category.m_128174_(category.m_128143_().length);
            throw new ReportedException(report);
        }
        profiler.m_7238_();
    }

    private static void tryDrawGhostBlock(PoseStack poseStack, ProfilerFiller profiler) {
        BlockHitResult hit;
        if (GhostBlockRenderer.mc().f_91074_.m_5833_()) {
            return;
        }
        HitResult hitResult = GhostBlockRenderer.mc().f_91077_;
        if (!(hitResult instanceof BlockHitResult) || (hit = (BlockHitResult)hitResult).m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        ItemStack stack = GhostBlockRenderer.mc().f_91074_.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        GhostRenderBehaviour behaviour = RENDER_BEHAVIOURS.getOrDefault(stack.m_41720_(), DEFAULT_BEHAVIOUR);
        profiler.m_6180_("get_stack");
        ItemStack proxiedStack = behaviour.getProxiedStack(stack);
        profiler.m_7238_();
        profiler.m_6180_("may_render");
        if (!behaviour.mayRender(stack, proxiedStack)) {
            profiler.m_7238_();
            return;
        }
        profiler.m_7238_();
        profiler.m_6180_("make_context");
        BlockPlaceContext context = new BlockPlaceContext((Player)GhostBlockRenderer.mc().f_91074_, InteractionHand.MAIN_HAND, stack, hit);
        BlockState hitState = GhostBlockRenderer.mc().f_91073_.m_8055_(hit.m_82425_());
        profiler.m_7238_();
        GhostBlockRenderer.drawGhostBlock(poseStack, profiler, behaviour, stack, proxiedStack, hit, context, hitState, false);
    }

    private static void drawGhostBlock(PoseStack poseStack, ProfilerFiller profiler, GhostRenderBehaviour behaviour, ItemStack stack, ItemStack proxiedStack, BlockHitResult hit, BlockPlaceContext context, BlockState hitState, boolean secondPass) {
        profiler.m_6180_("get_state");
        BlockState renderState = behaviour.getRenderState(stack, proxiedStack, hit, context, hitState, secondPass);
        profiler.m_7238_();
        if (renderState == null) {
            return;
        }
        profiler.m_6180_("get_pos");
        BlockPos renderPos = behaviour.getRenderPos(stack, proxiedStack, hit, context, hitState, context.m_8083_(), secondPass);
        profiler.m_6182_("can_render");
        if (!secondPass && !behaviour.canRenderAt(stack, proxiedStack, hit, context, hitState, renderState, renderPos)) {
            profiler.m_7238_();
            return;
        }
        profiler.m_7238_();
        profiler.m_6180_("get_camo");
        CamoPair camo = behaviour.readCamo(stack, proxiedStack, secondPass);
        camo = behaviour.postProcessCamo(stack, proxiedStack, context, renderState, secondPass, camo);
        GHOST_MODEL_DATA.setCamoState(camo.getCamoOne());
        GHOST_MODEL_DATA_TWO.setCamoState(camo.getCamoTwo());
        profiler.m_7238_();
        profiler.m_6180_("append_modeldata");
        ModelData modelData = behaviour.appendModelData(stack, proxiedStack, context, renderState, secondPass, MODEL_DATA);
        profiler.m_7238_();
        MultiBufferSource.BufferSource buffers = GhostBlockRenderer.mc().m_91269_().m_110104_();
        GhostBlockRenderer.doRenderGhostBlock(poseStack, buffers, profiler, renderPos, renderState, modelData);
        GHOST_MODEL_DATA.setCamoState(Blocks.f_50016_.m_49966_());
        GHOST_MODEL_DATA_TWO.setCamoState(Blocks.f_50016_.m_49966_());
        if (!secondPass && behaviour.hasSecondBlock(stack, proxiedStack)) {
            GhostBlockRenderer.drawGhostBlock(poseStack, profiler, behaviour, stack, proxiedStack, hit, context, hitState, true);
        }
    }

    private static void doRenderGhostBlock(PoseStack poseStack, MultiBufferSource.BufferSource buffers, ProfilerFiller profiler, BlockPos renderPos, BlockState renderState, ModelData modelData) {
        RenderType bufferType = ClientConfig.altGhostRenderer ? Sheets.m_110792_() : ForgeRenderTypes.TRANSLUCENT_ON_PARTICLES_TARGET.get();
        profiler.m_6180_("buffer");
        Vec3 offset = Vec3.m_82528_((Vec3i)renderPos).m_82546_(GhostBlockRenderer.mc().f_91063_.m_109153_().m_90583_());
        GhostVertexConsumer builder = new GhostVertexConsumer(buffers.m_6299_(bufferType), 170);
        profiler.m_7238_();
        profiler.m_6180_("draw");
        BakedModel model = ModelCache.getModel(renderState);
        poseStack.m_85836_();
        poseStack.m_85837_(offset.f_82479_ + 0.5, offset.f_82480_ + 0.5, offset.f_82481_ + 0.5);
        poseStack.m_85841_(1.0001f, 1.0001f, 1.0001f);
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        for (RenderType type : model.getRenderTypes(renderState, RANDOM, modelData)) {
            GhostBlockRenderer.doRenderGhostBlockInLayer(poseStack, (VertexConsumer)builder, renderPos, renderState, type, modelData);
        }
        poseStack.m_85849_();
        profiler.m_7238_();
        profiler.m_6180_("upload");
        RenderSystem.enableCull();
        buffers.m_109912_(bufferType);
        profiler.m_7238_();
    }

    private static void doRenderGhostBlockInLayer(PoseStack poseStack, VertexConsumer builder, BlockPos renderPos, BlockState renderState, RenderType layer, ModelData modelData) {
        GhostBlockRenderer.mc().m_91289_().renderBatched(renderState, renderPos, (BlockAndTintGetter)GhostBlockRenderer.mc().f_91073_, poseStack, builder, false, RANDOM, modelData, layer);
    }

    public static synchronized void registerBehaviour(GhostRenderBehaviour behaviour, Block ... blocks) {
        Preconditions.checkState((!locked ? 1 : 0) != 0, (Object)"GhostRenderBehaviour registry is locked!");
        Preconditions.checkNotNull((Object)behaviour, (Object)"GhostRenderBehaviour must be non-null");
        Preconditions.checkNotNull((Object)blocks, (Object)"Blocks array must be non-null to register a GhostRenderBehaviour");
        Preconditions.checkArgument((blocks.length > 0 ? 1 : 0) != 0, (Object)"At least one block must be provided to register a GhostRenderBehaviour");
        for (Block block : blocks) {
            Item item = block.m_5456_();
            Preconditions.checkState((boolean)(item instanceof BlockItem), (Object)"Block must have an associated BlockItem");
            GhostBlockRenderer.registerBehaviour(behaviour, item);
        }
    }

    public static synchronized void registerBehaviour(GhostRenderBehaviour behaviour, Item ... items) {
        Preconditions.checkState((!locked ? 1 : 0) != 0, (Object)"GhostRenderBehaviour registry is locked!");
        Preconditions.checkNotNull((Object)behaviour, (Object)"GhostRenderBehaviour must be non-null");
        Preconditions.checkNotNull((Object)items, (Object)"Items array must be non-null to register a GhostRenderBehaviour");
        Preconditions.checkArgument((items.length > 0 ? 1 : 0) != 0, (Object)"At least one item must be provided to register a GhostRenderBehaviour");
        for (Item item : items) {
            RENDER_BEHAVIOURS.put(item, behaviour);
        }
    }

    public static GhostRenderBehaviour getBehaviour(Item item) {
        return RENDER_BEHAVIOURS.getOrDefault(item, DEFAULT_BEHAVIOUR);
    }

    public static void lockRegistration() {
        locked = true;
    }

    private static Minecraft mc() {
        return Minecraft.m_91087_();
    }

    private GhostBlockRenderer() {
    }

    static {
        GHOST_MODEL_DATA = new FramedBlockData();
        GHOST_MODEL_DATA_TWO = new FramedBlockData();
        RENDER_BEHAVIOURS = new IdentityHashMap<Item, GhostRenderBehaviour>();
        locked = false;
        DEFAULT_BEHAVIOUR = new GhostRenderBehaviour(){};
    }
}

