/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.ThornwoodBranchBlock;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class ThornwoodTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public ThornwoodTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int centerAboveGround;
        int height;
        BlockPos treeGround;
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        if (!this.checkCanTreePlace(level, treeGround = context.m_159777_(), height = (centerAboveGround = randomsource.m_188503_(5)) + 4 + randomsource.m_188503_(5))) {
            return false;
        }
        BlockPos centerPos = treeGround.m_6630_(centerAboveGround);
        if (centerAboveGround > 0) {
            int rootCount = 0;
            for (Direction direction : ACMath.HORIZONTAL_DIRECTIONS) {
                if (rootCount > 3 + randomsource.m_188503_(1)) continue;
                ThornwoodTreeFeature.generateRoot(level, centerPos.m_121945_(direction), 0.25f, randomsource, direction, centerAboveGround + 1 + randomsource.m_188503_(6));
                ++rootCount;
            }
        }
        BlockPos.MutableBlockPos trunkPos = new BlockPos.MutableBlockPos();
        int i = 0;
        trunkPos.m_122190_((Vec3i)centerPos);
        trunkPos.m_122184_(0, -1, 0);
        int tallPart = height - centerAboveGround;
        while (i < tallPart) {
            ++i;
            trunkPos.m_122184_(0, 1, 0);
            if (randomsource.m_188503_(5) == 0) {
                level.m_7731_((BlockPos)trunkPos, ((Block)ACBlockRegistry.THORNWOOD_WOOD.get()).m_49966_(), 3);
                trunkPos.m_122173_((Direction)Util.m_214670_((Object[])ACMath.HORIZONTAL_DIRECTIONS, (RandomSource)randomsource));
                level.m_7731_((BlockPos)trunkPos, ((Block)ACBlockRegistry.THORNWOOD_WOOD.get()).m_49966_(), 3);
            } else {
                level.m_7731_((BlockPos)trunkPos, i == tallPart ? ((Block)ACBlockRegistry.THORNWOOD_WOOD.get()).m_49966_() : ((Block)ACBlockRegistry.THORNWOOD_LOG.get()).m_49966_(), 3);
            }
            ThornwoodTreeFeature.decorateLog(level, (BlockPos)trunkPos, randomsource, true);
        }
        BlockPos canopy = trunkPos.m_7949_();
        BlockPos.MutableBlockPos canopyLogPos = new BlockPos.MutableBlockPos();
        for (Direction direction : ACMath.HORIZONTAL_DIRECTIONS) {
            canopyLogPos.m_122190_((Vec3i)canopy);
            int canopyLength = 1 + randomsource.m_188503_(3);
            for (int j = 1; j <= canopyLength; ++j) {
                boolean upFlag = false;
                canopyLogPos.m_122173_(direction);
                if (randomsource.m_188503_(2) != 0) {
                    upFlag = true;
                    level.m_7731_((BlockPos)canopyLogPos, (BlockState)((Block)ACBlockRegistry.THORNWOOD_WOOD.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 3);
                    canopyLogPos.m_122184_(0, 1, 0);
                }
                if (j == canopyLength && level.m_8055_((BlockPos)canopyLogPos).m_247087_()) {
                    level.m_7731_((BlockPos)canopyLogPos, (BlockState)((BlockState)((Block)ACBlockRegistry.THORNWOOD_BRANCH.get()).m_49966_().m_61124_((Property)ThornwoodBranchBlock.FACING, (Comparable)(upFlag ? Direction.UP : direction))).m_61124_((Property)ThornwoodBranchBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_((BlockPos)canopyLogPos).m_192917_((Fluid)Fluids.f_76193_))), 3);
                    continue;
                }
                Block wood = j == canopyLength - 1 || upFlag ? (Block)ACBlockRegistry.THORNWOOD_WOOD.get() : (Block)ACBlockRegistry.THORNWOOD_LOG.get();
                level.m_7731_((BlockPos)canopyLogPos, (BlockState)wood.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 3);
                ThornwoodTreeFeature.decorateLog(level, (BlockPos)trunkPos, randomsource, true);
            }
        }
        return true;
    }

    private boolean checkCanTreePlace(WorldGenLevel level, BlockPos treeBottom, int height) {
        BlockState below = level.m_8055_(treeBottom.m_7495_());
        if (!(below.m_204336_(BlockTags.f_144274_) || below.m_60713_((Block)ACBlockRegistry.GUANOSTONE.get()) || below.m_60713_((Block)ACBlockRegistry.COPROLITH.get()) || below.m_60713_(Blocks.f_220843_))) {
            return false;
        }
        for (int i = 0; i < height; ++i) {
            if (ThornwoodTreeFeature.canReplace(level.m_8055_(treeBottom.m_6630_(i)))) continue;
            return false;
        }
        BlockPos treeTop = treeBottom.m_6630_(height).m_7949_();
        for (BlockPos checkLeaf : BlockPos.m_121940_((BlockPos)treeTop.m_7918_(-2, -1, -2), (BlockPos)treeTop.m_7918_(2, 1, 2))) {
            if (ThornwoodTreeFeature.canReplace(level.m_8055_(checkLeaf))) continue;
            return false;
        }
        return true;
    }

    protected static void decorateLog(WorldGenLevel level, BlockPos from, RandomSource random, boolean logBranches) {
        if (random.m_188501_() < 0.65f) {
            Direction ranDir = (Direction)Util.m_214670_((Object[])Direction.values(), (RandomSource)random);
            BlockPos branchPos = from.m_7949_().m_121945_(ranDir);
            if (level.m_8055_(branchPos).m_247087_()) {
                if (logBranches && random.m_188501_() < 0.4f) {
                    int bigBranchLength = 1 + random.m_188503_(1);
                    for (int i = 0; i < bigBranchLength; ++i) {
                        Block wood = i == bigBranchLength - 1 ? (Block)ACBlockRegistry.THORNWOOD_WOOD.get() : (Block)ACBlockRegistry.THORNWOOD_LOG.get();
                        level.m_7731_(branchPos, (BlockState)wood.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)ranDir.m_122434_()), 3);
                        branchPos = branchPos.m_121945_(ranDir);
                    }
                }
                level.m_7731_(branchPos, (BlockState)((BlockState)((Block)ACBlockRegistry.THORNWOOD_BRANCH.get()).m_49966_().m_61124_((Property)ThornwoodBranchBlock.FACING, (Comparable)ranDir)).m_61124_((Property)ThornwoodBranchBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(branchPos).m_192917_((Fluid)Fluids.f_76193_))), 3);
            }
        }
    }

    public static void generateRoot(WorldGenLevel level, BlockPos from, float bendChance, RandomSource random, Direction direction, int length) {
        BlockPos.MutableBlockPos at = new BlockPos.MutableBlockPos();
        at.m_122190_((Vec3i)from);
        for (int i = 0; i < length; ++i) {
            if (level.m_8055_((BlockPos)at).m_204336_(ACTagRegistry.UNMOVEABLE)) {
                return;
            }
            if (random.m_188501_() < bendChance) {
                if (!level.m_8055_((BlockPos)at).m_60713_((Block)ACBlockRegistry.THORNWOOD_WOOD.get())) {
                    level.m_7731_((BlockPos)at, (BlockState)((Block)ACBlockRegistry.THORNWOOD_WOOD.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 3);
                }
                at.m_122184_(0, -1, 0);
                at.m_122173_(direction);
                level.m_7731_((BlockPos)at, ((Block)ACBlockRegistry.THORNWOOD_WOOD.get()).m_49966_(), 3);
            } else {
                at.m_122184_(0, -1, 0);
                level.m_7731_((BlockPos)at, i == 0 ? ((Block)ACBlockRegistry.THORNWOOD_WOOD.get()).m_49966_() : ((Block)ACBlockRegistry.THORNWOOD_LOG.get()).m_49966_(), 3);
            }
            ThornwoodTreeFeature.decorateLog(level, (BlockPos)at, random, false);
        }
        BlockPos rootPos = at.m_7949_().m_7495_();
        if (level.m_8055_(rootPos).m_247087_()) {
            level.m_7731_(rootPos, (BlockState)((BlockState)((Block)ACBlockRegistry.THORNWOOD_BRANCH.get()).m_49966_().m_61124_((Property)ThornwoodBranchBlock.FACING, (Comparable)Direction.DOWN)).m_61124_((Property)ThornwoodBranchBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(rootPos).m_192917_((Fluid)Fluids.f_76193_))), 3);
        }
    }

    private static boolean canReplace(BlockState state) {
        return (state.m_60795_() || state.m_247087_() || state.m_60713_((Block)ACBlockRegistry.THORNWOOD_BRANCH.get()) || state.m_204336_(BlockTags.f_144274_) || state.m_60713_(Blocks.f_220843_)) && !state.m_204336_(ACTagRegistry.UNMOVEABLE);
    }
}

