/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.entity.ai.GroundPathNavigatorNoSpin;
import com.github.alexmodguy.alexscaves.server.entity.item.GumballEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.CaniacEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.PossessedByLicowitch;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GumbeeperEntity
extends Monster
implements PowerableMob,
PossessedByLicowitch {
    private float explodeProgress;
    private float prevExplodeProgress;
    private float prevDialRot;
    private float dialRot;
    private float shootProgress;
    private float prevShootProgress;
    private static final int DEFAULT_GUMBALLS = 6;
    private static final float MAX_DIAL_ROT = 450.0f;
    private int catScareTime = 0;
    private int postShootTime = 0;
    private boolean hasExploded;
    private static final EntityDataAccessor<Boolean> EXPLODING = SynchedEntityData.m_135353_(GumbeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOOTING = SynchedEntityData.m_135353_(GumbeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> ATTACK_CHARGE = SynchedEntityData.m_135353_(GumbeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> GUMBALLS_LEFT = SynchedEntityData.m_135353_(GumbeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHARGED = SynchedEntityData.m_135353_(GumbeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> POSSESSOR_LICOWITCH_ID = SynchedEntityData.m_135353_(GumbeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GumbeeperEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal<Cat>((PathfinderMob)this, Cat.class, 10.0f, 1.0, 1.2){

            public void m_8037_() {
                super.m_8037_();
                GumbeeperEntity.this.catScareTime = 20;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 45));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Husk.class, true, false));
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigatorNoSpin((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public static boolean checkGumbeeperSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return GumbeeperEntity.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource) && randomSource.m_188503_(10) == 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EXPLODING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_CHARGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(GUMBALLS_LEFT, (Object)6);
        this.f_19804_.m_135372_(SHOOTING, (Object)false);
        this.f_19804_.m_135372_(CHARGED, (Object)false);
        this.f_19804_.m_135372_(POSSESSOR_LICOWITCH_ID, (Object)-1);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevExplodeProgress = this.explodeProgress;
        this.prevDialRot = this.dialRot;
        this.prevShootProgress = this.shootProgress;
        float attackCharge = this.getAttackCharge();
        if (this.isExploding() && this.explodeProgress < 20.0f) {
            this.explodeProgress += 1.0f;
        }
        if (!this.isExploding() && this.explodeProgress > 0.0f) {
            this.explodeProgress -= 1.0f;
        }
        if (this.isShooting() && this.shootProgress < 5.0f) {
            this.shootProgress = Math.min(5.0f, this.shootProgress + 2.5f);
        }
        if (!this.isShooting() && this.shootProgress > 0.0f) {
            this.shootProgress = Math.max(0.0f, this.shootProgress - 1.0f);
        }
        this.dialRot = attackCharge == 0.0f ? (Mth.m_14177_((float)this.dialRot) != 0.0f ? Mth.m_14148_((float)this.dialRot, (float)0.0f, (float)30.0f) : 0.0f) : Mth.m_14121_((float)this.dialRot, (float)(450.0f * attackCharge), (float)10.0f);
        if (this.postShootTime > 0) {
            --this.postShootTime;
        } else {
            this.setShooting(false);
        }
        if (this.isExploding()) {
            if (this.m_9236_().f_46443_ && this.explodeProgress >= 18.0f) {
                for (int i = 0; i < 3 + this.f_19796_.m_188503_(2); ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20208_(0.3f), this.m_20187_(), this.m_20262_(0.3f), 0.0, 0.0, 0.0);
                }
            }
            if (this.explodeProgress >= 20.0f) {
                if (!this.m_9236_().f_46443_ && !this.hasExploded) {
                    int gumballs = this.isCharged() ? 30 : 15;
                    for (int i = 0; i < gumballs + this.f_19796_.m_188503_(5); ++i) {
                        GumballEntity gumball = new GumballEntity(this.m_9236_(), (LivingEntity)this);
                        gumball.m_146884_(new Vec3(this.m_20208_(0.3f), this.m_20186_() + (double)0.7f + (double)(this.f_19796_.m_188501_() * 0.5f), this.m_20262_(0.3f)));
                        Vec3 delta = new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.25f), (double)(this.f_19796_.m_188501_() - 0.5f)).m_82541_().m_82490_((double)(this.f_19796_.m_188501_() * 0.25f + 0.75f));
                        gumball.m_20256_(delta);
                        this.m_9236_().m_7967_((Entity)gumball);
                        if (this.isCharged()) {
                            gumball.setMaximumBounces(10);
                            gumball.setDamage((float)this.m_21051_(Attributes.f_22281_).m_22135_() + 2.0f);
                            continue;
                        }
                        gumball.setDamage((float)this.m_21051_(Attributes.f_22281_).m_22135_());
                    }
                    this.hasExploded = true;
                    this.m_146870_();
                }
                this.m_216990_((SoundEvent)ACSoundRegistry.GUMBEEPER_EXPLODE.get());
            }
        }
        if (this.isCharged() && this.m_6084_() && this.f_19797_ % 150 == 0) {
            this.m_5634_(1.0f);
        }
        if (this.m_9236_().f_46443_) {
            this.spawnPossessedParticles(this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), this.m_9236_());
        }
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(flying ? this.m_20186_() - this.f_19855_ : 0.0), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 8.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_204117_(ItemTags.f_262757_)) {
            SoundEvent soundevent = itemstack.m_150930_(Items.f_42613_) ? SoundEvents.f_11874_ : SoundEvents.f_11942_;
            this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundevent, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.m_9236_().f_46443_) {
                this.setExploding(true);
                itemstack.m_41622_(1, (LivingEntity)player, p_32290_ -> p_32290_.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_8038_(ServerLevel serverLevel, LightningBolt lightningBolt) {
        super.m_8038_(serverLevel, lightningBolt);
        this.setCharged(true);
    }

    public boolean isExploding() {
        return (Boolean)this.f_19804_.m_135370_(EXPLODING);
    }

    public void setExploding(boolean explode) {
        this.f_19804_.m_135381_(EXPLODING, (Object)explode);
    }

    public void setGumballsLeft(int i) {
        this.f_19804_.m_135381_(GUMBALLS_LEFT, (Object)i);
    }

    public int getGumballsLeft() {
        return (Integer)this.f_19804_.m_135370_(GUMBALLS_LEFT);
    }

    public void setAttackCharge(float f) {
        this.f_19804_.m_135381_(ATTACK_CHARGE, (Object)Float.valueOf(f));
    }

    public float getAttackCharge() {
        return ((Float)this.f_19804_.m_135370_(ATTACK_CHARGE)).floatValue();
    }

    public boolean isShooting() {
        return (Boolean)this.f_19804_.m_135370_(SHOOTING);
    }

    public void setShooting(boolean shooting) {
        this.f_19804_.m_135381_(SHOOTING, (Object)shooting);
    }

    @Override
    public void setPossessedByLicowitchId(int entityId) {
        this.f_19804_.m_135381_(POSSESSOR_LICOWITCH_ID, (Object)entityId);
    }

    @Override
    public int getPossessedByLicowitchId() {
        return (Integer)this.f_19804_.m_135370_(POSSESSOR_LICOWITCH_ID);
    }

    public boolean m_6779_(LivingEntity living) {
        LicowitchEntity licowitch;
        if (this.getPossessedByLicowitchId() != -1 && (licowitch = this.getPossessingLicowitch(this.m_9236_())) != null && licowitch.isFriendlyFire(living)) {
            return false;
        }
        return super.m_6779_(living);
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(CHARGED);
    }

    public void setCharged(boolean explode) {
        this.f_19804_.m_135381_(CHARGED, (Object)explode);
    }

    public float getExplodeProgress(float partialTick) {
        return (this.prevExplodeProgress + (this.explodeProgress - this.prevExplodeProgress) * partialTick) * 0.05f;
    }

    public float getShootProgress(float partialTick) {
        return (this.prevShootProgress + (this.shootProgress - this.prevShootProgress) * partialTick) * 0.2f;
    }

    public boolean canShootGumball() {
        return this.getGumballsLeft() > 0 && this.dialRot >= 450.0f && this.getAttackCharge() == 1.0f;
    }

    public void shootGumball(LivingEntity target) {
        Vec3 spawnGumballFrom = new Vec3(0.0, (double)0.3f, (double)0.4f).m_82524_(-this.f_20883_ * ((float)Math.PI / 180)).m_82549_(this.m_20182_());
        int shotCount = this.isCharged() ? 3 : 1;
        this.m_216990_((SoundEvent)ACSoundRegistry.GUMBALL_LAUNCH.get());
        for (int i = 0; i < shotCount; ++i) {
            GumballEntity gumball = new GumballEntity(this.m_9236_(), (LivingEntity)this);
            gumball.m_146884_(spawnGumballFrom);
            Vec3 targetVec = new Vec3(target.m_20185_(), target.m_20227_(0.6), target.m_20189_());
            if (this.isCharged() && i != shotCount / 2) {
                Vec3 vec3 = new Vec3(i < shotCount / 2 ? 3.0 : -3.0, 0.0, 0.0).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
                targetVec = targetVec.m_82549_(vec3);
            }
            double d0 = targetVec.m_7096_() - spawnGumballFrom.f_82479_;
            double d1 = targetVec.m_7098_() - spawnGumballFrom.f_82480_;
            double d2 = targetVec.m_7094_() - spawnGumballFrom.f_82481_;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            gumball.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.2f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
            this.m_9236_().m_7967_((Entity)gumball);
            if (this.isCharged()) {
                gumball.setMaximumBounces(10);
                gumball.setDamage((float)this.m_21051_(Attributes.f_22281_).m_22135_() + 2.0f);
                continue;
            }
            gumball.setDamage((float)this.m_21051_(Attributes.f_22281_).m_22135_());
        }
        this.m_5496_(SoundEvents.f_11773_, 1.0f, this.m_217043_().m_188501_() * 0.4f + 0.8f);
        if (!this.isCharged() || this.f_19796_.m_188501_() < 0.33f) {
            this.setGumballsLeft(this.getGumballsLeft() - 1);
        }
        this.setAttackCharge(0.0f);
        this.setShooting(true);
        this.postShootTime = 5;
    }

    public double getDialRot(float partialTick) {
        return this.prevDialRot + (this.dialRot - this.prevDialRot) * partialTick;
    }

    public boolean hasLineOfSightToGumballHole(Entity entity) {
        if (entity.m_9236_() != this.m_9236_()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20186_() + (double)0.3f, this.m_20189_());
        Vec3 vec31 = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return this.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("Charged", this.isCharged());
        compoundTag.m_128405_("Gumballs", this.getGumballsLeft());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setCharged(compoundTag.m_128471_("Charged"));
        this.setGumballsLeft(compoundTag.m_128451_("Gumballs"));
    }

    protected void m_7472_(DamageSource damageSource, int experience, boolean idk) {
        super.m_7472_(damageSource, experience, idk);
        if (damageSource.m_7639_() instanceof CaniacEntity) {
            this.m_19998_((ItemLike)ACItemRegistry.MUSIC_DISC_TASTY_FRAGMENT.get());
        }
    }

    public boolean m_7090_() {
        return this.isCharged();
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != MobEffects.f_19612_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.GUMBEEPER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.GUMBEEPER_DEATH.get();
    }

    public class AttackGoal
    extends Goal {
        private int seeTime;
        private int strafingTime = -1;
        private boolean strafingClockwise;
        private boolean strafingBackwards;

        public AttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = GumbeeperEntity.this.m_5448_();
            return target != null && target.m_6084_();
        }

        public void m_8041_() {
            super.m_8041_();
            this.seeTime = 0;
            this.strafingTime = -1;
            GumbeeperEntity.this.setAttackCharge(0.0f);
            GumbeeperEntity.this.setExploding(false);
        }

        public void m_8037_() {
            LivingEntity target = GumbeeperEntity.this.m_5448_();
            boolean canRange = GumbeeperEntity.this.getGumballsLeft() > 0;
            double dist = GumbeeperEntity.this.m_20270_((Entity)target);
            if (!canRange) {
                if (dist < (double)(target.m_20205_() + 1.5f)) {
                    GumbeeperEntity.this.setExploding(true);
                } else {
                    GumbeeperEntity.this.m_21573_().m_5624_((Entity)target, 1.5);
                }
            } else if (dist < 16.0 && canRange && GumbeeperEntity.this.hasLineOfSightToGumballHole((Entity)target)) {
                GumbeeperEntity.this.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                GumbeeperEntity.this.m_21573_().m_5624_((Entity)target, canRange ? 1.0 : 1.5);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)GumbeeperEntity.this.m_217043_().m_188501_() < 0.3) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)GumbeeperEntity.this.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (dist > 12.0) {
                    this.strafingBackwards = false;
                } else if (dist < 5.0) {
                    this.strafingBackwards = true;
                }
                GumbeeperEntity.this.m_21566_().m_24988_(this.strafingBackwards ? -1.0f : 1.0f, this.strafingClockwise ? 0.5f : -0.5f);
                GumbeeperEntity.this.m_21391_((Entity)target, 30.0f, 30.0f);
            }
            if (canRange && GumbeeperEntity.this.hasLineOfSightToGumballHole((Entity)target)) {
                GumbeeperEntity.this.setAttackCharge(Math.min(1.0f, GumbeeperEntity.this.getAttackCharge() + (GumbeeperEntity.this.isCharged() ? 0.3f : 0.1f)));
                if (GumbeeperEntity.this.canShootGumball()) {
                    GumbeeperEntity.this.shootGumball(target);
                }
            }
        }
    }
}

