/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.HullbreakerModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.CustomBookEntityRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.HullbreakerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.entity.PartEntity;

public class HullbreakerRenderer
extends MobRenderer<HullbreakerEntity, HullbreakerModel>
implements CustomBookEntityRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/hullbreaker.png");
    private static final ResourceLocation TEXTURE_GLOW = new ResourceLocation("alexscaves:textures/entity/hullbreaker_glow.png");
    private boolean sepia;

    public HullbreakerRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new HullbreakerModel(), 2.25f);
        this.m_115326_(new LayerGlow());
    }

    public void render(HullbreakerEntity entity, float f1, float partialTicks, PoseStack poseStack, MultiBufferSource source, int light) {
        ((HullbreakerModel)this.f_115290_).straighten = this.sepia;
        super.m_7392_((Mob)entity, f1, partialTicks, poseStack, source, light);
    }

    @Nullable
    protected RenderType getRenderType(HullbreakerEntity mob, boolean normal, boolean translucent, boolean outline) {
        ResourceLocation resourcelocation = this.getTextureLocation(mob);
        if (translucent) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (normal) {
            return this.sepia ? ACRenderTypes.getBookWidget(resourcelocation, true) : RenderType.m_110473_((ResourceLocation)resourcelocation);
        }
        return outline ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    protected void scale(HullbreakerEntity mob, PoseStack matrixStackIn, float partialTicks) {
    }

    public ResourceLocation getTextureLocation(HullbreakerEntity entity) {
        return TEXTURE;
    }

    public boolean shouldRender(HullbreakerEntity entity, Frustum camera, double x, double y, double z) {
        if (super.m_5523_((Mob)entity, camera, x, y, z)) {
            return true;
        }
        for (PartEntity<?> part : entity.getParts()) {
            if (!camera.m_113029_(part.m_6921_())) continue;
            return true;
        }
        return false;
    }

    protected float getFlipDegrees(HullbreakerEntity hullbreakerEntity) {
        return 0.0f;
    }

    @Override
    public void setSepiaFlag(boolean sepiaFlag) {
        this.sepia = sepiaFlag;
    }

    class LayerGlow
    extends RenderLayer<HullbreakerEntity, HullbreakerModel> {
        public LayerGlow() {
            super((RenderLayerParent)HullbreakerRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, HullbreakerEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE_GLOW));
            float alpha = (float)((Math.sin(entitylivingbaseIn.getPulseAmount(partialTicks)) + 1.0) * 0.5);
            ((HullbreakerModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, alpha);
        }
    }
}

