/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.BaseProperties;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;

public class RelatedUnit
implements IRelatedUnit {
    private final UnitConfig config;
    private final UnitId id;

    public RelatedUnit(UnitConfig config, UnitId id) {
        this.config = config;
        this.id = UnitConfig.getUnitId(config, this.getClassCategory(), "id", id, "Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper).\n");
        this.saveConfig();
    }

    @Override
    public UnitConfig getConfig() {
        return this.config;
    }

    @Override
    public UnitId getRelatedId() {
        return this.id;
    }

    public static class Properties<T extends Properties<T>>
    extends BaseProperties<T> {
        public UnitId id = UnitId.EMPTY;

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public static Properties<?> of() {
            return new Properties<Properties>(Properties.class);
        }

        public T id(UnitId id) {
            this.id = id;
            return (T)((Properties)this.self);
        }

        public T id(String id) {
            return this.id(UnitId.from(id));
        }

        public T enumId(String metadata) {
            return this.id(UnitId.EMPTY.withMetaData(metadata));
        }

        public T metadata(String metadata) {
            return this.id(this.id.withMetaData(metadata));
        }

        public T metaAll() {
            return this.id(this.id.withMetaAll());
        }

        public T emptyToEnumId(Enum<?> e, boolean metaAll) {
            if (this.id.isEmpty()) {
                String metadata = metaAll && !this.id.hasMetaData() ? "*" : this.id.getMetaData();
                return this.id(UnitId.from(e, metadata));
            }
            return (T)((Properties)this.self);
        }
    }
}

