/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.network;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.data.INetSerializable;
import com.endertech.minecraft.forge.math.Vect3d;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public abstract class ForgeNetMsg<MSG extends ForgeNetMsg<MSG>> {
    private static final Map<Class<?>, FieldHandler<?>> fieldHandlers = new HashMap();
    private static final Map<Class<?>, Field[]> fieldCache = new HashMap();

    public void encode(MSG msg, FriendlyByteBuf buf) {
        ((ForgeNetMsg)msg).encodeTo(buf);
    }

    public MSG decode(FriendlyByteBuf buf) {
        MSG msg = this.create();
        ((ForgeNetMsg)msg).decodeFrom(buf);
        return msg;
    }

    public abstract MSG create();

    public abstract void handle(Level var1, Player var2);

    public void handle(MSG msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            Player player = this.getPlayer(ctx);
            if (player != null) {
                msg.handle(player.m_9236_(), player);
            }
        });
        ctx.setPacketHandled(true);
    }

    protected final void decodeFrom(FriendlyByteBuf buf) {
        try {
            Field[] classFields;
            for (Field field : classFields = ForgeNetMsg.getClassFields(this.getClass())) {
                if (!this.acceptField(field)) continue;
                this.readField(field, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at reading packet " + this, e);
        }
    }

    protected final void encodeTo(FriendlyByteBuf buf) {
        try {
            Field[] classFields;
            for (Field field : classFields = ForgeNetMsg.getClassFields(this.getClass())) {
                if (!this.acceptField(field)) continue;
                this.writeField(field, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at writing packet " + this, e);
        }
    }

    private static Field[] getClassFields(Class<?> clazz) {
        Field[] fields = fieldCache.get(clazz);
        if (fields == null) {
            fields = clazz.getFields();
            Arrays.sort(fields, Comparator.comparing(Field::getName));
            fieldCache.put(clazz, fields);
        }
        return fields;
    }

    private void writeField(Field field, FriendlyByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        Object value = field.get(this);
        if (INetSerializable.class.isAssignableFrom(type)) {
            ((INetSerializable)value).writeTo(buf);
        } else if (type.isEnum()) {
            int ordinal = ((Enum)value).ordinal();
            buf.writeInt(ordinal);
        } else {
            FieldHandler<?> handler = ForgeNetMsg.getFieldHandler(type);
            handler.writer.write(value, buf);
        }
    }

    private void readField(Field field, FriendlyByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        Object value = field.get(this);
        if (INetSerializable.class.isAssignableFrom(type)) {
            value = ((INetSerializable)value).readFrom(buf);
        } else if (type.isEnum()) {
            int ordinal = buf.readInt();
            value = type.getEnumConstants()[ordinal];
        } else {
            FieldHandler<?> handler = ForgeNetMsg.getFieldHandler(type);
            value = handler.reader.read(buf);
        }
        field.set(this, value);
    }

    private static FieldHandler<?> getFieldHandler(Class<?> clazz) {
        FieldHandler<?> handler = fieldHandlers.get(clazz);
        if (handler == null) {
            throw new RuntimeException("No R/W handler for  " + clazz);
        }
        return handler;
    }

    public static <T> void addFieldHandler(Class<T> type, IReader<T> reader, IWriter<T> writer) {
        fieldHandlers.put(type, new FieldHandler<T>(reader, writer));
    }

    private boolean acceptField(Field field) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        int mods = field.getModifiers();
        if (Modifier.isFinal(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods)) {
            return false;
        }
        if (INetSerializable.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.isEnum()) {
            return true;
        }
        return fieldHandlers.containsKey(type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Nullable
    public Player getPlayer(NetworkEvent.Context ctx) {
        return this.getSide(ctx).isClient() ? this.getClientPlayer() : ctx.getSender();
    }

    public LogicalSide getSide(NetworkEvent.Context ctx) {
        return ctx.getDirection().getReceptionSide();
    }

    static {
        ForgeNetMsg.addFieldHandler(Byte.TYPE, FriendlyByteBuf::readByte, (value, buf) -> buf.writeByte((int)value.byteValue()));
        ForgeNetMsg.addFieldHandler(Short.TYPE, FriendlyByteBuf::readShort, (value, buf) -> buf.writeShort((int)value.shortValue()));
        ForgeNetMsg.addFieldHandler(Integer.TYPE, FriendlyByteBuf::readInt, (value, buf) -> buf.writeInt(value.intValue()));
        ForgeNetMsg.addFieldHandler(Long.TYPE, FriendlyByteBuf::readLong, (value, buf) -> buf.writeLong(value.longValue()));
        ForgeNetMsg.addFieldHandler(Float.TYPE, FriendlyByteBuf::readFloat, (value, buf) -> buf.writeFloat(value.floatValue()));
        ForgeNetMsg.addFieldHandler(Double.TYPE, FriendlyByteBuf::readDouble, (value, buf) -> buf.writeDouble(value.doubleValue()));
        ForgeNetMsg.addFieldHandler(Boolean.TYPE, FriendlyByteBuf::readBoolean, (value, buf) -> buf.writeBoolean(value.booleanValue()));
        ForgeNetMsg.addFieldHandler(Character.TYPE, FriendlyByteBuf::readChar, (value, buf) -> buf.writeChar((int)value.charValue()));
        ForgeNetMsg.addFieldHandler(String.class, FriendlyByteBuf::m_130277_, (string, buf) -> buf.m_130070_(string));
        ForgeNetMsg.addFieldHandler(CompoundTag.class, FriendlyByteBuf::m_130260_, (compound, buf) -> buf.m_130079_(compound));
        ForgeNetMsg.addFieldHandler(ItemStack.class, FriendlyByteBuf::m_130267_, (stack, buf) -> buf.m_130055_(stack));
        ForgeNetMsg.addFieldHandler(BlockPos.class, FriendlyByteBuf::m_130135_, (pos, buf) -> buf.m_130064_(pos));
        ForgeNetMsg.addFieldHandler(Vect3d.class, Vect3d::readFromByteBuf, Vect3d::writeToByteBuf);
        ForgeNetMsg.addFieldHandler(BlockState.class, buf -> Block.m_49803_((int)buf.readInt()), (state, buf) -> buf.writeInt(Block.m_49956_((BlockState)state)));
        ForgeNetMsg.addFieldHandler(ColorARGB.class, buf -> ColorARGB.from(buf.readInt()), (color, buf) -> buf.writeInt(color.getARGB()));
        ForgeNetMsg.addFieldHandler(Enum.class, null, (value, buf) -> buf.writeInt(value.ordinal()));
    }

    private static class FieldHandler<T> {
        public final IReader<T> reader;
        public final IWriter<T> writer;

        public FieldHandler(IReader<T> reader, IWriter<T> writer) {
            this.reader = reader;
            this.writer = writer;
        }
    }

    public static interface IWriter<T> {
        public void write(T var1, FriendlyByteBuf var2);
    }

    public static interface IReader<T> {
        public T read(FriendlyByteBuf var1);
    }
}

