/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CommonString {
    public static final String EMPTY = "";

    public static String capitalizeFirstChar(String string) {
        if ((string = String.valueOf(string)) != null && string.length() > 0) {
            String firstChar = string.substring(0, 1).toUpperCase(Locale.ROOT);
            return firstChar + string.substring(1);
        }
        return string;
    }

    public static String decapitalizeFirstChar(String string) {
        if ((string = String.valueOf(string)) != null && string.length() > 0) {
            String firstChar = string.substring(0, 1).toLowerCase(Locale.ROOT);
            return firstChar + string.substring(1);
        }
        return string;
    }

    public static String getRandomChar(String string) {
        return CommonString.getRandomChar(string, CommonMath.RANDOM);
    }

    public static String getRandomChar(String string, Random random) {
        if (string.isEmpty()) {
            return EMPTY;
        }
        int index = CommonMath.Random.between(0, string.length() - 1, random);
        return string.substring(index, index + 1);
    }

    public static String replaceFirst(String string, String target, String replacement) {
        return Pattern.compile(target, 16).matcher(string).replaceFirst(Matcher.quoteReplacement(replacement));
    }

    public static String replaceRandom(String string, String target, String replacement) {
        return CommonString.replaceRandom(string, target, replacement, CommonMath.RANDOM);
    }

    public static String replaceRandom(String string, String target, String replacement, Random random) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int index = -1;
        while (index < string.length() && (index = string.indexOf(target, index + 1)) >= 0) {
            indexes.add(index);
        }
        index = CommonCollect.getRandomElementFrom(indexes, random).orElse(-1);
        if (index >= 0) {
            return string.substring(0, index) + replacement + string.substring(index + target.length());
        }
        return string;
    }

    public static String quoted(String string) {
        return "'" + string + "'";
    }

    public static String doubleQuoted(String string) {
        return "\"" + string + "\"";
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean allCharsAreDigits(String string) {
        if (CommonString.isNullOrEmpty(string)) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static class Joiner {
        protected final String delimiter;

        public Joiner(String delimiter) {
            this.delimiter = delimiter;
        }

        public static Joiner with(String delimiter) {
            return new Joiner(delimiter);
        }

        public String join(String ... strings) {
            StringJoiner joiner = new StringJoiner(this.delimiter);
            for (String str : strings) {
                if (str.isEmpty()) continue;
                joiner.add(str);
            }
            return joiner.toString();
        }

        public String getDelimiter() {
            return this.delimiter;
        }
    }
}

