/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.api.EnumSortType;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.CapabilityConnectable;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class TileConnectable
extends BlockEntity {
    private final CapabilityConnectable connectable = new CapabilityConnectable();

    public TileConnectable(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public EnumSortType getSort() {
        return EnumSortType.NAME;
    }

    public boolean isDownwards() {
        return false;
    }

    public void m_6596_() {
        super.m_6596_();
        this.connectable.setPos(new DimPos(this.f_58857_, this.f_58858_));
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("connectable")) {
            this.connectable.deserializeNBT(compound.m_128469_("connectable"));
        }
        super.m_142466_(compound);
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("connectable", (Tag)this.connectable.serializeNBT());
        super.m_183515_(compound);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = new CompoundTag();
        this.m_183515_(updateTag);
        return updateTag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (StorageNetworkMod.CONFIG.doReloadOnChunk() && this.connectable != null && this.connectable.getMainPos() != null) {
            try {
                TileMain maybe = UtilTileEntity.getTileMainForConnectable(this.connectable);
                if (maybe != null) {
                    maybe.getNetwork().setShouldRefresh();
                }
            }
            catch (Exception e) {
                StorageNetworkMod.LOGGER.info("Error on chunk unload " + e);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == StorageNetworkCapabilities.CONNECTABLE_CAPABILITY) {
            LazyOptional cap = LazyOptional.of(() -> this.connectable);
            return cap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public DimPos getMain() {
        if (this.connectable == null) {
            return null;
        }
        return this.connectable.getMainPos();
    }
}

