/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.compat.diagonalfences;

import com.google.common.collect.BiMap;
import fuzs.diagonalblocks.api.v2.DiagonalBlockType;
import fuzs.diagonalblocks.api.v2.impl.DiagonalBlockTypeImpl;
import fuzs.diagonalblocks.api.v2.impl.DiagonalFenceBlock;
import fuzs.diagonalfences.DiagonalFences;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.CoreModule;
import snownee.snow.SnowRealMagic;
import snownee.snow.block.SnowFenceBlock;
import snownee.snow.block.SnowVariant;
import snownee.snow.compat.diagonalfences.SnowDiagonalFenceBlock;
import snownee.snow.convert.CoveredBlockConverter;

@KiwiModule(value="diagonalfences", dependencies="diagonalfences")
@NotNullByDefault
public class DiagonalFencesCompat
extends AbstractModule {
    public static final String ID = "diagonalfences";
    public static final DiagonalBlockType TYPE = new DiagonalBlockTypeImpl("snowfences", SnowFenceBlock.class, SnowDiagonalFenceBlock::new, new Property[]{CrossCollisionBlock.NORTH, CrossCollisionBlock.EAST, CrossCollisionBlock.WEST, CrossCollisionBlock.SOUTH, CrossCollisionBlock.WATERLOGGED, SnowVariant.OPTIONAL_LAYERS}){

        public ResourceLocation id(String path) {
            return DiagonalFences.id((String)path);
        }
    };

    public static void init() {
        DiagonalBlockType.register((DiagonalBlockType)TYPE);
    }

    public static BiMap<Block, Block> getBlockConversions() {
        return TYPE.getBlockConversions();
    }

    protected void postInit(PostInitEvent event) {
        event.enqueueWork(() -> CoreModule.CONVERTERS.converters.putBefore(SnowRealMagic.id("fence"), ResourceLocation.fromNamespaceAndPath((String)ID, (String)"fence"), new CoveredBlockConverter(this, DiagonalFenceBlock.class, Blocks.AIR.defaultBlockState()){

            @Override
            public boolean accept(BlockState blockState) {
                return TYPE.getBlockConversions().containsKey((Object)this.normalFenceOf(blockState)) && super.accept(blockState);
            }

            @Override
            public BlockState result(BlockState blockState) {
                Block block = this.normalFenceOf(blockState);
                return ((Block)TYPE.getBlockConversions().getOrDefault((Object)block, (Object)block)).defaultBlockState();
            }

            private Block normalFenceOf(BlockState blockState) {
                return blockState.getSoundType() == SoundType.WOOD || blockState.is(BlockTags.WOODEN_FENCES) ? (Block)CoreModule.FENCE.get() : (Block)CoreModule.FENCE2.get();
            }
        }));
    }
}

