/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.CoreModule;
import snownee.snow.Hooks;
import snownee.snow.block.SnowSlabBlock;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;

@NotNullByDefault
public class SnowCoveredBlockEntity
extends SnowBlockEntity {
    public SnowCoveredBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)CoreModule.TEXTURE_TILE.get(), pos, blockState);
        this.options.renderOverlay = blockState.getBlock().getClass() == SnowSlabBlock.class;
    }

    @Override
    public boolean setContainedState(BlockState state, boolean update) {
        return super.setContainedState(Hooks.copyProperties(this.getBlockState(), state), update);
    }

    @Override
    public void saveContainedState(CompoundTag data, boolean network) {
        data.putString("Block", BuiltInRegistries.BLOCK.getKey((Object)this.getContainedState().getBlock()).toString());
        if (this.options.renderOverlay) {
            data.putBoolean("RO", true);
        }
    }

    public void setBlockState(BlockState blockState) {
        SnowVariant snowVariant;
        Block block;
        super.setBlockState(blockState);
        this.setContainedState(this.containedState, false);
        if (this.options.renderOverlay && this.level != null && (block = blockState.getBlock()) instanceof SnowVariant && !(snowVariant = (SnowVariant)block).srm$canRenderOverlay(blockState)) {
            this.options.renderOverlay = false;
        }
    }

    public void refresh() {
        super.refresh();
        if (this.level != null && this.level.isClientSide) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 11);
        }
    }
}

