/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.block.WaterLoggableSnowVariant;
import snownee.snow.block.entity.SnowCoveredBlockEntity;
import snownee.snow.util.CommonProxy;

@NotNullByDefault
public class SnowSlabBlock
extends Block
implements WaterLoggableSnowVariant {
    protected static final VoxelShape BOTTOM_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape BOTTOM_RENDER_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public SnowSlabBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        Item item;
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof SnowCoveredBlockEntity)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        SnowCoveredBlockEntity blockEntity2 = (SnowCoveredBlockEntity)blockEntity;
        if (blockHitResult.getDirection() == Direction.UP && blockEntity2.getContainedState().getBlock().asItem() == itemStack.getItem() && itemStack.is(ItemTags.SLABS) && (item = itemStack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            blockState = (BlockState)blockItem.getBlock().defaultBlockState().trySetValue((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE);
            if (!level.isClientSide) {
                level.setBlockAndUpdate(blockPos, blockState);
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockPos, itemStack);
            }
            SoundType soundtype = blockState.getSoundType();
            level.playSound(player, blockPos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BOTTOM_RENDER_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return BOTTOM_SHAPE;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (CommonProxy.shouldMeltInGeneral((Level)worldIn, pos)) {
            worldIn.setBlockAndUpdate(pos, this.srm$getRaw(state, (BlockGetter)worldIn, pos));
        }
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    @Override
    public BlockState srm$getSnowState(BlockState state, BlockGetter level, BlockPos pos) {
        return Blocks.SNOW.defaultBlockState();
    }

    @Override
    public double srm$renderLayerOffset(BlockState blockState) {
        return 0.5;
    }
}

