/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.gui.screen;

import com.teammetallurgy.aquaculture.inventory.container.TackleBoxContainer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TackleBoxScreen
extends AbstractContainerScreen<TackleBoxContainer> {
    private static final ResourceLocation TACKLE_BOX_GUI = ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"textures/gui/container/tackle_box.png");

    public TackleBoxScreen(TackleBoxContainer tackleBoxContainer, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)tackleBoxContainer, playerInventory, title);
        this.imageHeight = 172;
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 100, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 4, 0x404040, false);
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TACKLE_BOX_GUI, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((TackleBoxContainer)this.menu).slotHook != null && ((TackleBoxContainer)this.menu).slotHook.isActive()) {
            if (((TackleBoxContainer)this.menu).slotHook.hasItem()) {
                this.renderEmptySlot(TACKLE_BOX_GUI, x + 105, y + 43, guiGraphics);
            } else {
                guiGraphics.blit(TACKLE_BOX_GUI, x + 105, y + 43, 176, 0, 18, 18);
            }
            if (((TackleBoxContainer)this.menu).slotBait.hasItem()) {
                this.renderEmptySlot(TACKLE_BOX_GUI, x + 128, y + 43, guiGraphics);
            } else {
                guiGraphics.blit(TACKLE_BOX_GUI, x + 128, y + 43, 176, 18, 18, 18);
            }
            if (((TackleBoxContainer)this.menu).slotLine.hasItem()) {
                this.renderEmptySlot(TACKLE_BOX_GUI, x + 105, y + 66, guiGraphics);
            } else {
                guiGraphics.blit(TACKLE_BOX_GUI, x + 105, y + 66, 176, 36, 18, 18);
            }
            if (((TackleBoxContainer)this.menu).slotBobber.hasItem()) {
                this.renderEmptySlot(TACKLE_BOX_GUI, x + 128, y + 66, guiGraphics);
            } else {
                guiGraphics.blit(TACKLE_BOX_GUI, x + 128, y + 66, 176, 54, 18, 18);
            }
        }
    }

    private void renderEmptySlot(ResourceLocation resourceLocation, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.blit(resourceLocation, x, y, 7, 7, 18, 18);
    }
}

