/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.villainoushordemanager.testcommands;

import com.cartoonishvillain.villainoushordemanager.VillainousHordeManager;
import com.cartoonishvillain.villainoushordemanager.data.json.JsonHordeData;
import com.cartoonishvillain.villainoushordemanager.data.json.JsonMobData;
import com.cartoonishvillain.villainoushordemanager.data.json.JsonWaveData;
import com.cartoonishvillain.villainoushordemanager.hordedata.EntityTypeHordeData;
import com.cartoonishvillain.villainoushordemanager.hordes.JsonHorde;
import com.cartoonishvillain.villainoushordemanager.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;

public class EntityJsonHordeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"hordeManager").then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(cs -> cs.hasPermission(2))).executes(context -> EntityJsonHordeCommand.reloadHorde((CommandSourceStack)context.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"hordeManager").then(Commands.literal((String)"startJsonHorde").then(Commands.argument((String)"hordeName", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument((String)"anchorplayer", (ArgumentType)EntityArgument.player()).requires(cs -> cs.hasPermission(2))).executes(context -> EntityJsonHordeCommand.startHorde((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"hordeName"), EntityArgument.getPlayer((CommandContext)context, (String)"anchorplayer")))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"hordeManager").then(Commands.literal((String)"startJsonHorde").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"hordeName", (ArgumentType)StringArgumentType.string()).requires(cs -> cs.hasPermission(2))).requires(CommandSourceStack::isPlayer)).executes(context -> EntityJsonHordeCommand.startHorde((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"hordeName"))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"hordeManager").then(((LiteralArgumentBuilder)Commands.literal((String)"stopJsonHorde").requires(cs -> cs.hasPermission(2))).executes(context -> EntityJsonHordeCommand.stopHorde((CommandSourceStack)context.getSource()))));
    }

    private static int startHorde(CommandSourceStack sourceStack, String hordeName) {
        if (!(sourceStack.getLevel().isClientSide || VillainousHordeManager.jsonHorde != null && VillainousHordeManager.jsonHorde.getHordeActive().booleanValue())) {
            if (VillainousHordeManager.gsonHordes.containsKey(hordeName)) {
                JsonHordeData jsonHordeData = VillainousHordeManager.gsonHordes.get(hordeName);
                HashMap waveHordeMobData = new HashMap();
                for (JsonWaveData wave : jsonHordeData.getWaves()) {
                    ArrayList hordeMobData = new ArrayList();
                    for (JsonMobData data : wave.getMobData()) {
                        Optional type = EntityType.byString((String)data.getMobID());
                        if (type.isEmpty()) {
                            Services.PLATFORM.getLOGGER().warn("VillainousHordeManager - Failed to load json mob of type: " + data.getMobID());
                            return 0;
                        }
                        hordeMobData.add(new EntityTypeHordeData(data.getGoalPriority(), data.getGoalMovementSpeed().floatValue(), data.getSpawnWeight(), (EntityType)type.get(), data.getNbtData()));
                    }
                    waveHordeMobData.put(wave.getWaveName(), hordeMobData);
                }
                VillainousHordeManager.jsonHorde = new JsonHorde(sourceStack.getServer(), jsonHordeData.getWaves(), jsonHordeData.getAdvancementForStartingHorde(), jsonHordeData.getAdvancementForWinningAgainstHorde(), jsonHordeData.shouldClearWinningAdvancement(), jsonHordeData.getHordeName());
                VillainousHordeManager.jsonHorde.SetUpHorde(Objects.requireNonNull(sourceStack.getPlayer()));
            } else {
                StringBuilder builder = new StringBuilder();
                for (String key : VillainousHordeManager.gsonHordes.keySet()) {
                    builder.append(key).append(" ");
                }
                sourceStack.sendFailure((Component)Component.literal((String)("Horde not found! Available hordes: " + String.valueOf(builder))));
            }
        }
        return 0;
    }

    private static int startHorde(CommandSourceStack sourceStack, String hordeName, ServerPlayer player) {
        if (!(sourceStack.getLevel().isClientSide || VillainousHordeManager.jsonHorde != null && VillainousHordeManager.jsonHorde.getHordeActive().booleanValue())) {
            if (VillainousHordeManager.gsonHordes.containsKey(hordeName)) {
                JsonHordeData jsonHordeData = VillainousHordeManager.gsonHordes.get(hordeName);
                HashMap waveHordeMobData = new HashMap();
                for (JsonWaveData wave : jsonHordeData.getWaves()) {
                    ArrayList hordeMobData = new ArrayList();
                    for (JsonMobData data : wave.getMobData()) {
                        Optional type = EntityType.byString((String)data.getMobID());
                        if (type.isEmpty()) {
                            Services.PLATFORM.getLOGGER().warn("VillainousHordeManager - Failed to load json mob of type: " + data.getMobID());
                            return 0;
                        }
                        hordeMobData.add(new EntityTypeHordeData(data.getGoalPriority(), data.getGoalMovementSpeed().floatValue(), data.getSpawnWeight(), (EntityType)type.get(), data.getNbtData()));
                    }
                    waveHordeMobData.put(wave.getWaveName(), hordeMobData);
                }
                VillainousHordeManager.jsonHorde = new JsonHorde(sourceStack.getServer(), jsonHordeData.getWaves(), jsonHordeData.getAdvancementForStartingHorde(), jsonHordeData.getAdvancementForWinningAgainstHorde(), jsonHordeData.shouldClearWinningAdvancement(), jsonHordeData.getHordeName());
                VillainousHordeManager.jsonHorde.SetUpHorde(Objects.requireNonNull(player));
            } else {
                StringBuilder builder = new StringBuilder();
                for (String key : VillainousHordeManager.gsonHordes.keySet()) {
                    builder.append(key).append(" ");
                }
                sourceStack.sendFailure((Component)Component.literal((String)("Horde not found! Available hordes: " + String.valueOf(builder))));
            }
        }
        return 0;
    }

    private static int stopHorde(CommandSourceStack sourceStack) {
        if (!sourceStack.getLevel().isClientSide && VillainousHordeManager.jsonHorde != null && VillainousHordeManager.jsonHorde.getHordeActive().booleanValue()) {
            VillainousHordeManager.jsonHorde.Stop(JsonHorde.HordeStopReasons.DEFEAT);
        }
        return 0;
    }

    private static int reloadHorde(CommandSourceStack sourceStack) {
        VillainousHordeManager.gsonHordes.clear();
        int failures = VillainousHordeManager.loadHordes();
        if (failures == 0) {
            sourceStack.sendSuccess(() -> Component.translatable((String)"villainoushordemanager.reload.success"), true);
        } else if (failures == -1) {
            sourceStack.sendFailure((Component)Component.translatable((String)"villainoushordemanager.reload.failure"));
        } else {
            sourceStack.sendSuccess(() -> Component.translatable((String)"villainoushordemanager.reload.success.partial", (Object[])new Object[]{failures}), true);
        }
        return 0;
    }
}

