/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.villainoushordemanager.hordes;

import com.cartoonishvillain.villainoushordemanager.JsonHordeMovementGoal;
import com.cartoonishvillain.villainoushordemanager.TypeHordeMovementGoal;
import com.cartoonishvillain.villainoushordemanager.data.json.JsonMobData;
import com.cartoonishvillain.villainoushordemanager.data.json.JsonWaveData;
import com.cartoonishvillain.villainoushordemanager.hordedata.EntityTypeHordeData;
import com.cartoonishvillain.villainoushordemanager.mixin.LivingGoalAccessor;
import com.cartoonishvillain.villainoushordemanager.platform.Services;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class JsonHorde {
    protected ServerLevel world;
    protected BlockPos center;
    protected Boolean hordeActive = false;
    protected ArrayList<JsonWaveData> waves;
    protected MinecraftServer server;
    protected int Alive = 0;
    protected int initAlive = 0;
    protected int Active = 0;
    protected int allowedActive;
    protected int updateCenter = 0;
    protected ServerPlayer hordeAnchorPlayer;
    protected ArrayList<ServerPlayer> players = new ArrayList();
    protected ArrayList<LivingEntity> activeHordeMembers = new ArrayList();
    protected ServerBossEvent bossInfo;
    protected ServerBossEvent oldBossInfo;
    protected ArrayList<EntityTypeHordeData<?>> hordeData = new ArrayList();
    protected String hordeName;
    protected Boolean despawnLeftBehindMembers;
    protected int easyKillCount;
    protected int normalKillCount;
    protected int hardKillCount;
    protected ArrayList<Integer> spawnWeights = new ArrayList();
    protected int hordeWaveNumber = 0;
    protected String advancementForStarting;
    protected String advancementForWinning;
    boolean shouldClearWinningAdvancement;
    protected ArrayList<JsonMobData> bossEntities = new ArrayList();
    protected ArrayList<JsonMobData> bossEntitiesTracked = new ArrayList();
    protected ArrayList<JsonMobData> bossEntitiesSpawned = new ArrayList();
    protected ServerBossEvent bossEventForBossEntities;
    protected ArrayList<LivingEntity> activeBossMembers = new ArrayList();
    protected boolean isSpawningBosses = false;
    protected boolean bossPhase = false;
    protected HashMap<PathfinderMob, JsonMobData> bossTracker = new HashMap();
    protected boolean shouldBossKeepSpawningHorde = false;

    public JsonHorde(MinecraftServer server, ArrayList<JsonWaveData> waves, String advancementForStarting, String advancementForWinning, boolean shouldClearWinningAdvancement, String hordeName) {
        this.server = server;
        this.waves = waves;
        this.hordeName = hordeName;
        this.advancementForStarting = advancementForStarting;
        this.advancementForWinning = advancementForWinning;
        this.shouldClearWinningAdvancement = shouldClearWinningAdvancement;
        this.getDataFromWave(waves.getFirst(), false);
    }

    private void getDataFromWave(JsonWaveData waveData, Boolean newWave) {
        this.easyKillCount = waveData.getKillsRequiredForEasy();
        this.normalKillCount = waveData.getKillsRequiredForNormal();
        this.hardKillCount = waveData.getKillsRequiredForHard();
        this.allowedActive = waveData.getMaximumActiveHordeMembers();
        BossEvent.BossBarColor bossColor = switch (waveData.getBossInfoColor().toLowerCase()) {
            case "green" -> BossEvent.BossBarColor.GREEN;
            case "blue" -> BossEvent.BossBarColor.BLUE;
            case "pink" -> BossEvent.BossBarColor.PINK;
            case "red" -> BossEvent.BossBarColor.RED;
            case "purple" -> BossEvent.BossBarColor.PURPLE;
            case "yellow" -> BossEvent.BossBarColor.YELLOW;
            default -> BossEvent.BossBarColor.WHITE;
        };
        BossEvent.BossBarColor bossbossColor = switch (waveData.getBossInfoColorWhenBossIsActive().toLowerCase()) {
            case "green" -> BossEvent.BossBarColor.GREEN;
            case "blue" -> BossEvent.BossBarColor.BLUE;
            case "pink" -> BossEvent.BossBarColor.PINK;
            case "red" -> BossEvent.BossBarColor.RED;
            case "purple" -> BossEvent.BossBarColor.PURPLE;
            case "yellow" -> BossEvent.BossBarColor.YELLOW;
            default -> BossEvent.BossBarColor.WHITE;
        };
        this.despawnLeftBehindMembers = waveData.isDespawnLeftBehindMembers();
        if (this.bossInfo != null) {
            this.oldBossInfo = this.bossInfo;
        }
        this.bossInfo = new ServerBossEvent((Component)Component.literal((String)waveData.getBossInfoText()), bossColor, BossEvent.BossBarOverlay.PROGRESS);
        ArrayList entityHordeDataList = new ArrayList();
        for (JsonMobData jsonMobData : waveData.getMobData()) {
            Optional type = EntityType.byString((String)jsonMobData.getMobID());
            if (type.isPresent()) {
                entityHordeDataList.add(new EntityTypeHordeData(jsonMobData.getGoalPriority(), jsonMobData.getGoalMovementSpeed().floatValue(), jsonMobData.getSpawnWeight(), (EntityType)type.get(), jsonMobData.getNbtData()));
                continue;
            }
            Services.PLATFORM.getLOGGER().warn("VillainousHordeManager - Failed to load json mob of type: " + jsonMobData.getMobID());
        }
        this.bossEntitiesTracked.clear();
        this.bossEntitiesSpawned.clear();
        this.bossEventForBossEntities = null;
        this.activeBossMembers.clear();
        this.isSpawningBosses = false;
        this.bossPhase = false;
        this.bossTracker.clear();
        this.shouldBossKeepSpawningHorde = false;
        this.bossEntities.addAll(waveData.getBossMobData());
        this.bossEntitiesTracked.addAll(this.bossEntities);
        this.bossEventForBossEntities = new ServerBossEvent((Component)Component.literal((String)waveData.getBossInfoTextWhenBossIsActive()), bossbossColor, BossEvent.BossBarOverlay.PROGRESS);
        this.shouldBossKeepSpawningHorde = waveData.shouldKeepSpawningEnemiesWhileBossIsActive();
        this.setHordeData(entityHordeDataList);
        this.spawnWeights = new ArrayList();
        for (EntityTypeHordeData entityTypeHordeData : this.hordeData) {
            this.spawnWeights.add(entityTypeHordeData.getSpawnWeight());
        }
        if (newWave.booleanValue()) {
            this.SetUpHorde(this.hordeAnchorPlayer);
        }
    }

    public void Stop(HordeStopReasons stopReason) {
        try {
            if (stopReason == HordeStopReasons.VICTORY && !this.advancementForWinning.isEmpty()) {
                this.awardAdvancement(this.bossInfo.getPlayers(), this.advancementForWinning);
            }
            if (stopReason == HordeStopReasons.VICTORY && !this.advancementForWinning.isEmpty() && this.shouldClearWinningAdvancement) {
                AdvancementHolder advancement = this.server.getAdvancements().get(ResourceLocation.parse((String)this.advancementForWinning));
                for (ServerPlayer player : this.bossInfo.getPlayers()) {
                    AdvancementProgress progress = player.getAdvancements().getOrStartProgress(advancement);
                    for (String s : progress.getCompletedCriteria()) {
                        player.getAdvancements().revoke(advancement, s);
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.bossInfo.setVisible(false);
        this.bossInfo.removeAllPlayers();
        this.hordeActive = false;
        this.Alive = 0;
        this.initAlive = 0;
        this.Active = 0;
        this.hordeAnchorPlayer = null;
        this.activeHordeMembers.clear();
        this.center = null;
        this.players.clear();
        this.bossEntitiesTracked.clear();
        this.bossEntitiesSpawned.clear();
        this.bossEventForBossEntities = null;
        this.activeBossMembers.clear();
        this.isSpawningBosses = false;
        this.bossPhase = false;
        this.bossTracker.clear();
        this.shouldBossKeepSpawningHorde = false;
        this.advancementForWinning = "";
        this.advancementForStarting = "";
        switch (stopReason.ordinal()) {
            case 0: {
                Services.PLATFORM.getLOGGER().info("Player Victory against " + this.hordeName);
                break;
            }
            case 1: {
                Services.PLATFORM.getLOGGER().info("Player Defeat against" + this.hordeName);
                break;
            }
            case 3: {
                Services.PLATFORM.getLOGGER().error(this.hordeName + " canceled! Could not locate spawn placement! (Entities are too big, or terrain is too noisy)");
                break;
            }
            case 2: {
                Services.PLATFORM.getLOGGER().info(this.hordeName + " canceled, server changed to peaceful!");
            }
        }
    }

    public Boolean getHordeActive() {
        return this.hordeActive;
    }

    public void SetUpHorde(ServerPlayer serverPlayer) {
        if (serverPlayer.level() instanceof ServerLevel) {
            this.world = (ServerLevel)serverPlayer.level();
            if (serverPlayer.level().dimension().equals(this.world.dimension())) {
                this.hordeAnchorPlayer = serverPlayer;
                switch (this.world.getDifficulty()) {
                    case EASY: {
                        this.setEasyDifficultyStats();
                        break;
                    }
                    case NORMAL: {
                        this.setNormalDifficultyStats();
                        break;
                    }
                    case HARD: {
                        this.setHardDifficultyStats();
                        break;
                    }
                    case PEACEFUL: {
                        return;
                    }
                }
                if (!this.hordeActive.booleanValue() && !this.advancementForStarting.isEmpty()) {
                    this.awardAdvancement(List.of(serverPlayer), this.advancementForStarting);
                }
                this.setActiveMemberCount();
                this.setCenterBlock(serverPlayer.blockPosition());
                this.hordeActive = true;
            }
        }
    }

    public void setActiveMemberCount() {
    }

    public void setEasyDifficultyStats() {
        this.Alive = this.easyKillCount;
        this.initAlive = this.easyKillCount;
    }

    public void setNormalDifficultyStats() {
        this.Alive = this.normalKillCount;
        this.initAlive = this.normalKillCount;
    }

    public void setHardDifficultyStats() {
        this.Alive = this.hardKillCount;
        this.initAlive = this.hardKillCount;
    }

    public void setCenterBlock(BlockPos centerPosition) {
        this.center = centerPosition;
    }

    protected boolean checkIfPlayerIsStillValid(ServerPlayer serverPlayer) {
        return serverPlayer.getHealth() != 0.0f && !serverPlayer.isRemoved();
    }

    protected void PeacefulCheck() {
        if (this.world.getDifficulty() == Difficulty.PEACEFUL) {
            this.Stop(HordeStopReasons.PEACEFUL);
        }
    }

    protected void updateCenter() {
        if (this.updateCenter == 0) {
            this.center = this.hordeAnchorPlayer.getOnPos();
            this.updateCenter = 100;
            this.updatePlayers();
            if (!this.bossPhase || this.shouldBossKeepSpawningHorde) {
                this.updateHorde();
            }
            if (this.bossPhase) {
                this.updateBosses();
            }
        } else {
            --this.updateCenter;
        }
    }

    public void tick() {
        if (this.hordeActive.booleanValue() && this.bossPhase) {
            if (this.isSpawningBosses || !this.bossEntitiesTracked.isEmpty()) {
                if (this.hordeAnchorPlayer.level().dimensionType().equals((Object)this.world.dimensionType()) && this.checkIfPlayerIsStillValid(this.hordeAnchorPlayer)) {
                    this.PeacefulCheck();
                    if (!this.hordeActive.booleanValue()) {
                        return;
                    }
                    if (this.oldBossInfo != null) {
                        this.oldBossInfo.setVisible(false);
                        for (ServerPlayer player : this.oldBossInfo.getPlayers()) {
                            this.bossInfo.addPlayer(player);
                        }
                        this.oldBossInfo.removeAllPlayers();
                        this.oldBossInfo = null;
                    }
                    this.bossInfo.setVisible(true);
                    if (this.bossEntitiesSpawned.size() < this.bossEntitiesTracked.size()) {
                        PathfinderMob mob = this.spawnBossMember(this.bossEntitiesTracked.get(this.bossEntitiesSpawned.size()));
                        if (mob != null) {
                            this.bossTracker.put(mob, this.bossEntitiesSpawned.getLast());
                        }
                    } else {
                        this.isSpawningBosses = false;
                    }
                    if (this.shouldBossKeepSpawningHorde) {
                        if (this.Active != this.activeHordeMembers.size()) {
                            this.Active = this.activeHordeMembers.size();
                        }
                        if (this.Active < this.allowedActive) {
                            this.spawnHordeMember();
                        }
                    }
                    this.updateCenter();
                } else {
                    this.updatePlayers();
                    if (this.players.isEmpty()) {
                        this.Stop(HordeStopReasons.DEFEAT);
                    } else {
                        this.bossInfo.removePlayer(this.hordeAnchorPlayer);
                        this.hordeAnchorPlayer = this.players.get(0);
                        this.players.remove(0);
                    }
                }
            } else {
                this.bossPhase = false;
                this.bossEntities.clear();
            }
        }
        if (this.hordeActive.booleanValue() && !this.bossPhase) {
            if (this.Alive > 0) {
                if (this.hordeAnchorPlayer.level().dimensionType().equals((Object)this.world.dimensionType()) && this.checkIfPlayerIsStillValid(this.hordeAnchorPlayer)) {
                    this.PeacefulCheck();
                    if (!this.hordeActive.booleanValue()) {
                        return;
                    }
                    if (this.Active != this.activeHordeMembers.size()) {
                        this.Active = this.activeHordeMembers.size();
                    }
                    if (this.oldBossInfo != null) {
                        this.oldBossInfo.setVisible(false);
                        for (ServerPlayer player : this.oldBossInfo.getPlayers()) {
                            this.bossInfo.addPlayer(player);
                        }
                        this.oldBossInfo.removeAllPlayers();
                        this.oldBossInfo = null;
                    }
                    this.bossInfo.setVisible(true);
                    if (this.Active < this.allowedActive) {
                        this.spawnHordeMember();
                    }
                    if (this.hordeActive.booleanValue()) {
                        this.updateCenter();
                        float aliveDivision = (float)this.Alive / (float)this.initAlive;
                        this.bossInfo.setProgress(Mth.clamp((float)aliveDivision, (float)0.0f, (float)1.0f));
                    }
                } else {
                    this.updatePlayers();
                    if (this.players.isEmpty()) {
                        this.Stop(HordeStopReasons.DEFEAT);
                    } else {
                        this.bossInfo.removePlayer(this.hordeAnchorPlayer);
                        this.hordeAnchorPlayer = this.players.get(0);
                        this.players.remove(0);
                    }
                }
            } else if (!this.bossEntitiesTracked.isEmpty()) {
                this.bossPhase = true;
                this.isSpawningBosses = true;
                this.oldBossInfo = this.bossInfo;
                this.bossInfo = this.bossEventForBossEntities;
            } else if (this.hordeWaveNumber >= this.waves.size() - 1) {
                this.Stop(HordeStopReasons.VICTORY);
            } else {
                ++this.hordeWaveNumber;
                this.getDataFromWave(this.waves.get(this.hordeWaveNumber), true);
            }
        }
    }

    protected void updatePlayers() {
        for (ServerPlayer serverPlayer : this.server.getPlayerList().getPlayers()) {
            if (this.hordeAnchorPlayer == serverPlayer) {
                this.bossInfo.addPlayer(serverPlayer);
                continue;
            }
            if (serverPlayer.level().dimensionType().equals((Object)this.world.dimensionType()) && this.checkIfPlayerIsStillValid(serverPlayer)) {
                double distance = Mth.sqrt((float)((float)serverPlayer.distanceToSqr((double)this.center.getX(), (double)this.center.getY(), (double)this.center.getZ())));
                if (distance < 64.0) {
                    if (this.players.contains(serverPlayer)) continue;
                    this.bossInfo.addPlayer(serverPlayer);
                    this.players.add(serverPlayer);
                    continue;
                }
                this.bossInfo.removePlayer(serverPlayer);
                this.players.remove(serverPlayer);
                continue;
            }
            this.bossInfo.removePlayer(serverPlayer);
            this.players.remove(serverPlayer);
        }
    }

    protected void updateHorde() {
        ArrayList<LivingEntity> removals = new ArrayList<LivingEntity>();
        ArrayList<LivingEntity> deleteMobs = new ArrayList<LivingEntity>();
        for (LivingEntity hordeMember : this.activeHordeMembers) {
            BlockPos hordeTarget;
            if (hordeMember.isDeadOrDying()) {
                removals.add(hordeMember);
                this.UnitDown();
            } else if (hordeMember.isRemoved()) {
                removals.add(hordeMember);
                this.UnitLost();
            }
            if (!(Mth.sqrt((float)((float)hordeMember.distanceToSqr((double)(hordeTarget = this.center).getX(), (double)hordeTarget.getY(), (double)hordeTarget.getZ()))) > 64.0f)) continue;
            JsonHorde.removeGoal((PathfinderMob)hordeMember);
            removals.add(hordeMember);
            if (this.despawnLeftBehindMembers.booleanValue()) {
                deleteMobs.add(hordeMember);
            }
            this.UnitLost();
        }
        for (LivingEntity removal : removals) {
            this.activeHordeMembers.remove(removal);
        }
        for (LivingEntity removal : deleteMobs) {
            removal.remove(Entity.RemovalReason.DISCARDED);
        }
        removals.clear();
    }

    private void updateBosses() {
        ArrayList<LivingEntity> removals = new ArrayList<LivingEntity>();
        ArrayList<LivingEntity> deleteMobs = new ArrayList<LivingEntity>();
        for (LivingEntity hordeMember : this.activeBossMembers) {
            BlockPos hordeTarget;
            if (hordeMember.isDeadOrDying()) {
                removals.add(hordeMember);
            } else if (hordeMember.isRemoved()) {
                deleteMobs.add(hordeMember);
            }
            if (!(Mth.sqrt((float)((float)hordeMember.distanceToSqr((double)(hordeTarget = this.center).getX(), (double)hordeTarget.getY(), (double)hordeTarget.getZ()))) > 64.0f)) continue;
            JsonHorde.removeGoal((PathfinderMob)hordeMember);
            if (!this.despawnLeftBehindMembers.booleanValue()) continue;
            deleteMobs.add(hordeMember);
        }
        for (LivingEntity removal : removals) {
            this.activeBossMembers.remove(removal);
            this.bossEntitiesTracked.remove(this.bossTracker.get((PathfinderMob)removal));
            this.bossTracker.remove((PathfinderMob)removal);
        }
        for (LivingEntity removal : deleteMobs) {
            this.bossEntitiesSpawned.remove(this.bossTracker.get((PathfinderMob)removal));
            this.bossEntitiesTracked.remove(this.bossTracker.get((PathfinderMob)removal));
            this.bossEntitiesTracked.add(this.bossTracker.get((PathfinderMob)removal));
            this.activeBossMembers.remove(removal);
            this.bossTracker.remove(removal);
            removal.remove(Entity.RemovalReason.DISCARDED);
        }
        deleteMobs.clear();
        removals.clear();
    }

    protected Optional<BlockPos> getValidSpawn(EntityType<?> type) {
        for (int i = 0; i < 3; ++i) {
            BlockPos blockPos = this.findRandomSpawnPos(20, type);
            if (blockPos == null) continue;
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    protected BlockPos findRandomSpawnPos(int loopvar, EntityType<?> type) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int a = 0; a < loopvar; ++a) {
            double DISTANCE = -1.0;
            int j = Integer.MAX_VALUE;
            int l = Integer.MAX_VALUE;
            while (!(DISTANCE > 450.0) || !(DISTANCE < 1250.0)) {
                j = this.randFinder(this.center.getX());
                l = this.randFinder(this.center.getZ());
                DISTANCE = this.center.distSqr((Vec3i)new BlockPos(j, this.center.getY(), l));
            }
            int k = this.findSafeYPosition(j, l, type, false);
            if (k == this.world.getMinBuildHeight() - 1) continue;
            blockPos.set(j, k, l);
            return blockPos;
        }
        double DISTANCE = -1.0;
        int j = Integer.MAX_VALUE;
        int l = Integer.MAX_VALUE;
        while (!(DISTANCE > 450.0) || !(DISTANCE < 1250.0)) {
            j = this.randFinder(this.center.getX());
            l = this.randFinder(this.center.getZ());
            DISTANCE = this.center.distSqr((Vec3i)new BlockPos(j, this.center.getY(), l));
        }
        int k = this.findSafeYPosition(j, l, type, true);
        if (k != this.world.getMinBuildHeight() - 1) {
            blockPos.set(j, k, l);
            return blockPos;
        }
        return null;
    }

    protected int findSafeYPosition(int xValue, int zValue, EntityType<?> entityType, boolean unfiltered) {
        SpawnPlacementType vexType;
        SpawnPlacementType spawnplacementtype;
        BlockState blockState;
        int baseYValue;
        int minHeight;
        int maxHeight;
        if (unfiltered) {
            maxHeight = this.world.getMaxBuildHeight() + 1;
            minHeight = this.world.getMinBuildHeight() + 1;
        } else {
            maxHeight = this.center.getY() + 25;
            minHeight = this.center.getY() - 25;
        }
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (baseYValue = this.center.getY(); baseYValue < maxHeight; ++baseYValue) {
            blockPos.set(xValue, baseYValue - 1, zValue);
            blockState = this.world.getBlockState((BlockPos)blockPos);
            spawnplacementtype = SpawnPlacements.getPlacementType(entityType);
            vexType = SpawnPlacements.getPlacementType((EntityType)EntityType.VEX);
            if (spawnplacementtype.getClass() == vexType.getClass()) {
                spawnplacementtype = SpawnPlacementTypes.ON_GROUND;
            }
            if (!spawnplacementtype.isSpawnPositionOk((LevelReader)this.world, (BlockPos)blockPos, entityType) || blockState.equals(Blocks.BEDROCK.defaultBlockState())) continue;
            return baseYValue;
        }
        for (baseYValue = this.center.getY(); baseYValue > minHeight; --baseYValue) {
            blockPos.set(xValue, baseYValue - 1, zValue);
            blockState = this.world.getBlockState((BlockPos)blockPos);
            spawnplacementtype = SpawnPlacements.getPlacementType(entityType);
            vexType = SpawnPlacements.getPlacementType((EntityType)EntityType.VEX);
            if (spawnplacementtype.getClass() == vexType.getClass()) {
                spawnplacementtype = SpawnPlacementTypes.ON_GROUND;
            }
            if (!spawnplacementtype.isSpawnPositionOk((LevelReader)this.world, (BlockPos)blockPos, entityType) || blockState.equals(Blocks.BEDROCK.defaultBlockState())) continue;
            return baseYValue;
        }
        return this.world.getMinBuildHeight() - 1;
    }

    protected int randFinder(int centercoord) {
        return centercoord + (this.world.random.nextInt(50) - 25);
    }

    public void SpawnUnit() {
        ++this.Active;
    }

    public void InviteUnit() {
        ++this.Active;
    }

    public void UnitDown() {
        --this.Active;
        --this.Alive;
    }

    public void UnitLost() {
        --this.Active;
    }

    protected void spawnHordeMember() {
        Object pathfinderMob;
        Optional<Object> hordeSpawn = Optional.empty();
        int combined = 0;
        for (Integer weight : this.spawnWeights) {
            combined += weight.intValue();
        }
        Random random = new Random();
        int rng = random.nextInt(combined);
        int selected = -1;
        int counter = 0;
        for (Integer weights : this.spawnWeights) {
            if (rng + 1 - weights <= 0) {
                selected = counter;
                break;
            }
            ++counter;
            rng -= weights.intValue();
        }
        EntityTypeHordeData<?> entrySelected = this.hordeData.get(selected);
        try {
            pathfinderMob = entrySelected.createInstance(this.world);
        }
        catch (ClassCastException e) {
            this.Stop(HordeStopReasons.SPAWN_ERROR);
            Services.PLATFORM.getLOGGER().error("Villainous Horde Manager - WARNING! One or more of the mobs in your JSON horde are not a descendant of PathfinderMob. Horde canceled due to this.");
            return;
        }
        int attempts = 0;
        while (hordeSpawn.isEmpty()) {
            hordeSpawn = this.getValidSpawn(entrySelected.getType());
            if (!hordeSpawn.isEmpty() || ++attempts < 20) continue;
            return;
        }
        if (pathfinderMob != null) {
            pathfinderMob.setPos((double)((BlockPos)hordeSpawn.get()).getX(), (double)((BlockPos)hordeSpawn.get()).getY(), (double)((BlockPos)hordeSpawn.get()).getZ());
            this.injectGoal((PathfinderMob)pathfinderMob, entrySelected, entrySelected.getGoalMovementSpeed());
            Services.PLATFORM.finalizeSpawn((PathfinderMob)pathfinderMob, this.world, pathfinderMob.level().getCurrentDifficultyAt(pathfinderMob.getOnPos()), MobSpawnType.EVENT, null);
            this.world.addFreshEntity(pathfinderMob);
            this.SpawnUnit();
            this.activeHordeMembers.add((LivingEntity)pathfinderMob);
        }
    }

    protected PathfinderMob spawnBossMember(JsonMobData entity) {
        Object pathfinderMob;
        Optional<Object> hordeSpawn = Optional.empty();
        Optional type = EntityType.byString((String)entity.getMobID());
        EntityTypeHordeData entrySelected = new EntityTypeHordeData(entity.getGoalPriority(), entity.getGoalMovementSpeed().floatValue(), entity.getSpawnWeight(), (EntityType)type.get(), entity.getNbtData());
        try {
            pathfinderMob = entrySelected.createInstance(this.world);
        }
        catch (ClassCastException e) {
            this.Stop(HordeStopReasons.SPAWN_ERROR);
            Services.PLATFORM.getLOGGER().error("Villainous Horde Manager - WARNING! One or more of the mobs in your JSON horde are not a descendant of PathfinderMob. Horde canceled due to this.");
            return null;
        }
        int attempts = 0;
        while (hordeSpawn.isEmpty()) {
            hordeSpawn = this.getValidSpawn(entrySelected.getType());
            if (!hordeSpawn.isEmpty() || ++attempts < 20) continue;
            return null;
        }
        if (pathfinderMob != null) {
            pathfinderMob.setPos((double)((BlockPos)hordeSpawn.get()).getX(), (double)((BlockPos)hordeSpawn.get()).getY(), (double)((BlockPos)hordeSpawn.get()).getZ());
            this.injectGoal((PathfinderMob)pathfinderMob, entrySelected, entrySelected.getGoalMovementSpeed());
            Services.PLATFORM.finalizeSpawn((PathfinderMob)pathfinderMob, this.world, pathfinderMob.level().getCurrentDifficultyAt(pathfinderMob.getOnPos()), MobSpawnType.EVENT, null);
            this.world.addFreshEntity(pathfinderMob);
            this.SpawnUnit();
            this.activeBossMembers.add((LivingEntity)pathfinderMob);
            this.bossEntitiesSpawned.add(entity);
            return pathfinderMob;
        }
        return null;
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public boolean isHordeMember(LivingEntity entity) {
        return this.activeHordeMembers.contains(entity) || this.activeBossMembers.contains(entity);
    }

    public void injectGoal(PathfinderMob entity, EntityTypeHordeData<?> entityHordeData, double movementSpeedModifier) {
        GoalSelector mobGoalSelector = ((LivingGoalAccessor)entity).cartoonishHordeGetMobGoalSelector();
        mobGoalSelector.addGoal(entityHordeData.getGoalPriority(), new JsonHordeMovementGoal<PathfinderMob>(entity, this, movementSpeedModifier));
    }

    public static void removeGoal(PathfinderMob entity) {
        GoalSelector mobGoalSelector = ((LivingGoalAccessor)entity).cartoonishHordeGetMobGoalSelector();
        Set prioritizedGoals = mobGoalSelector.getAvailableGoals();
        Goal toremove = null;
        for (WrappedGoal prioritizedGoal : prioritizedGoals) {
            if (!(prioritizedGoal.getGoal() instanceof TypeHordeMovementGoal)) continue;
            toremove = prioritizedGoal.getGoal();
            break;
        }
        if (toremove != null) {
            mobGoalSelector.removeGoal(toremove);
        }
    }

    public void setHordeData(ArrayList<EntityTypeHordeData<?>> entityHordeData) {
        this.hordeData.clear();
        this.hordeData.addAll(entityHordeData);
    }

    private void awardAdvancement(Collection<ServerPlayer> playersToAward, String advancementToAward) {
        AdvancementHolder advancement = this.server.getAdvancements().get(ResourceLocation.parse((String)advancementToAward));
        for (ServerPlayer player : playersToAward) {
            AdvancementProgress progress = player.getAdvancements().getOrStartProgress(advancement);
            if (progress.isDone()) continue;
            for (String s : progress.getRemainingCriteria()) {
                player.getAdvancements().award(advancement, s);
            }
        }
    }

    public static enum HordeStopReasons {
        VICTORY,
        DEFEAT,
        PEACEFUL,
        SPAWN_ERROR;

    }
}

