/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.villainoushordemanager.hordes;

import com.cartoonishvillain.villainoushordemanager.TypeHordeMovementGoal;
import com.cartoonishvillain.villainoushordemanager.data.EntityTypeWaveData;
import com.cartoonishvillain.villainoushordemanager.hordedata.EntityTypeHordeData;
import com.cartoonishvillain.villainoushordemanager.mixin.LivingGoalAccessor;
import com.cartoonishvillain.villainoushordemanager.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@Deprecated
public abstract class EntityTypeHorde {
    protected ServerLevel world;
    protected BlockPos center;
    protected Boolean hordeActive = false;
    protected MinecraftServer server;
    protected ArrayList<EntityTypeWaveData> waves;
    protected int hordeWaveNumber = 0;
    protected int Alive = 0;
    protected int initAlive = 0;
    protected int Active = 0;
    protected int allowedActive = 0;
    protected int updateCenter = 0;
    protected ServerPlayer hordeAnchorPlayer;
    protected ArrayList<ServerPlayer> players = new ArrayList();
    protected ArrayList<LivingEntity> activeHordeMembers = new ArrayList();
    protected final ServerBossEvent bossInfo = new ServerBossEvent((Component)Component.literal((String)"EntityTypeHorde"), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_20);
    protected ArrayList<EntityTypeHordeData<?>> hordeData = new ArrayList();
    protected Boolean despawnLeftBehindMembers = true;
    ArrayList<Integer> spawnWeights = new ArrayList();

    public EntityTypeHorde(MinecraftServer server) {
        this.server = server;
    }

    public void Stop(HordeStopReasons stopReason) {
        this.bossInfo.setVisible(false);
        this.bossInfo.removeAllPlayers();
        this.hordeActive = false;
        this.Alive = 0;
        this.initAlive = 0;
        this.Active = 0;
        this.hordeAnchorPlayer = null;
        this.activeHordeMembers.clear();
        this.center = null;
        this.players.clear();
        switch (stopReason.ordinal()) {
            case 0: {
                Services.PLATFORM.getLOGGER().info("Player Victory against EntityTypeHorde");
                break;
            }
            case 1: {
                Services.PLATFORM.getLOGGER().info("Player Defeat against EntityTypeHorde");
                break;
            }
            case 3: {
                Services.PLATFORM.getLOGGER().error("EntityTypeHorde canceled! Could not locate spawn placement! (Entities are too big, or terrain is too noisy)");
                break;
            }
            case 2: {
                Services.PLATFORM.getLOGGER().info("EntityTypeHorde canceled, server changed to peaceful!");
            }
        }
    }

    public Boolean getHordeActive() {
        return this.hordeActive;
    }

    public void SetUpHorde(ServerPlayer serverPlayer) {
        if (serverPlayer.level() instanceof ServerLevel) {
            this.world = (ServerLevel)serverPlayer.level();
            if (serverPlayer.level().dimension().equals(this.world.dimension())) {
                this.hordeAnchorPlayer = serverPlayer;
                switch (this.world.getDifficulty()) {
                    case EASY: {
                        this.setEasyDifficultyStats();
                        break;
                    }
                    case NORMAL: {
                        this.setNormalDifficultyStats();
                        break;
                    }
                    case HARD: {
                        this.setHardDifficultyStats();
                        break;
                    }
                    case PEACEFUL: {
                        return;
                    }
                }
                this.setActiveMemberCount();
                this.setCenterBlock(serverPlayer.blockPosition());
                this.hordeActive = true;
                this.spawnWeights = new ArrayList();
                for (EntityTypeHordeData<?> hordeEntry : this.hordeData) {
                    this.spawnWeights.add(hordeEntry.getSpawnWeight());
                }
            }
        }
    }

    public void setActiveMemberCount() {
        this.allowedActive = 15;
    }

    public void setEasyDifficultyStats() {
        this.Alive = 10;
        this.initAlive = 10;
    }

    public void setNormalDifficultyStats() {
        this.Alive = 25;
        this.initAlive = 25;
    }

    public void setHardDifficultyStats() {
        this.Alive = 40;
        this.initAlive = 40;
    }

    public void setCenterBlock(BlockPos centerPosition) {
        this.center = centerPosition;
    }

    protected boolean checkIfPlayerIsStillValid(ServerPlayer serverPlayer) {
        return serverPlayer.getHealth() != 0.0f && !serverPlayer.isRemoved();
    }

    protected void PeacefulCheck() {
        if (this.world.getDifficulty() == Difficulty.PEACEFUL) {
            this.Stop(HordeStopReasons.PEACEFUL);
        }
    }

    protected void updateCenter() {
        if (this.updateCenter == 0) {
            this.center = this.hordeAnchorPlayer.getOnPos();
            this.updateCenter = 100;
            this.updatePlayers();
            this.updateHorde();
        } else {
            --this.updateCenter;
        }
    }

    public void tick() {
        if (this.hordeActive.booleanValue()) {
            if (this.Alive > 0) {
                if (this.hordeAnchorPlayer.level().dimensionType().equals((Object)this.world.dimensionType()) && this.checkIfPlayerIsStillValid(this.hordeAnchorPlayer)) {
                    this.PeacefulCheck();
                    if (!this.hordeActive.booleanValue()) {
                        return;
                    }
                    if (this.Active != this.activeHordeMembers.size()) {
                        this.Active = this.activeHordeMembers.size();
                    }
                    this.bossInfo.setVisible(true);
                    if (this.Active < this.allowedActive) {
                        this.spawnHordeMember();
                    }
                    if (this.hordeActive.booleanValue()) {
                        this.updateCenter();
                        float aliveDivision = (float)this.Alive / (float)this.initAlive;
                        this.bossInfo.setProgress(Mth.clamp((float)aliveDivision, (float)0.0f, (float)1.0f));
                    }
                } else {
                    this.updatePlayers();
                    if (this.players.size() == 0) {
                        this.Stop(HordeStopReasons.DEFEAT);
                    } else {
                        this.bossInfo.removePlayer(this.hordeAnchorPlayer);
                        this.hordeAnchorPlayer = this.players.get(0);
                        this.players.remove(0);
                    }
                }
            } else {
                this.Stop(HordeStopReasons.VICTORY);
            }
        }
    }

    protected void updatePlayers() {
        for (ServerPlayer serverPlayer : this.server.getPlayerList().getPlayers()) {
            if (this.hordeAnchorPlayer == serverPlayer) {
                this.bossInfo.addPlayer(serverPlayer);
                continue;
            }
            if (serverPlayer.level().dimensionType().equals((Object)this.world.dimensionType()) && this.checkIfPlayerIsStillValid(serverPlayer)) {
                double distance = Mth.sqrt((float)((float)serverPlayer.distanceToSqr((double)this.center.getX(), (double)this.center.getY(), (double)this.center.getZ())));
                if (distance < 64.0) {
                    if (this.players.contains(serverPlayer)) continue;
                    this.bossInfo.addPlayer(serverPlayer);
                    this.players.add(serverPlayer);
                    continue;
                }
                this.bossInfo.removePlayer(serverPlayer);
                this.players.remove(serverPlayer);
                continue;
            }
            this.bossInfo.removePlayer(serverPlayer);
            this.players.remove(serverPlayer);
        }
    }

    protected void updateHorde() {
        ArrayList<LivingEntity> removals = new ArrayList<LivingEntity>();
        ArrayList<LivingEntity> deleteMobs = new ArrayList<LivingEntity>();
        for (LivingEntity hordeMember : this.activeHordeMembers) {
            BlockPos hordeTarget;
            if (hordeMember.isDeadOrDying()) {
                removals.add(hordeMember);
                this.UnitDown();
            } else if (hordeMember.isRemoved()) {
                removals.add(hordeMember);
                this.UnitLost();
            }
            if (!(Mth.sqrt((float)((float)hordeMember.distanceToSqr((double)(hordeTarget = this.center).getX(), (double)hordeTarget.getY(), (double)hordeTarget.getZ()))) > 64.0f)) continue;
            EntityTypeHorde.removeGoal((PathfinderMob)hordeMember);
            removals.add(hordeMember);
            if (this.despawnLeftBehindMembers.booleanValue()) {
                deleteMobs.add(hordeMember);
            }
            this.UnitLost();
        }
        for (LivingEntity removal : removals) {
            this.activeHordeMembers.remove(removal);
        }
        for (LivingEntity removal : deleteMobs) {
            removal.remove(Entity.RemovalReason.DISCARDED);
        }
        removals.clear();
    }

    protected Optional<BlockPos> getValidSpawn(int var, EntityType<?> type) {
        for (int i = 0; i < 3; ++i) {
            BlockPos blockPos = this.findRandomSpawnPos(var, type);
            if (blockPos == null) continue;
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    protected BlockPos findRandomSpawnPos(int loopvar, EntityType<?> type) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int a = 0; a < loopvar; ++a) {
            double DISTANCE = -1.0;
            int j = Integer.MAX_VALUE;
            int l = Integer.MAX_VALUE;
            while (!(DISTANCE > 450.0) || !(DISTANCE < 1250.0)) {
                j = this.randFinder(this.center.getX());
                l = this.randFinder(this.center.getZ());
                DISTANCE = this.center.distSqr((Vec3i)new BlockPos(j, this.center.getY(), l));
            }
            int k = this.findSafeYPosition(j, l, type, false);
            if (k == this.world.getMinBuildHeight() - 1) continue;
            blockPos.set(j, k, l);
            return blockPos;
        }
        double DISTANCE = -1.0;
        int j = Integer.MAX_VALUE;
        int l = Integer.MAX_VALUE;
        while (!(DISTANCE > 450.0) || !(DISTANCE < 1250.0)) {
            j = this.randFinder(this.center.getX());
            l = this.randFinder(this.center.getZ());
            DISTANCE = this.center.distSqr((Vec3i)new BlockPos(j, this.center.getY(), l));
        }
        int k = this.findSafeYPosition(j, l, type, true);
        if (k != this.world.getMinBuildHeight() - 1) {
            blockPos.set(j, k, l);
            return blockPos;
        }
        return null;
    }

    protected int findSafeYPosition(int xValue, int zValue, EntityType<?> entityType, boolean unfiltered) {
        SpawnPlacementType vexType;
        SpawnPlacementType spawnplacementtype;
        BlockState blockState;
        int baseYValue;
        int minHeight;
        int maxHeight;
        if (unfiltered) {
            maxHeight = this.world.getMaxBuildHeight() + 1;
            minHeight = this.world.getMinBuildHeight() + 1;
        } else {
            maxHeight = this.center.getY() + 25;
            minHeight = this.center.getY() - 25;
        }
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (baseYValue = this.center.getY(); baseYValue < maxHeight; ++baseYValue) {
            blockPos.set(xValue, baseYValue - 1, zValue);
            blockState = this.world.getBlockState((BlockPos)blockPos);
            spawnplacementtype = SpawnPlacements.getPlacementType(entityType);
            vexType = SpawnPlacements.getPlacementType((EntityType)EntityType.VEX);
            if (spawnplacementtype.getClass() == vexType.getClass()) {
                spawnplacementtype = SpawnPlacementTypes.ON_GROUND;
            }
            if (!spawnplacementtype.isSpawnPositionOk((LevelReader)this.world, (BlockPos)blockPos, entityType) || blockState.equals(Blocks.BEDROCK.defaultBlockState())) continue;
            return baseYValue;
        }
        for (baseYValue = this.center.getY(); baseYValue > minHeight; --baseYValue) {
            blockPos.set(xValue, baseYValue - 1, zValue);
            blockState = this.world.getBlockState((BlockPos)blockPos);
            spawnplacementtype = SpawnPlacements.getPlacementType(entityType);
            vexType = SpawnPlacements.getPlacementType((EntityType)EntityType.VEX);
            if (spawnplacementtype.getClass() == vexType.getClass()) {
                spawnplacementtype = SpawnPlacementTypes.ON_GROUND;
            }
            if (!spawnplacementtype.isSpawnPositionOk((LevelReader)this.world, (BlockPos)blockPos, entityType) || blockState.equals(Blocks.BEDROCK.defaultBlockState())) continue;
            return baseYValue;
        }
        return this.world.getMinBuildHeight() - 1;
    }

    protected int randFinder(int centercoord) {
        return centercoord + (this.world.random.nextInt(50) - 25);
    }

    public void SpawnUnit() {
        ++this.Active;
    }

    public void InviteUnit() {
        ++this.Active;
    }

    public void UnitDown() {
        --this.Active;
        --this.Alive;
    }

    public void UnitLost() {
        --this.Active;
    }

    protected void spawnHordeMember() {
        Optional<Object> hordeSpawn = Optional.empty();
        int combined = 0;
        for (Integer weight : this.spawnWeights) {
            combined += weight.intValue();
        }
        Random random = new Random();
        int rng = random.nextInt(combined);
        int selected = -1;
        int counter = 0;
        for (Integer weights : this.spawnWeights) {
            if (rng + 1 - weights <= 0) {
                selected = counter;
                break;
            }
            ++counter;
            rng -= weights.intValue();
        }
        EntityTypeHordeData<?> entrySelected = this.hordeData.get(selected);
        Object pathfinderMob = entrySelected.createInstance(this.world);
        int attempts = 0;
        while (hordeSpawn.isEmpty()) {
            hordeSpawn = this.getValidSpawn(10, entrySelected.getType());
            if (!hordeSpawn.isEmpty() || ++attempts < 5) continue;
            this.Stop(HordeStopReasons.SPAWN_ERROR);
            return;
        }
        if (pathfinderMob != null) {
            pathfinderMob.setPos((double)((BlockPos)hordeSpawn.get()).getX(), (double)((BlockPos)hordeSpawn.get()).getY(), (double)((BlockPos)hordeSpawn.get()).getZ());
            this.injectGoal((PathfinderMob)pathfinderMob, entrySelected, entrySelected.getGoalMovementSpeed());
            Services.PLATFORM.finalizeSpawn((PathfinderMob)pathfinderMob, this.world, pathfinderMob.level().getCurrentDifficultyAt(pathfinderMob.getOnPos()), MobSpawnType.EVENT, null);
            this.world.addFreshEntity(pathfinderMob);
            this.SpawnUnit();
            this.activeHordeMembers.add((LivingEntity)pathfinderMob);
        }
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public boolean isHordeMember(LivingEntity entity) {
        return this.activeHordeMembers.contains(entity);
    }

    public void injectGoal(PathfinderMob entity, EntityTypeHordeData<?> entityHordeData, double movementSpeedModifier) {
        GoalSelector mobGoalSelector = ((LivingGoalAccessor)entity).cartoonishHordeGetMobGoalSelector();
        mobGoalSelector.addGoal(entityHordeData.getGoalPriority(), new TypeHordeMovementGoal<PathfinderMob>(entity, this, movementSpeedModifier));
    }

    public static void removeGoal(PathfinderMob entity) {
        GoalSelector mobGoalSelector = ((LivingGoalAccessor)entity).cartoonishHordeGetMobGoalSelector();
        Set prioritizedGoals = mobGoalSelector.getAvailableGoals();
        Goal toremove = null;
        for (WrappedGoal prioritizedGoal : prioritizedGoals) {
            if (!(prioritizedGoal.getGoal() instanceof TypeHordeMovementGoal)) continue;
            toremove = prioritizedGoal.getGoal();
            break;
        }
        if (toremove != null) {
            mobGoalSelector.removeGoal(toremove);
        }
    }

    public void setHordeData(EntityTypeHordeData<?> ... entityHordeData) {
        this.hordeData.clear();
        this.hordeData.addAll(List.of(entityHordeData));
    }

    public static enum HordeStopReasons {
        VICTORY,
        DEFEAT,
        PEACEFUL,
        SPAWN_ERROR;

    }
}

