/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.villainoushordemanager.hordedata;

import com.cartoonishvillain.villainoushordemanager.Constants;
import com.cartoonishvillain.villainoushordemanager.hordedata.HordeData;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;

public class EntityTypeHordeData<T extends PathfinderMob>
implements HordeData {
    private final EntityType<? extends PathfinderMob> type;
    private final double goalMovementSpeed;
    private final int goalPriority;
    private final int spawnWeight;
    private final String nbtData;

    public EntityTypeHordeData(int goalPriority, double goalMovementSpeed, int spawnWeight, EntityType<T> type) {
        this.goalPriority = goalPriority;
        this.goalMovementSpeed = goalMovementSpeed;
        this.spawnWeight = spawnWeight;
        this.type = type;
        this.nbtData = null;
    }

    public EntityTypeHordeData(int goalPriority, double goalMovementSpeed, int spawnWeight, EntityType<T> type, String nbtData) {
        this.goalPriority = goalPriority;
        this.goalMovementSpeed = goalMovementSpeed;
        this.spawnWeight = spawnWeight;
        this.type = type;
        this.nbtData = nbtData;
    }

    @Override
    public double getGoalMovementSpeed() {
        return this.goalMovementSpeed;
    }

    @Override
    public int getGoalPriority() {
        return this.goalPriority;
    }

    @Override
    public int getSpawnWeight() {
        return this.spawnWeight;
    }

    public EntityType<? extends PathfinderMob> getType() {
        return this.type;
    }

    public T createInstance(ServerLevel level) {
        CompoundTag compoundTag = new CompoundTag();
        if (this.nbtData != null) {
            try {
                compoundTag = TagParser.parseTag((String)this.nbtData);
            }
            catch (CommandSyntaxException e) {
                Constants.LOG.error("Horde Manager - Failed to load NBT data for: {}", (Object)EntityType.getKey(this.type).getPath());
            }
        }
        compoundTag.putString("id", EntityType.getKey(this.type).toString());
        return (T)((PathfinderMob)EntityType.loadEntityRecursive((CompoundTag)compoundTag, (Level)level, entityx -> entityx));
    }
}

