/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.villainoushordemanager;

import com.cartoonishvillain.villainoushordemanager.EnumHordeMovementGoal;
import com.cartoonishvillain.villainoushordemanager.JsonHordeMovementGoal;
import com.cartoonishvillain.villainoushordemanager.TypeHordeMovementGoal;
import com.cartoonishvillain.villainoushordemanager.data.json.JsonHordeData;
import com.cartoonishvillain.villainoushordemanager.hordes.EntityEnumHorde;
import com.cartoonishvillain.villainoushordemanager.hordes.EntityTypeHorde;
import com.cartoonishvillain.villainoushordemanager.hordes.JsonHorde;
import com.cartoonishvillain.villainoushordemanager.mixin.LivingGoalAccessor;
import com.cartoonishvillain.villainoushordemanager.platform.Services;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;

public class VillainousHordeManager {
    public static EntityTypeHorde entityTypeHorde;
    public static EntityEnumHorde entityEnumHorde;
    public static HashMap<String, JsonHordeData> gsonHordes;
    public static JsonHorde jsonHorde;

    public static void init() {
    }

    public static int loadHordes() {
        int failures = 0;
        String dir = System.getProperty("user.dir") + "/config/villainoushordemanager";
        ArrayList paths = new ArrayList();
        try {
            Files.createDirectories(Path.of(dir, new String[0]), new FileAttribute[0]);
            paths.addAll(Files.walk(Paths.get(dir, new String[0]), 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".json")).collect(Collectors.toList()));
        }
        catch (IOException e) {
            failures = -1;
            Services.PLATFORM.getLOGGER().error("VillainousHordeManager - Failed to grab json horde data: ");
            e.printStackTrace();
        }
        for (Path path2 : paths) {
            try {
                JsonReader reader = new JsonReader((Reader)new FileReader(path2.toFile()));
                JsonHordeData[] hordesArray = (JsonHordeData[])new Gson().fromJson(reader, JsonHordeData[].class);
                ArrayList<JsonHordeData> hordesArrayList = new ArrayList<JsonHordeData>(Arrays.stream(hordesArray).toList());
                for (JsonHordeData hordes : hordesArrayList) {
                    gsonHordes.put(hordes.getHordeName(), hordes);
                }
            }
            catch (Exception e) {
                ++failures;
                Services.PLATFORM.getLOGGER().warn("VillainousHordeManager - Failed to load file: " + String.valueOf(path2.getFileName()));
                e.printStackTrace();
            }
        }
        return failures;
    }

    public static boolean isHordeMember(PathfinderMob entity) {
        GoalSelector mobGoalSelector = ((LivingGoalAccessor)entity).cartoonishHordeGetMobGoalSelector();
        Set prioritizedGoals = mobGoalSelector.getAvailableGoals();
        Goal hordeGoal = null;
        for (WrappedGoal prioritizedGoal : prioritizedGoals) {
            if (!(prioritizedGoal.getGoal() instanceof TypeHordeMovementGoal) && !(prioritizedGoal.getGoal() instanceof EnumHordeMovementGoal) && !(prioritizedGoal.getGoal() instanceof JsonHordeMovementGoal)) continue;
            hordeGoal = prioritizedGoal.getGoal();
            break;
        }
        return hordeGoal != null;
    }

    static {
        gsonHordes = new HashMap();
    }
}

