/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.villainoushordemanager;

import com.cartoonishvillain.villainoushordemanager.VillainousHordeManager;
import com.cartoonishvillain.villainoushordemanager.codebasedhordetest.TestEnumHorde;
import com.cartoonishvillain.villainoushordemanager.codebasedhordetest.TestHordeDataClass;
import com.cartoonishvillain.villainoushordemanager.hordedata.EnumHordeData;
import com.cartoonishvillain.villainoushordemanager.platform.Services;
import com.cartoonishvillain.villainoushordemanager.testcommands.EntityEnumHordeCommand;
import com.cartoonishvillain.villainoushordemanager.testcommands.EntityJsonHordeCommand;
import com.cartoonishvillain.villainoushordemanager.testcommands.EntityTypeHordeCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.slf4j.Logger;

@Mod(value="villainoushordemanager")
public class NeoForgeVillainousHordeManager {
    public static final Logger LOGGER = LogUtils.getLogger();

    public NeoForgeVillainousHordeManager(IEventBus eventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        VillainousHordeManager.init();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            VillainousHordeManager.entityEnumHorde = new TestEnumHorde(event.getServer());
            VillainousHordeManager.entityEnumHorde.setHordeData(new EnumHordeData(2, 1.0, 1, TestHordeDataClass.CREEPEROVERZOMBIENETHER), new EnumHordeData(2, 1.0, 1, TestHordeDataClass.SPIDEROVEREVOKERNETHER), new EnumHordeData(2, 1.0, 1, TestHordeDataClass.VINDICATOROVERSKELETONNETHER));
        }
        VillainousHordeManager.loadHordes();
    }

    @SubscribeEvent
    public void onEntityDamaged(LivingDamageEvent.Pre event) {
        if (event.getEntity() instanceof PathfinderMob && VillainousHordeManager.isHordeMember((PathfinderMob)event.getEntity()) && event.getEntity().tickCount < 2) {
            event.getEntity().remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @SubscribeEvent
    public void onWorldTick(LevelTickEvent.Pre event) {
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            if (!event.getLevel().isClientSide && VillainousHordeManager.entityTypeHorde != null) {
                VillainousHordeManager.entityTypeHorde.tick();
            }
            if (!event.getLevel().isClientSide && VillainousHordeManager.entityEnumHorde != null) {
                VillainousHordeManager.entityEnumHorde.tick();
            }
        }
        if (!event.getLevel().isClientSide && VillainousHordeManager.jsonHorde != null) {
            VillainousHordeManager.jsonHorde.tick();
        }
    }

    @SubscribeEvent
    public void CMDRegister(RegisterCommandsEvent event) {
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            EntityTypeHordeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            EntityEnumHordeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
        EntityJsonHordeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

