/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.villainoushordemanager;

import com.cartoonishvillain.villainoushordemanager.hordes.JsonHorde;
import java.util.EnumSet;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class JsonHordeMovementGoal<T extends PathfinderMob>
extends Goal {
    private final T Member;
    private final JsonHorde hordeInstance;
    private final double movementModifier;

    public JsonHordeMovementGoal(T member, JsonHorde hordeInstance, Double movementModifier) {
        this.Member = member;
        this.hordeInstance = hordeInstance;
        this.movementModifier = movementModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.hordeInstance.getHordeActive() != false && this.hordeInstance.getCenter() != null && this.hordeInstance.isHordeMember((LivingEntity)this.Member) && this.Member.getTarget() == null;
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void tick() {
        Vec3 vector3d;
        super.tick();
        if (!this.Member.isPathFinding() && (vector3d = DefaultRandomPos.getPosTowards(this.Member, (int)15, (int)4, (Vec3)Vec3.atBottomCenterOf((Vec3i)this.hordeInstance.getCenter()), (double)0.3141592741012573)) != null) {
            this.Member.getNavigation().moveTo(vector3d.x, vector3d.y, vector3d.z, this.movementModifier);
        }
    }
}

