/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.client.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArrayLayeredTexture
extends AbstractTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    public final List<String> layeredTextureNames;

    public ArrayLayeredTexture(List<String> textureNames) {
        this.layeredTextureNames = textureNames;
    }

    public void load(ResourceManager manager) {
        block9: {
            Iterator<String> iterator = this.layeredTextureNames.iterator();
            String s = iterator.next();
            Optional iresource = manager.getResource(ResourceLocation.tryParse((String)s));
            if (iresource.isPresent()) {
                try {
                    NativeImage nativeimage = NativeImage.read((InputStream)((Resource)iresource.get()).open());
                    while (iterator.hasNext()) {
                        String s1 = iterator.next();
                        if (s1 == null) continue;
                        Optional iresource1 = manager.getResource(ResourceLocation.tryParse((String)s1));
                        assert (iresource1.isPresent());
                        NativeImage nativeimage1 = NativeImage.read((InputStream)((Resource)iresource1.get()).open());
                        for (int i = 0; i < Math.min(nativeimage1.getHeight(), nativeimage.getHeight()); ++i) {
                            for (int j = 0; j < Math.min(nativeimage1.getWidth(), nativeimage.getWidth()); ++j) {
                                nativeimage.blendPixel(j, i, nativeimage1.getPixelRGBA(j, i));
                            }
                        }
                    }
                    if (!RenderSystem.isOnRenderThreadOrInit()) {
                        RenderSystem.recordRenderCall(() -> this.loadImage(nativeimage));
                        break block9;
                    }
                    this.loadImage(nativeimage);
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't load layered image", (Throwable)exception);
                }
            } else {
                LOGGER.error("Couldn't load layered image");
            }
        }
    }

    private void loadImage(NativeImage imageIn) {
        TextureUtil.prepareImage((int)this.getId(), (int)imageIn.getWidth(), (int)imageIn.getHeight());
        imageIn.upload(0, 0, 0, true);
    }
}

