/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.block;

import com.yungnickyoung.minecraft.ribbits.module.PlacedFeatureModule;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GiantLilyPadBlock
extends WaterlilyBlock
implements BonemealableBlock {
    protected static final VoxelShape AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);

    public GiantLilyPadBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return AABB;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource random, BlockPos blockPos, BlockState blockState) {
        Optional placedFeature = serverLevel.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).getOptional(PlacedFeatureModule.GIANT_LILYPAD_PATCH);
        placedFeature.ifPresent(feature -> feature.place((WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), random, blockPos));
    }
}

