/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.reg;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.mehvahdjukaar.moonlight.api.block.ModStairBlock;
import net.mehvahdjukaar.moonlight.api.misc.IAttachmentType;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedDataType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.common.block.GingerBlock;
import net.mehvahdjukaar.snowyspirit.common.block.GlowLightsBlock;
import net.mehvahdjukaar.snowyspirit.common.block.GlowLightsBlockTile;
import net.mehvahdjukaar.snowyspirit.common.block.GumdropButton;
import net.mehvahdjukaar.snowyspirit.common.block.SnowGlobeBlock;
import net.mehvahdjukaar.snowyspirit.common.block.WildGingerBlock;
import net.mehvahdjukaar.snowyspirit.common.block.WreathBlock;
import net.mehvahdjukaar.snowyspirit.common.entity.ContainerHolderEntity;
import net.mehvahdjukaar.snowyspirit.common.entity.GingyEntity;
import net.mehvahdjukaar.snowyspirit.common.entity.MongoEntity;
import net.mehvahdjukaar.snowyspirit.common.entity.SledEntity;
import net.mehvahdjukaar.snowyspirit.common.items.CandyCaneItem;
import net.mehvahdjukaar.snowyspirit.common.items.EggnogItem;
import net.mehvahdjukaar.snowyspirit.common.items.GlowLightsItem;
import net.mehvahdjukaar.snowyspirit.common.items.SledItem;
import net.mehvahdjukaar.snowyspirit.common.wreath.ChunksWithWreaths;
import net.mehvahdjukaar.snowyspirit.common.wreath.WreathData;
import net.mehvahdjukaar.snowyspirit.reg.ModSounds;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.material.MapColor;

public class ModRegistry {
    public static final IAttachmentType<WreathData, ChunkAccess> WREATH_CHUNK_DATA = RegHelper.registerDataAttachment((ResourceLocation)SnowySpirit.res("wreath_data"), () -> RegHelper.AttachmentBuilder.create(WreathData::new).syncWith(WreathData.STREAM_CODEC).persistent(WreathData.CODEC).copyOnDeath(), ChunkAccess.class);
    public static final WorldSavedDataType<ChunksWithWreaths> WREATH_WORLD_DATA = RegHelper.registerWorldSavedData((ResourceLocation)SnowySpirit.res("wreath_chunks"), s -> new ChunksWithWreaths(), ChunksWithWreaths.CODEC, PlatHelper.getPlatform().isFabric() ? ChunksWithWreaths.STREAM_CODEC : null, (boolean)true);
    public static final BlockSetType GINGER_TYPE = BlockSetType.register((BlockSetType)new BlockSetType(SnowySpirit.res("ginger").toString()));
    public static final String GINGERBREAD_GOLEM_NAME = "gingerbread_golem";
    public static final Supplier<EntityType<GingyEntity>> GINGERBREAD_GOLEM = ModRegistry.regEntity("gingerbread_golem", () -> EntityType.Builder.of(GingyEntity::new, (MobCategory)MobCategory.MISC).immuneTo(new Block[]{Blocks.POWDER_SNOW}).sized(0.375f, 1.0f).ridingOffset(-0.3125f).clientTrackingRange(8));
    public static final Supplier<EntityType<MongoEntity>> GINGERBREAD_GIANT = ModRegistry.regEntity("gingerbread_giant", () -> EntityType.Builder.of(MongoEntity::new, (MobCategory)MobCategory.MISC).immuneTo(new Block[]{Blocks.POWDER_SNOW}).sized(3.75f, 11.0f).passengerAttachments(new float[]{11.0f}).clientTrackingRange(10));
    public static final Supplier<SpawnEggItem> GINGERBREAD_GOLEM_EGG = ModRegistry.regItem("gingerbread_golem_spawn_egg", () -> PlatHelper.newSpawnEgg(GINGERBREAD_GOLEM, (int)12152085, (int)15133667, (Item.Properties)new Item.Properties()));
    public static final String SLED_NAME = "sled";
    public static final Supplier<EntityType<SledEntity>> SLED = ModRegistry.regEntity("sled", () -> EntityType.Builder.of(SledEntity::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).passengerAttachments(new float[]{0.45f}).clientTrackingRange(10));
    public static final Supplier<EntityType<ContainerHolderEntity>> CONTAINER_ENTITY = ModRegistry.regEntity("container_entity", () -> EntityType.Builder.of(ContainerHolderEntity::new, (MobCategory)MobCategory.MISC).sized(0.75f, 0.75f).ridingOffset(0.0625f).clientTrackingRange(8));
    public static final Map<WoodType, SledItem> SLED_ITEMS = new LinkedHashMap<WoodType, SledItem>();
    public static final Supplier<Block> CANDY_CANE_BLOCK = ModRegistry.regWithItem("candy_cane_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CALCITE).mapColor(MapColor.COLOR_PINK).requiresCorrectToolForDrops().strength(1.5f).sound(SoundType.CALCITE)));
    public static final String CANDY_CANE_NAME = "candy_cane";
    public static final Supplier<Item> CANDY_CANE = ModRegistry.regItem("candy_cane", () -> new CandyCaneItem(new Item.Properties().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.4f).build())));
    public static final Supplier<Item> GINGERBREAD_COOKIE = ModRegistry.regItem("gingerbread_cookie", () -> new Item(new Item.Properties().food(new FoodProperties.Builder().nutrition(1).fast().saturationModifier(0.4f).build())));
    public static final String EGGNOG_NAME = "eggnog";
    public static final Supplier<Item> EGGNOG = ModRegistry.regItem("eggnog", EggnogItem::new);
    public static final String WINTER_DISC_NAME = "music_disc_a_carol";
    public static final Supplier<Item> WINTER_DISC = ModRegistry.regItem("music_disc_a_carol", () -> new Item(new Item.Properties().rarity(Rarity.RARE).jukeboxPlayable(ModSounds.WINTER_DISC_JUKEBOX).stacksTo(1)));
    public static final Supplier<Block> GINGERBREAD_BLOCK = ModRegistry.regWithItem("gingerbread", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).sound(ModSounds.GINGERBREAD).strength(1.0f)));
    public static final Supplier<Block> GINGERBREAD_STAIRS = ModRegistry.regWithItem("gingerbread_stairs", () -> new ModStairBlock(GINGERBREAD_BLOCK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GINGERBREAD_BLOCK.get()))));
    public static final Supplier<Block> GINGERBREAD_SLAB = ModRegistry.regWithItem("gingerbread_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GINGERBREAD_BLOCK.get()))));
    public static final Supplier<Block> GINGERBREAD_FROSTED_BLOCK = ModRegistry.regWithItem("gingerbread_frosted", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GINGERBREAD_BLOCK.get()))));
    public static final Supplier<Block> GINGERBREAD_DOOR = ModRegistry.regWithItem("gingerbread_door", () -> new DoorBlock(GINGER_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GINGERBREAD_BLOCK.get()))));
    public static final Supplier<Block> GINGERBREAD_TRAPDOOR = ModRegistry.regWithItem("gingerbread_trapdoor", () -> new TrapDoorBlock(GINGER_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GINGERBREAD_BLOCK.get()))));
    public static final Supplier<Block> GINGER_WILD = ModRegistry.regWithItem("wild_ginger", () -> new WildGingerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS)));
    public static final String GINGER_NAME = "ginger";
    public static final Supplier<Block> GINGER_CROP = ModRegistry.regBlock("ginger", () -> new GingerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT).noCollission().randomTicks().instabreak()));
    public static final Supplier<Item> GINGER_FLOWER = ModRegistry.regItem("ginger_flower", () -> new ItemNameBlockItem(GINGER_CROP.get(), new Item.Properties()));
    public static final Supplier<Item> GINGER = ModRegistry.regItem("ginger", () -> new Item(new Item.Properties()));
    public static final Supplier<Block> GINGER_POT = ModRegistry.regBlock("potted_ginger", () -> PlatHelper.newFlowerPot(() -> (FlowerPotBlock)Blocks.FLOWER_POT, GINGER_CROP, (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final Supplier<SimpleParticleType> GLOW_LIGHT_PARTICLE = RegHelper.registerParticle((ResourceLocation)SnowySpirit.res("glow_light"));
    public static final String GUMDROP_NAME = "gumdrop";
    public static final Map<DyeColor, Supplier<Block>> GUMDROPS_BUTTONS = (Map)BlocksColorAPI.SORTED_COLORS.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), c -> ModRegistry.regWithItem("gumdrop_" + c.getName(), () -> new GumdropButton(BlockBehaviour.Properties.of().instabreak().noOcclusion().sound(SoundType.SLIME_BLOCK).noCollission(), (DyeColor)c))));
    public static final String GLOW_LIGHTS_NAME = "glow_lights";
    public static final Map<DyeColor, Supplier<Block>> GLOW_LIGHTS_BLOCKS = (Map)Util.make(() -> {
        HashMap<DyeColor, Supplier<Block>> m = new HashMap<DyeColor, Supplier<Block>>();
        for (DyeColor c : DyeColor.values()) {
            m.put(c, ModRegistry.regBlock("glow_lights_" + c.getName(), () -> new GlowLightsBlock(c)));
        }
        m.put(null, ModRegistry.regBlock("glow_lights_prismatic", () -> new GlowLightsBlock(null)));
        return m;
    });
    public static final Map<DyeColor, Supplier<Item>> GLOW_LIGHTS_ITEMS = (Map)Util.make(() -> {
        HashMap<DyeColor, Supplier<Item>> m = new HashMap<DyeColor, Supplier<Item>>();
        for (DyeColor c : BlocksColorAPI.SORTED_COLORS) {
            m.put(c, ModRegistry.regItem("glow_lights_" + c.getName(), () -> new GlowLightsItem(GLOW_LIGHTS_BLOCKS.get(c).get())));
        }
        m.put(null, ModRegistry.regItem("glow_lights_prismatic", () -> new GlowLightsItem(GLOW_LIGHTS_BLOCKS.get(null).get())));
        return m;
    });
    public static final Supplier<BlockEntityType<GlowLightsBlockTile>> GLOW_LIGHTS_BLOCK_TILE = ModRegistry.regTile("glow_lights", () -> PlatHelper.newBlockEntityType(GlowLightsBlockTile::new, (Block[])((Block[])GLOW_LIGHTS_BLOCKS.values().stream().map(Supplier::get).toArray(Block[]::new))));
    public static final String WREATH_NAME = "wreath";
    public static final Supplier<Block> WREATH = ModRegistry.regWithItem("wreath", () -> new WreathBlock(BlockBehaviour.Properties.of().ignitedByLava().noOcclusion().mapColor(MapColor.COLOR_GREEN).sound(SoundType.VINE).strength(0.1f).noCollission()));
    public static final String SNOW_GLOBE_NAME = "snow_globe";
    public static final Supplier<Block> SNOW_GLOBE = ModRegistry.regWithItem("snow_globe", () -> new SnowGlobeBlock(BlockBehaviour.Properties.of().sound(SoundType.GLASS).mapColor(MapColor.NONE).strength(0.5f)));
    public static final Supplier<DataComponentType<CompoundTag>> CONTAINER_BLOCK_ENTITY_TAG = ModRegistry.regDataComponentType("container_block_entity", b -> b.persistent(CompoundTag.CODEC));

    public static void init() {
        BlockSetAPI.addDynamicRegistration((String)"snowyspirit", ModRegistry::registerSledItems, (Registry)BuiltInRegistries.ITEM);
        RegHelper.addAttributeRegistration(ModRegistry::registerAttributes);
    }

    private static void registerAttributes(RegHelper.AttributeEvent event) {
        event.register(GINGERBREAD_GOLEM.get(), GingyEntity.createAttributes());
        event.register(GINGERBREAD_GIANT.get(), MongoEntity.createGiantAttributes());
    }

    private static void registerSledItems(Registrator<Item> event) {
        for (WoodType wood : WoodTypeRegistry.INSTANCE) {
            if (!wood.canBurn() && !SnowySpirit.BOATLOAD_INSTALLED) continue;
            String name = wood.getVariantId(SLED_NAME);
            SledItem item = new SledItem(wood);
            event.register(SnowySpirit.res(name), (Object)item);
            SLED_ITEMS.put(wood, item);
            wood.addChild(SLED_NAME, (Object)item);
        }
    }

    public static <T> Supplier<DataComponentType<T>> regDataComponentType(String name, UnaryOperator<DataComponentType.Builder<T>> builderOperator) {
        return RegHelper.registerDataComponent((ResourceLocation)SnowySpirit.res(name), () -> ((DataComponentType.Builder)builderOperator.apply(DataComponentType.builder())).build());
    }

    public static <T extends Item> Supplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((ResourceLocation)SnowySpirit.res(name), sup);
    }

    public static <T extends BlockEntityType<E>, E extends BlockEntity> Supplier<T> regTile(String name, Supplier<T> sup) {
        return RegHelper.registerBlockEntityType((ResourceLocation)SnowySpirit.res(name), sup);
    }

    public static <T extends Block> Supplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((ResourceLocation)SnowySpirit.res(name), sup);
    }

    public static <T extends Block> Supplier<T> regWithItem(String name, Supplier<T> blockFactory) {
        return RegHelper.registerBlockWithItem((ResourceLocation)SnowySpirit.res(name), blockFactory);
    }

    public static <T extends Block> Supplier<T> rewWithItem(String name, Supplier<T> blockSup, Item.Properties properties) {
        return RegHelper.registerBlockWithItem((ResourceLocation)SnowySpirit.res(name), blockSup, (Item.Properties)properties);
    }

    public static <T extends Entity> Supplier<EntityType<T>> regEntity(String name, Supplier<EntityType.Builder<T>> builder) {
        return RegHelper.registerEntityType((ResourceLocation)SnowySpirit.res(name), () -> ((EntityType.Builder)builder.get()).build(name));
    }
}

