/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.reg;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.common.items.SledItem;
import net.mehvahdjukaar.snowyspirit.configs.CommonConfigs;
import net.mehvahdjukaar.snowyspirit.integration.supp.SuppCompat;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ModCreativeTabs {
    public static final RegSupplier<CreativeModeTab> MOD_TAB = CommonConfigs.MOD_TAB.get() == false ? null : RegHelper.registerCreativeModeTab((ResourceLocation)SnowySpirit.res("snowyspirit"), builder -> builder.title((Component)Component.translatable((String)"tab.snowyspirit")).icon(() -> ModRegistry.SLED_ITEMS.get(VanillaWoodTypes.OAK).getDefaultInstance()));

    public static void init() {
        RegHelper.addItemsToTabsRegistration(ModCreativeTabs::registerItemsToTabs);
    }

    public static void registerItemsToTabs(RegHelper.ItemToTabEvent e) {
        TabAdder adder = new TabAdder(e);
        adder.after(i -> i.getItem().components().get(DataComponents.JUKEBOX_PLAYABLE) != null, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "music_disc_a_carol", ModRegistry.WINTER_DISC);
        adder.before((ItemLike)Items.HONEY_BOTTLE, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "eggnog", ModRegistry.EGGNOG);
        if (SnowySpirit.SUPPLEMENTARIES_INSTALLED) {
            adder.after(SuppCompat::isCandy, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "ginger", ModRegistry.GINGERBREAD_COOKIE);
            adder.after(SuppCompat::isCandy, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "candy_cane", ModRegistry.CANDY_CANE);
            adder.after(SuppCompat::isGlobe, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "snow_globe", ModRegistry.SNOW_GLOBE);
        } else {
            adder.before((ItemLike)Items.ROTTEN_FLESH, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "ginger", ModRegistry.GINGERBREAD_COOKIE);
            adder.before((ItemLike)Items.ROTTEN_FLESH, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS, "candy_cane", ModRegistry.CANDY_CANE);
            adder.after((ItemLike)Items.BELL, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "snow_globe", ModRegistry.SNOW_GLOBE);
        }
        adder.after((TagKey<Item>)ItemTags.BOATS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, "sled", (Supplier[])ModRegistry.SLED_ITEMS.values().stream().map(i -> () -> ((SledItem)((Object)i)).asItem()).toArray(Supplier[]::new));
        adder.before((TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "glow_lights", (Supplier[])ModRegistry.GLOW_LIGHTS_ITEMS.values().toArray(Supplier[]::new));
        adder.before((TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS, "gumdrop", (Supplier[])ModRegistry.GUMDROPS_BUTTONS.values().toArray(Supplier[]::new));
        adder.before((TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "glow_lights", (Supplier[])ModRegistry.GLOW_LIGHTS_ITEMS.values().toArray(Supplier[]::new));
        adder.before((TagKey<Item>)ItemTags.BANNERS, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "gumdrop", (Supplier[])ModRegistry.GUMDROPS_BUTTONS.values().toArray(Supplier[]::new));
        adder.before((ItemLike)Items.GLOW_BERRIES, (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, "ginger", ModRegistry.GINGER_FLOWER);
        adder.before((ItemLike)Items.WHEAT, (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS, "ginger", ModRegistry.GINGER);
        adder.after((ItemLike)Items.SMALL_DRIPLEAF, (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS, "ginger", ModRegistry.GINGER_WILD);
        adder.add((ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "ginger", ModRegistry.GINGERBREAD_FROSTED_BLOCK, ModRegistry.GINGERBREAD_BLOCK, ModRegistry.GINGERBREAD_STAIRS, ModRegistry.GINGERBREAD_SLAB, ModRegistry.GINGERBREAD_DOOR, ModRegistry.GINGERBREAD_TRAPDOOR);
        adder.add((ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, "candy_cane", ModRegistry.CANDY_CANE_BLOCK);
        adder.before((ItemLike)Items.BOOKSHELF, (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS, "wreath", ModRegistry.WREATH);
        adder.add((ResourceKey<CreativeModeTab>)CreativeModeTabs.SPAWN_EGGS, "gingerbread_golem", ModRegistry.GINGERBREAD_GOLEM_EGG);
    }

    public static final class TabAdder {
        private final RegHelper.ItemToTabEvent event;
        private final List<ItemStack> uniqueStacksAdded = new ArrayList<ItemStack>();

        public TabAdder(RegHelper.ItemToTabEvent event) {
            this.event = event;
        }

        private void before(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemStack ... items) {
            if (MOD_TAB != null) {
                this.add(tab, items);
                return;
            }
            for (ItemStack stack : items) {
                this.event.addBefore(tab, target, new ItemStack[]{stack});
            }
        }

        private void before(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemLike ... items) {
            this.before(tab, target, (ItemStack[])Arrays.stream(items).map(i -> i.asItem().getDefaultInstance()).toArray(ItemStack[]::new));
        }

        private void after(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemStack ... items) {
            if (MOD_TAB != null) {
                this.add(tab, items);
                return;
            }
            for (ItemStack stack : items) {
                this.event.addAfter(tab, target, new ItemStack[]{stack});
            }
        }

        private void before(TagKey<Item> target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            this.before((ItemStack i) -> i.is(target), tab, key, items);
        }

        private void after(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemLike ... items) {
            this.after(tab, target, (ItemStack[])Arrays.stream(items).map(i -> i.asItem().getDefaultInstance()).toArray(ItemStack[]::new));
        }

        private void add(ResourceKey<CreativeModeTab> tab, ItemStack ... items) {
            ResourceKey tabKey = MOD_TAB == null ? tab : MOD_TAB.getKey();
            for (ItemStack stack : items) {
                if (!this.isUnique(stack)) continue;
                this.event.add(tabKey, new ItemStack[]{stack});
            }
        }

        private void add(ResourceKey<CreativeModeTab> tab, ItemLike ... items) {
            this.add(tab, (ItemStack[])Arrays.stream(items).map(i -> i.asItem().getDefaultInstance()).toArray(ItemStack[]::new));
        }

        private boolean isUnique(ItemStack stack) {
            Preconditions.checkNotNull((Object)stack);
            Preconditions.checkNotNull((Object)stack.getItem());
            if (MOD_TAB == null) {
                return true;
            }
            for (ItemStack s : this.uniqueStacksAdded) {
                if (s.getItem() != stack.getItem() || !ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)stack)) continue;
                return false;
            }
            this.uniqueStacksAdded.add(stack);
            return true;
        }

        private void after(TagKey<Item> target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            this.after((ItemStack i) -> i.is(target), tab, key, items);
        }

        private void after(ItemLike target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            this.after((ItemStack i) -> i.is(target.asItem()), tab, key, items);
        }

        private void after(Predicate<ItemStack> targetPred, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            if (CommonConfigs.isEnabled(key)) {
                Object first = items[0].get();
                if (first instanceof ItemStack) {
                    ItemStack[] entries = (ItemStack[])Arrays.stream(items).map(s -> (ItemStack)s.get()).toArray(ItemStack[]::new);
                    this.after(tab, targetPred, entries);
                } else if (first instanceof Collection) {
                    for (Supplier<?> i : items) {
                        if (!(i instanceof Collection)) continue;
                        Collection c = (Collection)((Object)i);
                        ItemLike[] entries = (ItemLike[])c.stream().map(s -> (ItemLike)s).toArray(ItemLike[]::new);
                        this.after(tab, targetPred, entries);
                    }
                } else {
                    ItemLike[] entries = (ItemLike[])Arrays.stream(items).map(s -> (ItemLike)s.get()).toArray(ItemLike[]::new);
                    this.after(tab, targetPred, entries);
                }
            }
        }

        private void before(ItemLike target, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            this.before((ItemStack i) -> i.is(target.asItem()), tab, key, items);
        }

        private void before(Predicate<ItemStack> targetPred, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            if (CommonConfigs.isEnabled(key)) {
                if (items[0].get() instanceof ItemStack) {
                    ItemStack[] entries = (ItemStack[])Arrays.stream(items).map(s -> (ItemStack)s.get()).toArray(ItemStack[]::new);
                    this.before(tab, targetPred, entries);
                } else {
                    ItemLike[] entries = (ItemLike[])Arrays.stream(items).map(s -> (ItemLike)s.get()).toArray(ItemLike[]::new);
                    this.before(tab, targetPred, entries);
                }
            }
        }

        private void add(ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            if (CommonConfigs.isEnabled(key)) {
                ItemLike[] entries = (ItemLike[])Arrays.stream(items).map(s -> (ItemLike)s.get()).toArray(ItemLike[]::new);
                this.add(tab, entries);
            }
        }

        private void afterML(Item target, ResourceKey<CreativeModeTab> tab, String key, String modLoaded, Supplier<?> ... items) {
            if (PlatHelper.isModLoaded((String)modLoaded)) {
                this.after((ItemLike)target, tab, key, items);
            }
        }

        private void afterML(String modTarget, ResourceKey<CreativeModeTab> tab, String key, Supplier<?> ... items) {
            ResourceLocation id = ResourceLocation.tryParse((String)modTarget);
            BuiltInRegistries.ITEM.getOptional(id).ifPresent(target -> this.after((ItemLike)target, tab, key, items));
        }

        private void afterTL(Item target, ResourceKey<CreativeModeTab> tab, String key, List<String> tags, Supplier<?> ... items) {
            if (TabAdder.isTagOn((String[])tags.toArray(String[]::new))) {
                this.after((ItemLike)target, tab, key, items);
            }
        }

        private void beforeML(Item target, ResourceKey<CreativeModeTab> tab, String key, String modLoaded, Supplier<?> ... items) {
            if (PlatHelper.isModLoaded((String)modLoaded)) {
                this.before((ItemLike)target, tab, key, items);
            }
        }

        private void beforeTL(Item target, ResourceKey<CreativeModeTab> tab, String key, List<String> tags, Supplier<?> ... items) {
            if (TabAdder.isTagOn((String[])tags.toArray(String[]::new))) {
                this.after((ItemLike)target, tab, key, items);
            }
        }

        private static boolean isTagOn(String ... tags) {
            for (String t : tags) {
                if (!BuiltInRegistries.ITEM.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)t))).isPresent()) continue;
                return true;
            }
            return false;
        }
    }
}

