/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.integration.supp.SuppCompat;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.mehvahdjukaar.snowyspirit.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class ContainerHolderEntity
extends Entity
implements Container,
MenuProvider {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.defineId(ContainerHolderEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.defineId(ContainerHolderEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<ItemStack> DATA_CONTAINER = SynchedEntityData.defineId(ContainerHolderEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private BlockState displayState = Blocks.AIR.defaultBlockState();
    private BaseContainerBlockEntity innerBlockEntity;

    public ContainerHolderEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.blocksBuilding = true;
    }

    protected ContainerHolderEntity(Level level, Entity sled, ItemStack containerStack) {
        this(ModRegistry.CONTAINER_ENTITY.get(), level);
        this.setContainerItem(containerStack);
        this.setPos(sled.position());
        if (this.startRiding(sled)) {
            sled.positionRider((Entity)this);
        }
    }

    public BlockState getDisplayState() {
        return this.displayState;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        super.onSyncedDataUpdated(dataAccessor);
        if (dataAccessor.equals(DATA_CONTAINER)) {
            CompoundTag tag;
            EntityBlock eb;
            BlockEntity blockEntity;
            BlockItem bi;
            Block block;
            ItemStack stack = (ItemStack)this.entityData.get(DATA_CONTAINER);
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                this.displayState = blockItem.getBlock().defaultBlockState();
            }
            if ((item = stack.getItem()) instanceof BlockItem && (block = (bi = (BlockItem)item).getBlock()) instanceof EntityBlock && (blockEntity = (eb = (EntityBlock)block).newBlockEntity(BlockPos.ZERO, block.defaultBlockState())) instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity c;
                this.innerBlockEntity = c = (BaseContainerBlockEntity)blockEntity;
                this.innerBlockEntity.setLevel(this.level());
            }
            if (this.innerBlockEntity == null) {
                throw new IllegalStateException("block {} does not provide a valid container block entity");
            }
            if (ContainerHolderEntity.isContainerWithNBT(stack) && stack.hasFoil() && (tag = (CompoundTag)stack.get(ModRegistry.CONTAINER_BLOCK_ENTITY_TAG.get())) != null) {
                this.innerBlockEntity.loadWithComponents(tag, (HolderLookup.Provider)this.registryAccess());
            }
        }
    }

    public void setContainerItem(ItemStack stack) {
        this.entityData.set(DATA_CONTAINER, (Object)stack);
    }

    public ItemStack getContainerItem() {
        return (ItemStack)this.entityData.get(DATA_CONTAINER);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.setContainerItem((ItemStack)((Pair)ItemStack.OPTIONAL_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("ContainerItem")).getOrThrow()).getFirst());
        if (this.innerBlockEntity == null) {
            boolean bl = true;
        } else {
            this.innerBlockEntity.loadWithComponents(tag, (HolderLookup.Provider)this.registryAccess());
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.put("ContainerItem", this.getContainerItem().save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        tag.merge(this.innerBlockEntity.saveWithoutMetadata((HolderLookup.Provider)this.registryAccess()));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ID_HURT, (Object)0);
        builder.define(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        builder.define(DATA_CONTAINER, (Object)ItemStack.EMPTY);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    /*
     * Unable to fully structure code
     */
    public boolean hurt(DamageSource pSource, float pAmount) {
        block6: {
            if (this.level().isClientSide || this.isRemoved()) break block6;
            if (this.isInvulnerableTo(pSource)) {
                return false;
            }
            this.setHurtTime(10);
            this.markHurt();
            this.setDamage(this.getDamage() + pAmount * 10.0f);
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, pSource.getEntity());
            var5_3 = pSource.getEntity();
            if (!(var5_3 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var5_3;
            if (player.getAbilities().instabuild) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = flag = false;
            }
            if (flag || this.getDamage() > 15.0f) {
                this.ejectPassengers();
                if (flag && !this.hasCustomName()) {
                    this.discard();
                } else {
                    this.destroy(pSource);
                }
            }
        }
        return true;
    }

    public void destroy(DamageSource pSource) {
        Entity entity;
        Level level = this.level();
        if (level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) && !level.isClientSide && (entity = pSource.getDirectEntity()) != null && entity.getType() == EntityType.PLAYER) {
            PiglinAi.angerNearbyPiglins((Player)((Player)entity), (boolean)true);
        }
        this.remove(Entity.RemovalReason.KILLED);
    }

    public void spawnDrops() {
        ItemStack stack = this.getContainerItem().copy();
        if (this.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        if (ContainerHolderEntity.isContainerWithNBT(this.getContainerItem())) {
            stack.set(ModRegistry.CONTAINER_BLOCK_ENTITY_TAG.get(), (Object)this.innerBlockEntity.saveWithoutMetadata((HolderLookup.Provider)this.registryAccess()));
        } else {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this.innerBlockEntity);
        }
        this.spawnAtLocation(stack);
    }

    public void animateHurt(float hurtYaw) {
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public void tick() {
        Entity v = this.getVehicle();
        if (v != null) {
            if (this.getHurtTime() > 0) {
                this.setHurtTime(this.getHurtTime() - 1);
            }
            if (this.getDamage() > 0.0f) {
                this.setDamage(this.getDamage() - 1.0f);
            }
            this.checkBelowWorld();
            this.handlePortal();
            super.tick();
        } else if (!this.level().isClientSide) {
            this.destroy(this.damageSources().generic());
        }
    }

    public void setDamage(float pDamage) {
        this.entityData.set(DATA_ID_DAMAGE, (Object)Float.valueOf(pDamage));
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int pRollingAmplitude) {
        this.entityData.set(DATA_ID_HURT, (Object)pRollingAmplitude);
    }

    public int getHurtTime() {
        return (Integer)this.entityData.get(DATA_ID_HURT);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"message.snowyspirit.container_entity_name", (Object[])new Object[]{this.getContainerItem().getItem().getDescription().getString()});
    }

    public void remove(Entity.RemovalReason pReason) {
        if (!this.level().isClientSide && pReason.shouldDestroy() && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            this.spawnDrops();
        }
        super.remove(pReason);
    }

    public InteractionResult interact(Player pPlayer, InteractionHand pHand) {
        InteractionResult ret = super.interact(pPlayer, pHand);
        if (ret.consumesAction()) {
            return ret;
        }
        if (!pPlayer.level().isClientSide) {
            boolean isSack = ContainerHolderEntity.isSack(this.getContainerItem().getItem());
            if (isSack) {
                SuppCompat.openSackMenu((ServerPlayer)pPlayer, this);
            } else {
                PlatHelper.openCustomMenu((ServerPlayer)((ServerPlayer)pPlayer), (Entity)this);
            }
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)pPlayer);
            PiglinAi.angerNearbyPiglins((Player)pPlayer, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public float getWeightFromItems() {
        return (float)AbstractContainerMenu.getRedstoneSignalFromContainer((Container)this.innerBlockEntity) / 15.0f;
    }

    public static boolean isValidContainer(ItemStack stack) {
        return ContainerHolderEntity.isNormalContainer(stack) || ContainerHolderEntity.isContainerWithNBT(stack);
    }

    private static boolean isNormalContainer(ItemStack stack) {
        return stack.is(ModTags.VALID_CONTAINERS) && stack.getItem() instanceof BlockItem;
    }

    private static boolean isContainerWithNBT(ItemStack stack) {
        Item i = stack.getItem();
        return ContainerHolderEntity.isShulkerBox(i) || ContainerHolderEntity.isSack(i);
    }

    private static boolean isShulkerBox(Item i) {
        BlockItem bi;
        return i instanceof BlockItem && (bi = (BlockItem)i).getBlock() instanceof ShulkerBoxBlock;
    }

    private static boolean isSack(Item i) {
        return SnowySpirit.SUPPLEMENTARIES_INSTALLED && SuppCompat.isSack(i);
    }

    public int getContainerSize() {
        return this.innerBlockEntity.getContainerSize();
    }

    public boolean isEmpty() {
        return this.innerBlockEntity.isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.innerBlockEntity.getItem(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.innerBlockEntity.removeItem(slot, amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.innerBlockEntity.removeItemNoUpdate(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.innerBlockEntity.setItem(slot, stack);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        if (this.isRemoved()) {
            return false;
        }
        return player.distanceToSqr((Entity)this) <= 64.0;
    }

    public void clearContent() {
        this.innerBlockEntity.clearContent();
    }

    public void setLootTable(ResourceLocation res, long seed) {
        BaseContainerBlockEntity baseContainerBlockEntity = this.innerBlockEntity;
        if (baseContainerBlockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity r = (RandomizableContainerBlockEntity)baseContainerBlockEntity;
            r.setLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)res), seed);
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory pPlayerInventory, Player player) {
        if (ContainerHolderEntity.isSack(this.getContainerItem().getItem())) {
            return SuppCompat.createSackMenu(id, pPlayerInventory, this);
        }
        if (!ContainerHolderEntity.isNormalContainer(this.getContainerItem())) {
            return new ShulkerBoxMenu(id, pPlayerInventory, (Container)this);
        }
        return ChestMenu.threeRows((int)id, (Inventory)pPlayerInventory, (Container)this);
    }
}

