/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.core.client.MLRenderTypes;
import net.mehvahdjukaar.snowyspirit.configs.ClientConfigs;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class GlowLightParticle
extends TextureSheetParticle {
    private final float scale;
    private float oldQuadSize;
    private final float deltaRot;
    protected final SpriteSet sprites;
    private static final ParticleRenderType RT = MLRenderTypes.PARTICLE_ADDITIVE_TRANSLUCENCY_RENDER_TYPE;

    private GlowLightParticle(ClientLevel arg, double d, double e, double f, SpriteSet sprites) {
        super(arg, d, e, f);
        this.sprites = sprites;
        this.gravity = 0.0f;
        this.lifetime = 19 + this.random.nextInt(12);
        this.hasPhysics = false;
        this.alpha = 0.0f;
        this.quadSize = 0.0f;
        this.bbHeight = 0.2f;
        this.bbWidth = 0.2f;
        this.deltaRot = MthUtils.nextWeighted((RandomSource)this.random, (float)0.03f, (float)500.0f);
        this.scale = 0.05f + MthUtils.nextWeighted((RandomSource)this.random, (float)0.15f, (float)1.0f);
        this.roll = (float)(Math.PI * (double)this.random.nextFloat());
    }

    protected void renderRotatedQuad(VertexConsumer buffer, Quaternionf quaternionf, float x, float y, float z, float partialTicks) {
        this.setSprite(this.sprites.get(0, 3));
        int lightColor = this.getLightColor(partialTicks);
        float size = this.getQuadSize(partialTicks);
        int mode = ClientConfigs.PARTICLE_MODE.get() - 1;
        PoseStack poseStack = new PoseStack();
        poseStack.translate(x, y, z);
        poseStack.mulPose(quaternionf);
        Matrix4f matrix4f = poseStack.last().pose();
        if (mode == 0) {
            GlowLightParticle.renderQuad(this.sprite, buffer, lightColor, matrix4f, size, this.rCol, this.gCol, this.bCol, this.alpha * 0.4f);
            this.setSprite(this.sprites.get(2, 3));
            GlowLightParticle.renderQuad(this.sprite, buffer, lightColor, matrix4f, size, 0.5f + this.rCol / 2.0f, 0.5f + this.gCol / 2.0f, 0.5f + this.bCol / 2.0f, this.alpha * 0.6f);
        } else if (mode == 1) {
            GlowLightParticle.renderQuad(this.sprite, buffer, lightColor, matrix4f, size * 1.5f, this.rCol, this.gCol, this.bCol, this.alpha * 0.3f);
            GlowLightParticle.renderQuad(this.sprite, buffer, lightColor, matrix4f, size, 0.5f + this.rCol / 2.0f, 0.5f + this.gCol / 2.0f, 0.5f + this.bCol / 2.0f, this.alpha * 0.4f);
            this.setSprite(this.sprites.get(2, 3));
            GlowLightParticle.renderQuad(this.sprite, buffer, lightColor, matrix4f, size, 1.0f, 1.0f, 1.0f, this.alpha * 0.3f);
        } else if (mode == 2) {
            GlowLightParticle.renderQuad(this.sprite, buffer, lightColor, matrix4f, size, this.rCol, this.gCol, this.bCol, this.alpha * 0.8f);
            this.setSprite(this.sprites.get(2, 3));
            GlowLightParticle.renderQuad(this.sprite, buffer, lightColor, matrix4f, size, 1.0f, 1.0f, 1.0f, this.alpha * 0.3f);
        }
        this.setSprite(this.sprites.get(3, 3));
        GlowLightParticle.renderQuad(this.sprite, buffer, lightColor, matrix4f, size, 1.0f, 1.0f, 1.0f, this.alpha * 0.5f);
    }

    private static void renderQuad(TextureAtlasSprite sprite, VertexConsumer buffer, int lightColor, Matrix4f pose, float size, float rCol, float gCol, float bCol, float alpha) {
        float u0 = sprite.getU0();
        float u1 = sprite.getU1();
        float v0 = sprite.getV0();
        float v1 = sprite.getV1();
        u1 = u0 + (u1 - u0) * 7.0f / 8.0f;
        v1 = v0 + (v1 - v0) * 7.0f / 8.0f;
        buffer.addVertex(pose, 1.0f * size, -1.0f * size, 0.0f).setUv(u1, v1).setColor(rCol, gCol, bCol, alpha).setLight(lightColor);
        buffer.addVertex(pose, 1.0f * size, 1.0f * size, 0.0f).setUv(u1, v0).setColor(rCol, gCol, bCol, alpha).setLight(lightColor);
        buffer.addVertex(pose, -1.0f * size, 1.0f * size, 0.0f).setUv(u0, v0).setColor(rCol, gCol, bCol, alpha).setLight(lightColor);
        buffer.addVertex(pose, -1.0f * size, -1.0f * size, 0.0f).setUv(u0, v1).setColor(rCol, gCol, bCol, alpha).setLight(lightColor);
    }

    public ParticleRenderType getRenderType() {
        return RT;
    }

    public float getQuadSize(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.oldQuadSize, (float)this.quadSize);
    }

    public void tick() {
        super.tick();
        float sin = Mth.sin((float)((float)(Math.PI * (double)this.age / (double)this.lifetime)));
        this.alpha = (float)Math.pow(sin, 0.2);
        this.oldQuadSize = this.quadSize;
        this.quadSize = (float)((double)this.scale * Math.pow(sin, 0.4));
        this.oRoll = this.roll;
        this.roll += this.deltaRot;
    }

    protected int getLightColor(float partialTick) {
        int i = super.getLightColor(partialTick);
        int k = i >> 16 & 0xFF;
        int a = (int)(255.0f * Mth.sin((float)((float)(Math.PI * (double)this.age / (double)this.lifetime))));
        return a | k << 16;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double reg, double green, double blue) {
            GlowLightParticle p = new GlowLightParticle(level, x, y, z, this.sprites);
            p.setColor((float)reg, (float)green, (float)blue);
            return p;
        }
    }
}

