/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import mcjty.lostcities.worldgen.lost.regassets.IAsset;
import mcjty.lostcities.worldgen.lost.regassets.PaletteRE;
import mcjty.lostcities.worldgen.lost.regassets.data.PartRef;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BuildingRE
implements IAsset<BuildingRE> {
    public static final Codec<BuildingRE> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("refpalette").forGetter(l -> Optional.ofNullable(l.refPaletteName)), (App)PaletteRE.CODEC.optionalFieldOf("palette").forGetter(l -> Optional.ofNullable(l.localPalette)), (App)Codec.STRING.fieldOf("filler").forGetter(l -> Character.toString(l.fillerBlock)), (App)Codec.STRING.optionalFieldOf("rubble").forGetter(l -> Optional.ofNullable(l.rubbleBlock)), (App)Codec.INT.optionalFieldOf("mincellars").forGetter(l -> l.minCellars == -1 ? Optional.empty() : Optional.of(l.minCellars)), (App)Codec.INT.optionalFieldOf("minfloors").forGetter(l -> l.minFloors == -1 ? Optional.empty() : Optional.of(l.minFloors)), (App)Codec.INT.optionalFieldOf("maxcellars").forGetter(l -> l.maxCellars == -1 ? Optional.empty() : Optional.of(l.maxCellars)), (App)Codec.INT.optionalFieldOf("maxfloors").forGetter(l -> l.maxFloors == -1 ? Optional.empty() : Optional.of(l.maxFloors)), (App)Codec.BOOL.optionalFieldOf("allowDoors").forGetter(l -> Optional.ofNullable(l.getAllowDoors())), (App)Codec.BOOL.optionalFieldOf("allowFillers").forGetter(l -> Optional.ofNullable(l.getAllowFillers())), (App)Codec.BOOL.optionalFieldOf("overrideFloors").forGetter(l -> Optional.ofNullable(l.getOverrideFloors())), (App)Codec.FLOAT.optionalFieldOf("preferslonely").forGetter(l -> l.prefersLonely == 0.0f ? Optional.empty() : Optional.of(Float.valueOf(l.prefersLonely))), (App)Codec.list(PartRef.CODEC).fieldOf("parts").forGetter(l -> l.parts), (App)Codec.list(PartRef.CODEC).optionalFieldOf("parts2").forGetter(l -> Optional.ofNullable(l.parts2))).apply((Applicative)instance, BuildingRE::new));
    private ResourceLocation name;
    private int minFloors = -1;
    private int minCellars = -1;
    private int maxFloors = -1;
    private int maxCellars = -1;
    private Boolean allowDoors = true;
    private Boolean allowFillers = true;
    private Boolean overrideFloors = false;
    private final char fillerBlock;
    private final String rubbleBlock;
    private float prefersLonely = 0.0f;
    private PaletteRE localPalette = null;
    private final String refPaletteName;
    private final List<PartRef> parts;
    private final List<PartRef> parts2;

    public BuildingRE(Optional<String> refpalette, Optional<PaletteRE> locpalette, String filler, Optional<String> rubble, Optional<Integer> minCellars, Optional<Integer> minFloors, Optional<Integer> maxCellars, Optional<Integer> maxFloors, Optional<Boolean> allowDoors, Optional<Boolean> allowFillers, Optional<Boolean> overrideFloors, Optional<Float> prefersLonely, List<PartRef> partRefs, Optional<List<PartRef>> partRefs2) {
        this.refPaletteName = refpalette.orElse(null);
        this.localPalette = locpalette.orElse(null);
        this.fillerBlock = filler.charAt(0);
        this.rubbleBlock = rubble.orElse(null);
        this.minCellars = minCellars.orElse(-1);
        this.maxCellars = maxCellars.orElse(-1);
        this.minFloors = minFloors.orElse(-1);
        this.maxFloors = maxFloors.orElse(-1);
        this.allowDoors = allowDoors.orElse(true);
        this.allowFillers = allowFillers.orElse(true);
        this.overrideFloors = overrideFloors.orElse(false);
        this.prefersLonely = prefersLonely.orElse(Float.valueOf(0.0f)).floatValue();
        this.parts = partRefs;
        this.parts2 = partRefs2.orElse(null);
    }

    @Override
    public BuildingRE setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public int getMinFloors() {
        return this.minFloors;
    }

    public int getMinCellars() {
        return this.minCellars;
    }

    public int getMaxFloors() {
        return this.maxFloors;
    }

    public int getMaxCellars() {
        return this.maxCellars;
    }

    public Boolean getAllowDoors() {
        return this.allowDoors;
    }

    public Boolean getAllowFillers() {
        return this.allowFillers;
    }

    public Boolean getOverrideFloors() {
        return this.overrideFloors;
    }

    public char getFillerBlock() {
        return this.fillerBlock;
    }

    public Character getRubbleBlock() {
        return this.rubbleBlock == null ? null : Character.valueOf(this.rubbleBlock.charAt(0));
    }

    public float getPrefersLonely() {
        return this.prefersLonely;
    }

    public PaletteRE getLocalPalette() {
        return this.localPalette;
    }

    public String getRefPaletteName() {
        return this.refPaletteName;
    }

    public List<PartRef> getParts() {
        return this.parts;
    }

    public List<PartRef> getParts2() {
        return this.parts2;
    }
}

