/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.cityassets.WorldStyle;
import mcjty.lostcities.worldgen.lost.regassets.data.WorldSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class ChunkFixer {
    private static void executePostTodo(ChunkCoord coord, IDimensionInfo provider) {
        BuildingInfo info = BuildingInfo.getBuildingInfo(coord, provider);
        info.getPostTodo().forEach((pos, runnable) -> runnable.run());
        info.clearPostTodo();
    }

    private static void generateVines(ChunkCoord coord, LevelAccessor world, IDimensionInfo provider) {
        int x;
        int y;
        int z;
        BlockState state;
        int bottom;
        BuildingInfo adjacent;
        float vineChance = provider.getProfile().VINE_CHANCE;
        if ((double)vineChance < 1.0E-6) {
            return;
        }
        int chunkX = coord.chunkX();
        int chunkZ = coord.chunkZ();
        int cx = chunkX << 4;
        int cz = chunkZ << 4;
        BuildingInfo info = BuildingInfo.getBuildingInfo(coord, provider);
        int maxHeight = info.getMaxHeight();
        WorldStyle worldStyle = provider.getWorldStyle();
        WorldSettings worldSettings = worldStyle.getWorldSettings();
        if (info.hasBuilding && world.getChunk(coord.chunkX() + 1, coord.chunkZ()).getPersistedStatus().isOrAfter(ChunkStatus.FEATURES)) {
            adjacent = info.getXmax();
            bottom = Math.max(adjacent.getCityGroundLevel() + 3, adjacent.hasBuilding ? adjacent.getMaxHeight() : adjacent.getCityGroundLevel() + 3);
            state = worldSettings.vineWest();
            for (z = 0; z < 15; ++z) {
                for (y = bottom; y < maxHeight; ++y) {
                    if (!(world.getRandom().nextFloat() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, state, new BlockPos(cx + 16, y, cz + z), new BlockPos(cx + 15, y, cz + z));
                }
            }
        }
        if (info.getXmax().hasBuilding && world.getChunk(chunkX + 1, chunkZ).getPersistedStatus().isOrAfter(ChunkStatus.FEATURES)) {
            adjacent = info.getXmax();
            bottom = Math.max(info.getCityGroundLevel() + 3, info.hasBuilding ? maxHeight : info.getCityGroundLevel() + 3);
            state = worldSettings.vineEast();
            for (z = 0; z < 15; ++z) {
                for (y = bottom; y < adjacent.getMaxHeight(); ++y) {
                    if (!(world.getRandom().nextFloat() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, state, new BlockPos(cx + 15, y, cz + z), new BlockPos(cx + 16, y, cz + z));
                }
            }
        }
        if (info.hasBuilding && world.getChunk(chunkX, chunkZ + 1).getPersistedStatus().isOrAfter(ChunkStatus.FEATURES)) {
            adjacent = info.getZmax();
            bottom = Math.max(adjacent.getCityGroundLevel() + 3, adjacent.hasBuilding ? adjacent.getMaxHeight() : adjacent.getCityGroundLevel() + 3);
            state = worldSettings.vineNorth();
            for (x = 0; x < 15; ++x) {
                for (y = bottom; y < maxHeight; ++y) {
                    if (!(world.getRandom().nextFloat() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, state, new BlockPos(cx + x, y, cz + 16), new BlockPos(cx + x, y, cz + 15));
                }
            }
        }
        if (info.getZmax().hasBuilding && world.getChunk(chunkX, chunkZ + 1).getPersistedStatus().isOrAfter(ChunkStatus.FEATURES)) {
            adjacent = info.getZmax();
            bottom = Math.max(info.getCityGroundLevel() + 3, info.hasBuilding ? maxHeight : info.getCityGroundLevel() + 3);
            state = worldSettings.vineSouth();
            for (x = 0; x < 15; ++x) {
                for (y = bottom; y < adjacent.getMaxHeight(); ++y) {
                    if (!(world.getRandom().nextFloat() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, state, new BlockPos(cx + x, y, cz + 15), new BlockPos(cx + x, y, cz + 16));
                }
            }
        }
    }

    private static void createVineStrip(LevelAccessor world, int bottom, BlockState state, BlockPos pos, BlockPos vineHolderPos) {
        if (world.isEmptyBlock(vineHolderPos)) {
            return;
        }
        if (!world.isEmptyBlock(pos)) {
            return;
        }
        world.setBlock(pos, state, 0);
        pos = pos.below();
        while (pos.getY() >= bottom && world.getRandom().nextFloat() < 0.8f) {
            if (!world.isEmptyBlock(pos)) {
                return;
            }
            world.setBlock(pos, state, 0);
            pos = pos.below();
        }
    }

    public static void fix(IDimensionInfo info, ChunkCoord coord) {
        ChunkFixer.generateVines(coord, (LevelAccessor)info.getWorld(), info);
        ChunkFixer.executePostTodo(coord, info);
    }
}

