/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.setup;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.commands.ModCommands;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.setup.ModSetup;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.ComponentFactory;
import mcjty.lostcities.varia.CustomTeleporter;
import mcjty.lostcities.varia.WorldTools;
import mcjty.lostcities.worldgen.GlobalTodo;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import mcjty.lostcities.worldgen.lost.BiomeInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.City;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.Highway;
import mcjty.lostcities.worldgen.lost.MultiChunk;
import mcjty.lostcities.worldgen.lost.Railway;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.PredefinedCity;
import mcjty.lostcities.worldgen.lost.cityassets.PredefinedSphere;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class ForgeEventHandlers {
    private final Map<ResourceKey<Level>, BlockPos> spawnPositions = new HashMap<ResourceKey<Level>, BlockPos>();

    @SubscribeEvent
    public void commandRegister(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onPlayerFirstJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerLevel level = serverPlayer.serverLevel();
        ResourceKey dimKey = level.dimension();
        if (this.spawnPositions.containsKey(dimKey)) {
            BlockPos correctPos = this.spawnPositions.get(dimKey);
            BlockPos currentWorldSpawn = level.getSharedSpawnPos();
            if (!currentWorldSpawn.equals((Object)correctPos)) {
                level.setDefaultSpawnPos(correctPos, 0.0f);
                LevelData levelData = level.getLevelData();
                if (levelData instanceof ServerLevelData) {
                    ServerLevelData data = (ServerLevelData)levelData;
                    data.setSpawn(correctPos, 0.0f);
                }
                serverPlayer.teleportTo(level, (double)correctPos.getX() + 0.5, (double)correctPos.getY(), (double)correctPos.getZ() + 0.5, serverPlayer.getYRot(), serverPlayer.getXRot());
                this.spawnPositions.remove(dimKey);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AssetRegistries.load((CommonLevelAccessor)serverLevel);
            GlobalTodo.get(event.getLevel()).executeAndClearTodo(serverLevel);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerAboutToStartEvent event) {
        ForgeEventHandlers.cleanUp();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        ForgeEventHandlers.cleanUp();
        Config.reset();
    }

    public static void cleanUp() {
        Config.resetProfileCache();
        BuildingInfo.cleanCache();
        MultiChunk.cleanCache();
        Highway.cleanCache();
        Railway.cleanCache();
        BiomeInfo.cleanCache();
        City.cleanCache();
        CitySphere.cleanCache();
    }

    @SubscribeEvent
    public void onCreateSpawnPoint(LevelEvent.CreateSpawnPosition event) {
        LevelAccessor world = event.getLevel();
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            IDimensionInfo dimensionInfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo((WorldGenLevel)serverLevel);
            if (dimensionInfo == null) {
                return;
            }
            LostCityProfile profile = dimensionInfo.getProfile();
            Predicate<BlockPos> isSuitable = pos -> true;
            boolean needsCheck = false;
            if (!profile.SPAWN_BIOME.isEmpty()) {
                Biome spawnBiome = (Biome)serverLevel.registryAccess().registryOrThrow(Registries.BIOME).get(ResourceLocation.parse((String)profile.SPAWN_BIOME));
                if (spawnBiome == null) {
                    ModSetup.getLogger().error("Cannot find biome '{}' for the player to spawn in !", (Object)profile.SPAWN_BIOME);
                } else {
                    isSuitable = blockPos -> world.getBiome(blockPos).value() == spawnBiome;
                    needsCheck = true;
                }
            } else if (!profile.SPAWN_CITY.isEmpty()) {
                PredefinedCity city = AssetRegistries.PREDEFINED_CITIES.get((CommonLevelAccessor)world, profile.SPAWN_CITY);
                if (city == null) {
                    ModSetup.getLogger().error("Cannot find city '{}' for the player to spawn in !", (Object)profile.SPAWN_CITY);
                } else {
                    sqradius = this.getSqRadius(city.getRadius(), 0.8f);
                    isSuitable = blockPos -> city.getDimension() == serverLevel.dimension() && CitySphere.squaredDistance(city.getChunkX() * 16 + 8, city.getChunkZ() * 16 + 8, blockPos.getX(), blockPos.getZ()) < (double)sqradius;
                    needsCheck = true;
                }
            } else if (!profile.SPAWN_SPHERE.isEmpty()) {
                if ("<in>".equals(profile.SPAWN_SPHERE)) {
                    isSuitable = blockPos -> {
                        ChunkCoord coord = new ChunkCoord(dimensionInfo.getType(), blockPos.getX() >> 4, blockPos.getZ() >> 4);
                        CitySphere sphere = CitySphere.getCitySphere(coord, dimensionInfo);
                        if (!sphere.isEnabled()) {
                            return false;
                        }
                        float sqradius = this.getSqRadius((int)sphere.getRadius(), 0.8f);
                        return sphere.getCenterPos().distSqr((Vec3i)blockPos.atY(sphere.getCenterPos().getY())) < (double)sqradius;
                    };
                    needsCheck = true;
                } else if ("<out>".equals(profile.SPAWN_SPHERE)) {
                    isSuitable = blockPos -> {
                        ChunkCoord coord = new ChunkCoord(dimensionInfo.getType(), blockPos.getX() >> 4, blockPos.getZ() >> 4);
                        CitySphere sphere = CitySphere.getCitySphere(coord, dimensionInfo);
                        if (!sphere.isEnabled()) {
                            return true;
                        }
                        float sqradius = sphere.getRadius() * sphere.getRadius();
                        return sphere.getCenterPos().distSqr((Vec3i)blockPos.atY(sphere.getCenterPos().getY())) > (double)sqradius;
                    };
                    needsCheck = true;
                } else {
                    PredefinedSphere sphere = AssetRegistries.PREDEFINED_SPHERES.get((CommonLevelAccessor)world, profile.SPAWN_SPHERE);
                    if (sphere == null) {
                        LostCities.setup.getLogger().error("Cannot find sphere '" + profile.SPAWN_SPHERE + "' for the player to spawn in !");
                    } else {
                        sqradius = this.getSqRadius(sphere.getRadius(), 0.8f);
                        isSuitable = blockPos -> sphere.getDimension() == serverLevel.dimension() && CitySphere.squaredDistance((sphere.getChunkX() << 4) + 8, (sphere.getChunkZ() << 4) + 8, blockPos.getX(), blockPos.getZ()) < (double)sqradius;
                        needsCheck = true;
                    }
                }
            }
            if (profile.SPAWN_NOT_IN_BUILDING) {
                isSuitable = isSuitable.and(blockPos -> this.isOutsideBuilding(dimensionInfo, (BlockPos)blockPos));
                needsCheck = true;
            } else if (profile.FORCE_SPAWN_BUILDINGS.length > 0 || profile.FORCE_SPAWN_PARTS.length > 0) {
                Set<String> buildings = Set.of(profile.FORCE_SPAWN_BUILDINGS);
                Set<String> parts = Set.of(profile.FORCE_SPAWN_PARTS);
                isSuitable = isSuitable.and(blockPos -> {
                    ChunkCoord coord = new ChunkCoord(dimensionInfo.getType(), blockPos.getX() >> 4, blockPos.getZ() >> 4);
                    BuildingInfo info = BuildingInfo.getBuildingInfo(coord, dimensionInfo);
                    if (info == null) {
                        return false;
                    }
                    if (info.isCity() && info.hasBuilding) {
                        BuildingPart part;
                        int lowestLevel;
                        if (!buildings.isEmpty() && !buildings.contains(info.buildingType.getId().toString())) {
                            return false;
                        }
                        return parts.isEmpty() || (lowestLevel = info.getBuildingBottomHeight()) == Integer.MIN_VALUE || (part = info.getFloorAtY(lowestLevel, blockPos.getY())) != null && parts.contains(part.getId().toString());
                    }
                    return false;
                });
                needsCheck = true;
            } else if (profile.FORCE_SPAWN_IN_BUILDING) {
                isSuitable = isSuitable.and(blockPos -> !this.isOutsideBuilding(dimensionInfo, (BlockPos)blockPos));
                needsCheck = true;
            }
            switch (profile.LANDSCAPE_TYPE) {
                case DEFAULT: 
                case SPHERES: {
                    if (!needsCheck) break;
                    BlockPos pos2 = this.findSafeSpawnPoint((Level)serverLevel, dimensionInfo, isSuitable, event.getSettings());
                    serverLevel.setDefaultSpawnPos(pos2, 0.0f);
                    event.getSettings().setSpawn(pos2, 0.0f);
                    this.spawnPositions.put((ResourceKey<Level>)serverLevel.dimension(), pos2);
                    event.setCanceled(true);
                    break;
                }
                case FLOATING: 
                case SPACE: 
                case CAVERN: 
                case CAVERNSPHERES: {
                    BlockPos pos2 = this.findSafeSpawnPoint((Level)serverLevel, dimensionInfo, isSuitable, event.getSettings());
                    serverLevel.setDefaultSpawnPos(pos2, 0.0f);
                    event.getSettings().setSpawn(pos2, 0.0f);
                    this.spawnPositions.put((ResourceKey<Level>)serverLevel.dimension(), pos2);
                    event.setCanceled(true);
                }
            }
        }
    }

    private boolean isOutsideBuilding(IDimensionInfo provider, BlockPos pos) {
        ChunkCoord coord = new ChunkCoord(provider.getType(), pos.getX() >> 4, pos.getZ() >> 4);
        BuildingInfo info = BuildingInfo.getBuildingInfo(coord, provider);
        return !info.isCity() || !info.hasBuilding;
    }

    private int getSqRadius(int radius, float pct) {
        return (int)((float)radius * pct * ((float)radius * pct));
    }

    private BlockPos findSafeSpawnPoint(Level world, IDimensionInfo provider, @Nonnull Predicate<BlockPos> isSuitable, @Nonnull ServerLevelData serverLevelData) {
        Random rand = new Random(provider.getSeed());
        int radius = provider.getProfile().SPAWN_CHECK_RADIUS;
        int attempts = 0;
        do {
            for (int i = 0; i < 200; ++i) {
                int x = rand.nextInt(radius * 2) - radius;
                int z = rand.nextInt(radius * 2) - radius;
                ++attempts;
                if (!isSuitable.test(new BlockPos(x, 128, z))) continue;
                ChunkCoord coord = new ChunkCoord(provider.getType(), x >> 4, z >> 4);
                LostCityProfile profile = BuildingInfo.getProfile(coord, provider);
                for (int y = profile.GROUNDLEVEL - 5; y < 125; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!this.isValidStandingPosition(world, pos)) continue;
                    return pos.above();
                }
            }
            radius += provider.getProfile().SPAWN_RADIUS_INCREASE;
        } while (attempts <= provider.getProfile().SPAWN_CHECK_ATTEMPTS);
        LostCities.setup.getLogger().error("Can't find a valid spawn position!");
        throw new RuntimeException("Can't find a valid spawn position!");
    }

    private boolean isValidStandingPosition(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (!state.isFaceSturdy((BlockGetter)world, pos, Direction.UP)) {
            return false;
        }
        if (state.is(Blocks.BEDROCK)) {
            return false;
        }
        return world.getBlockState(pos.above()).isAir() && world.getBlockState(pos.above(2)).isAir();
    }

    private boolean isValidSpawnBed(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (!(state.getBlock() instanceof BedBlock)) {
            return false;
        }
        Direction direction = Blocks.BLACK_BED.getBedDirection(state, (LevelReader)world, pos);
        Block b1 = world.getBlockState(pos.below()).getBlock();
        Block b2 = world.getBlockState(pos.relative(direction.getOpposite()).below()).getBlock();
        Block b = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)((String)Config.SPECIAL_BED_BLOCK.get())));
        if (b1 != b || b2 != b) {
            return false;
        }
        if (!(world.getBlockState(pos.relative(direction)).getBlock() instanceof AbstractSkullBlock)) {
            return false;
        }
        if (!(world.getBlockState(pos.relative(direction.getClockWise())).getBlock() instanceof AbstractSkullBlock)) {
            return false;
        }
        if (!(world.getBlockState(pos.relative(direction.getCounterClockWise())).getBlock() instanceof AbstractSkullBlock)) {
            return false;
        }
        if (!(world.getBlockState(pos.relative(direction.getOpposite(), 2)).getBlock() instanceof AbstractSkullBlock)) {
            return false;
        }
        if (!(world.getBlockState(pos.relative(direction.getOpposite()).relative(direction.getOpposite().getClockWise())).getBlock() instanceof AbstractSkullBlock)) {
            return false;
        }
        return world.getBlockState(pos.relative(direction.getOpposite()).relative(direction.getOpposite().getCounterClockWise())).getBlock() instanceof AbstractSkullBlock;
    }

    private BlockPos findValidTeleportLocation(Level world, BlockPos start) {
        int y;
        int chunkZ;
        int chunkX = start.getX() >> 4;
        BlockPos pos = this.findValidTeleportLocation(world, chunkX, chunkZ = start.getZ() >> 4, y = start.getY());
        if (pos != null) {
            return pos;
        }
        for (int r = 1; r < 50; ++r) {
            for (int i = -r; i < r; ++i) {
                pos = this.findValidTeleportLocation(world, chunkX + i, chunkZ - r, y);
                if (pos != null) {
                    return pos;
                }
                pos = this.findValidTeleportLocation(world, chunkX + r, chunkZ + i, y);
                if (pos != null) {
                    return pos;
                }
                pos = this.findValidTeleportLocation(world, chunkX + r - i, chunkZ + r, y);
                if (pos != null) {
                    return pos;
                }
                pos = this.findValidTeleportLocation(world, chunkX - r, chunkZ + r - i, y);
                if (pos == null) continue;
                return pos;
            }
        }
        return null;
    }

    private BlockPos findValidTeleportLocation(Level world, int chunkX, int chunkZ, int y) {
        BlockPos bestSpot = null;
        for (int dy = 0; dy < 255; ++dy) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockPos p;
                    if (y + dy < 250) {
                        p = new BlockPos((chunkX << 4) + x, y + dy, (chunkZ << 4) + z);
                        if (this.isValidSpawnBed(world, p)) {
                            return p.above();
                        }
                        if (bestSpot == null && this.isValidStandingPosition(world, p)) {
                            bestSpot = p.above();
                        }
                    }
                    if (y - dy <= 1) continue;
                    p = new BlockPos((chunkX << 4) + x, y - dy, (chunkZ << 4) + z);
                    if (this.isValidSpawnBed(world, p)) {
                        return p.above();
                    }
                    if (bestSpot != null || !this.isValidStandingPosition(world, p)) continue;
                    bestSpot = p.above();
                }
            }
        }
        return bestSpot;
    }

    @SubscribeEvent
    public void onPlayerSleepInBedEvent(CanPlayerSleepEvent event) {
        Level world = event.getEntity().getCommandSenderWorld();
        if (world.isClientSide) {
            return;
        }
        BlockPos bedLocation = event.getPos();
        if (bedLocation == null || !this.isValidSpawnBed(world, bedLocation)) {
            return;
        }
        if (world.dimension() == Registration.DIMENSION) {
            event.setProblem(Player.BedSleepingProblem.OTHER_PROBLEM);
            ServerLevel destWorld = WorldTools.getOverworld(world);
            BlockPos location = this.findLocation(bedLocation, destWorld);
            CustomTeleporter.teleportToDimension((Player)event.getEntity(), destWorld, location);
        } else {
            event.setProblem(Player.BedSleepingProblem.OTHER_PROBLEM);
            ServerLevel destWorld = event.getEntity().getCommandSenderWorld().getServer().getLevel(Registration.DIMENSION);
            if (destWorld == null) {
                event.getEntity().sendSystemMessage((Component)ComponentFactory.literal("Error finding Lost City dimension: " + String.valueOf(Registration.LOSTCITY) + "!").withStyle(ChatFormatting.RED));
            } else {
                BlockPos location = this.findLocation(bedLocation, destWorld);
                CustomTeleporter.teleportToDimension((Player)event.getEntity(), destWorld, location);
            }
        }
    }

    private BlockPos findLocation(BlockPos bedLocation, ServerLevel destWorld) {
        BlockPos top;
        BlockPos location = top = bedLocation.above(5);
        while (top.getY() > 1 && destWorld.getBlockState(location).isAir()) {
            location = location.below();
        }
        if (destWorld.isEmptyBlock(location.below())) {
            destWorld.setBlockAndUpdate(bedLocation, Blocks.COBBLESTONE.defaultBlockState());
        }
        return location.above(1);
    }
}

