/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.setup;

import mcjty.lostcities.gui.GuiLCConfig;
import mcjty.lostcities.gui.LostCitySetup;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.varia.ComponentFactory;
import mcjty.lostcities.worldgen.LostCityFeature;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class ClientEventHandlers {
    private Button lostCitiesButton = null;
    private static final ResourceLocation txt = ResourceLocation.fromNamespaceAndPath((String)"lostcities", (String)"textures/gui/configicon.png");

    @SubscribeEvent
    public void onGuiDraw(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen screen2 = (CreateWorldScreen)screen;
            if (this.lostCitiesButton != null) {
                this.lostCitiesButton.visible = screen2.tabManager.getCurrentTab() instanceof CreateWorldScreen.MoreTab;
                if (this.lostCitiesButton.visible) {
                    event.getGuiGraphics().blit(txt, screen2.width - 100, 60, 70, 70, 256.0f, 256.0f, 256, 256, 256, 256);
                }
            }
        }
    }

    @SubscribeEvent
    public void onGuiPost(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen screen2 = (CreateWorldScreen)screen;
            this.lostCitiesButton = Button.builder((Component)ComponentFactory.literal("Cities"), p_onPress_1_ -> Minecraft.getInstance().setScreen((Screen)new GuiLCConfig((Screen)screen2))).bounds(screen2.width - 100, 40, 70, 20).build();
            this.lostCitiesButton.visible = false;
            event.addListener((GuiEventListener)this.lostCitiesButton);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        LostCitySetup.CLIENT_SETUP.reset();
        Config.reset();
        ++LostCityFeature.globalDimensionInfoDirtyCounter;
    }
}

