/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.lostcities.editor.EditModeData;
import mcjty.lostcities.editor.Editor;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.ComponentFactory;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;

public class CommandResumeEdit
implements Command<CommandSourceStack> {
    private static final CommandResumeEdit CMD = new CommandResumeEdit();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"resumeedit").requires(cs -> cs.hasPermission(1))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        BlockPos start = player.blockPosition();
        ServerLevel level = (ServerLevel)player.level();
        IDimensionInfo dimInfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo((WorldGenLevel)level);
        if (dimInfo == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ComponentFactory.literal("This dimension doesn't support Lost Cities!"));
            return 0;
        }
        if (!dimInfo.getProfile().EDITMODE) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ComponentFactory.literal("This world was not created with edit mode enabled. This command is not possible!"));
            return 0;
        }
        ChunkPos cp = new ChunkPos(start);
        for (EditModeData.PartData data : EditModeData.getData().getPartData(new ChunkCoord((ResourceKey<Level>)level.dimension(), cp.x, cp.z))) {
            BuildingPart part = AssetRegistries.PARTS.get((CommonLevelAccessor)level, data.partName());
            if (part == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)ComponentFactory.literal("Unknown part '" + data.partName() + "' in this chunk!"));
                return 0;
            }
            if (data.y() > start.getY() || start.getY() >= data.y() + part.getSliceCount()) continue;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ComponentFactory.literal("Start editing part '" + data.partName() + "'!"), false);
            Editor.startEditing(part, player, new BlockPos(start.getX(), data.y(), start.getZ()), level, dimInfo, false);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)ComponentFactory.literal("Could not find a part to edit in this chunk!"));
        return 0;
    }
}

