/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;

public class CommandMap
implements Command<CommandSourceStack> {
    private static final CommandMap CMD = new CommandMap();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"map").requires(cs -> cs.hasPermission(0))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        BlockPos position = player.blockPosition();
        IDimensionInfo dimInfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo((WorldGenLevel)player.level());
        if (dimInfo != null) {
            ChunkPos pos = new ChunkPos(position);
            for (int z = pos.z - 20; z <= pos.z + 20; ++z) {
                StringBuilder buf = new StringBuilder();
                for (int x = pos.x - 20; x <= pos.x + 20; ++x) {
                    ChunkCoord coord = new ChunkCoord(dimInfo.getType(), x, z);
                    BuildingInfo info = BuildingInfo.getBuildingInfo(coord, dimInfo);
                    if (info.isCity && info.hasBuilding) {
                        buf.append("B");
                        continue;
                    }
                    if (info.isCity) {
                        buf.append("+");
                        continue;
                    }
                    if (info.highwayXLevel >= 0 || info.highwayZLevel >= 0) {
                        buf.append(".");
                        continue;
                    }
                    buf.append(" ");
                }
                System.out.println(buf);
            }
        }
        return 0;
    }
}

