/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.TridentItem;
import net.salju.kobolds.entity.AbstractKoboldZombie;

public class ZomboldModel<T extends AbstractKoboldZombie>
extends HumanoidModel<T> {
    public ZomboldModel(ModelPart root) {
        super(root);
    }

    public void setupAnim(T kobold, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightArm.xRot = -1.5708f;
        this.leftArm.xRot = -1.5708f;
        this.rightArm.yRot = 0.0f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        this.body.xRot = 0.0f;
        this.body.yRot = 0.0f;
        this.body.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.rightArm.xRot += Mth.cos((float)(ageInTicks * 0.08f)) * 0.08f;
        this.leftArm.xRot -= Mth.cos((float)(ageInTicks * 0.08f)) * 0.08f;
        this.rightArm.zRot += Mth.cos((float)(ageInTicks * 0.08f)) * 0.08f + 0.05f;
        this.leftArm.zRot -= Mth.cos((float)(ageInTicks * 0.08f)) * 0.08f + 0.05f;
        if (kobold.isPassenger()) {
            this.rightLeg.xRot = -1.5708f;
            this.leftLeg.xRot = -1.5708f;
            this.rightLeg.yRot = 0.2618f;
            this.leftLeg.yRot = -0.2618f;
        }
        if (kobold.isAggressive()) {
            if (kobold.getMainHandItem().getItem() instanceof TridentItem) {
                if (kobold.isLeftHanded()) {
                    this.rightArm.xRot = -1.5708f;
                    this.leftArm.xRot = 2.8798f;
                    this.leftArm.zRot = 0.1309f;
                } else {
                    this.leftArm.xRot = -1.5708f;
                    this.rightArm.xRot = 2.8798f;
                    this.rightArm.zRot = -0.1309f;
                }
            } else {
                this.rightArm.xRot = -2.0944f;
                this.leftArm.xRot = -2.0944f;
            }
        }
        if (this.attackTime > 0.0f) {
            float progress = this.attackTime;
            progress = 1.0f - this.attackTime;
            progress *= progress;
            progress *= progress;
            progress = 1.0f - progress;
            float f2 = Mth.sin((float)(progress * (float)Math.PI));
            this.leftArm.xRot = (float)((double)this.leftArm.xRot - ((double)f2 / 1.2 - 1.0));
            this.rightArm.xRot = (float)((double)this.rightArm.xRot - ((double)f2 / 1.2 - 1.0));
        }
        this.hat.copyFrom(this.head);
    }

    public void translateToHand(HumanoidArm arm, PoseStack pose) {
        switch (arm) {
            case LEFT: {
                this.leftArm.translateAndRotate(pose);
                pose.translate(0.045, 0.096, 0.0);
                pose.scale(0.75f, 0.75f, 0.75f);
                break;
            }
            case RIGHT: {
                this.rightArm.translateAndRotate(pose);
                pose.translate(-0.045, 0.096, 0.0);
                pose.scale(0.75f, 0.75f, 0.75f);
            }
        }
    }
}

