/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class KoboldModel<T extends AbstractKoboldEntity>
extends HumanoidModel<T> {
    public KoboldModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = KoboldModel.createMesh(new CubeDeformation(0.0f), 0.0f);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public static MeshDefinition createMesh(CubeDeformation cube, float f) {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)cube, (float)f);
        PartDefinition root = mesh.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(22, 0).addBox(-2.5f, -3.0f, -6.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(1, 3).addBox(-0.5f, -3.85f, -5.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)-0.5f));
        root.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(0, 50).addBox(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.5f)).texOffs(17, 52).addBox(-6.0f, -5.2f, -6.0f, 12.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)-0.5f));
        head.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(36, 0).addBox(-0.5f, -4.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-7.0f, (float)2.0f, (float)-0.6109f, (float)0.3054f, (float)0.1745f));
        head.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(45, 0).addBox(-1.5f, -4.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-7.0f, (float)2.0f, (float)-0.6109f, (float)-0.3054f, (float)-0.1745f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(46, 16).addBox(-3.0f, -0.85f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)5.0f, (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(33, 16).addBox(0.0f, -0.85f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)5.0f, (float)0.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(13, 31).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)14.0f, (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 31).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)14.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(3, 15).addBox(-3.0f, 0.0f, -2.0f, 6.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(24, 15).addBox(-1.0f, 6.0f, -4.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        return mesh;
    }

    public void setupAnim(T kobold, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.rightArm.yRot = 0.0f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        this.body.xRot = 0.0f;
        this.body.yRot = 0.0f;
        this.body.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.rightArm.zRot += Mth.cos((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        this.leftArm.zRot -= Mth.cos((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        if (kobold.isPassenger()) {
            this.rightLeg.xRot = -1.5708f;
            this.leftLeg.xRot = -1.5708f;
            this.rightLeg.yRot = 0.2618f;
            this.leftLeg.yRot = -0.2618f;
        }
        if (!kobold.getMainHandItem().isEmpty()) {
            if (kobold.getMainHandItem().getItem() instanceof CrossbowItem || kobold.getMainHandItem().getItem() instanceof BowItem) {
                if (kobold.isAggressive()) {
                    if (kobold.isLeftHanded()) {
                        if (((AbstractKoboldEntity)((Object)kobold)).isCharging()) {
                            this.leftArm.xRot = -0.6981f;
                            this.leftArm.yRot = 0.3491f;
                            this.rightArm.xRot = -1.1345f;
                            this.rightArm.yRot = -0.5672f;
                        } else {
                            this.leftArm.xRot = -1.4399f;
                            this.leftArm.yRot = 0.2618f;
                            this.rightArm.xRot = -1.3963f;
                            this.rightArm.yRot = -0.3054f;
                        }
                    } else if (((AbstractKoboldEntity)((Object)kobold)).isCharging()) {
                        this.rightArm.xRot = -0.6981f;
                        this.rightArm.yRot = -0.3491f;
                        this.leftArm.xRot = -1.1345f;
                        this.leftArm.yRot = 0.5672f;
                    } else {
                        this.rightArm.xRot = -1.4399f;
                        this.rightArm.yRot = -0.2618f;
                        this.leftArm.xRot = -1.3963f;
                        this.leftArm.yRot = 0.3054f;
                    }
                }
            } else if (kobold.getMainHandItem().getItem() instanceof TridentItem) {
                if (kobold.isAggressive()) {
                    if (kobold.isLeftHanded()) {
                        this.leftArm.xRot = 2.8798f;
                        this.rightArm.xRot = 0.0f;
                    } else {
                        this.rightArm.xRot = 2.8798f;
                        this.leftArm.xRot = 0.0f;
                    }
                }
            } else if (kobold.isAggressive()) {
                if (kobold.isLeftHanded()) {
                    this.leftArm.xRot = -2.0944f;
                    this.leftArm.yRot = -0.1745f;
                } else {
                    this.rightArm.xRot = -2.0944f;
                    this.rightArm.yRot = 0.1745f;
                }
            }
        }
        if (!kobold.getOffhandItem().isEmpty()) {
            if (kobold.getOffhandItem().getItem() instanceof ShieldItem) {
                if (kobold.isBlocking()) {
                    if (kobold.isLeftHanded()) {
                        this.rightArm.xRot = -0.6981f;
                        this.rightArm.yRot = -0.2618f;
                    } else {
                        this.leftArm.xRot = -0.6981f;
                        this.leftArm.yRot = 0.2618f;
                    }
                }
            } else if (kobold.isLeftHanded()) {
                this.rightArm.xRot = -0.8727f;
                this.rightArm.yRot = 0.0873f;
                this.head.xRot = 0.1745f;
            } else {
                this.leftArm.xRot = -0.8727f;
                this.leftArm.yRot = 0.0873f;
                this.head.xRot = 0.1745f;
            }
        }
        if (this.attackTime > 0.0f) {
            if (kobold.isAggressive()) {
                if (kobold.isLeftHanded()) {
                    float progress = this.attackTime;
                    progress = 1.0f - this.attackTime;
                    progress *= progress;
                    progress *= progress;
                    progress = 1.0f - progress;
                    float f2 = Mth.sin((float)(progress * (float)Math.PI));
                    this.leftArm.xRot = (float)((double)this.leftArm.xRot - ((double)f2 / 1.2 - 1.0));
                } else {
                    float progress = this.attackTime;
                    progress = 1.0f - this.attackTime;
                    progress *= progress;
                    progress *= progress;
                    progress = 1.0f - progress;
                    float f2 = Mth.sin((float)(progress * (float)Math.PI));
                    this.rightArm.xRot = (float)((double)this.rightArm.xRot - ((double)f2 / 1.2 - 1.0));
                }
            } else {
                float progress = this.attackTime;
                this.body.yRot = Mth.sin((float)(Mth.sqrt((float)progress) * ((float)Math.PI * 2))) * 0.2f;
                this.rightArm.yRot += this.body.yRot;
                this.leftArm.yRot += this.body.yRot;
                this.leftArm.xRot += this.body.yRot;
                progress = 1.0f - this.attackTime;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = Mth.sin((float)(progress * (float)Math.PI));
                float f3 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
                this.rightArm.xRot = (float)((double)this.rightArm.xRot - ((double)f2 * 1.2 + (double)f3));
                this.rightArm.yRot += this.body.yRot * 2.0f;
                this.rightArm.zRot += Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
            }
        }
        this.hat.copyFrom(this.head);
    }

    public void translateToHand(HumanoidArm arm, PoseStack pose) {
        switch (arm) {
            case LEFT: {
                this.leftArm.translateAndRotate(pose);
                pose.translate(0.045, 0.096, 0.0);
                pose.scale(0.75f, 0.75f, 0.75f);
                break;
            }
            case RIGHT: {
                this.rightArm.translateAndRotate(pose);
                pose.translate(-0.045, 0.096, 0.0);
                pose.scale(0.75f, 0.75f, 0.75f);
            }
        }
    }
}

